#!/bin/sh

PKGVER=5.3.2
PKGDIR=`pwd`/pkg

rm -rf ImageMagick-${PKGVER}
tar zxvf ImageMagick-${PKGVER}.tar.gz
cd ImageMagick-${PKGVER}
patch -p1 <../ImageMagick-5.2.9-DESTDIR.patch
patch -p1 <../ImageMagick-5.2.9-RLE.patch
./configure --prefix=/usr --enable-shared --enable-lzw --without-perl
make

rm -rf $PKGDIR
make install DESTDIR=$PKGDIR
gzip $PKGDIR/usr/man/man1/*.1
gzip $PKGDIR/usr/man/man4/*.4
gzip $PKGDIR/usr/man/man5/*.5
mkdir -p $PKGDIR/usr/doc/ImageMagick-${PKGVER}
cp -p README.txt Manifest.ps $PKGDIR/usr/doc/ImageMagick-${PKGVER}/.
cp -p ../ImageMagick-5.2.9-DESTDIR.patch ../ImageMagick-5.2.9-RLE.patch ../plamobuild.sh $PKGDIR/usr/doc/ImageMagick-${PKGVER}/.
( cd $PKGDIR/usr/doc/ImageMagick-${PKGVER}
  ln -s ../../share/ImageMagick/Copyright.txt .
  ln -s ../../share/ImageMagick/QuickStart.txt .
  ln -s ../../share/ImageMagick/ImageMagick.html .
  ln -s ../../share/ImageMagick/www .
  ln -s ../../share/ImageMagick/images .
)
chown -R root:root $PKGDIR/usr/doc/ImageMagick-${PKGVER}
cd $PKGDIR
/sbin/makepkg ImageMagick-${PKGVER}.tgz <<EOF
y
y
EOF
