/*
 *  scan_dv.c
 *
 *  Copyright (C) Thomas streich - June 2001
 *
 *  This file is part of transcode, a linux video stream processing tool
 *      
 *  transcode is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  transcode is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/errno.h>
#include <errno.h>
#include <unistd.h>

#include "config.h"

#ifdef HAVE_DV
#include <libdv/dv.h>
#endif

int scan_header_dv(char *buf)
{
    int cc=-1;

#ifdef HAVE_DV
    
    dv_decoder_t *dv_decoder=NULL;

    // Initialize DV decoder

#ifdef LIBDV_095    
    if((dv_decoder = dv_decoder_new(TRUE, FALSE, FALSE))==NULL) {
	fprintf(stderr, "(%s) dv decoder init failed\n", __FILE__);
	return(-1);
    }
#else
    if((dv_decoder = dv_decoder_new())==NULL) {
	fprintf(stderr, "(%s) dv decoder init failed\n", __FILE__);
	return(-1);
    }
    dv_init();
#endif

    cc=dv_parse_header(dv_decoder, buf);

#endif
    return(cc);
}

