#! /bin/sh
#
# skeleton	example file to build /etc/init.d/ scripts.
#		This file should be used to construct scripts for /etc/init.d.
#
#		Written by Miquel van Smoorenburg <miquels@cistron.nl>.
#		Modified for Debian 
#		by Ian Murdock <imurdock@gnu.ai.mit.edu>.
#
# Version:	@(#)skeleton  1.9  26-Feb-2001  miquels@cistron.nl
#

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/bin/uniconctrl
NAME=unicon-tools
DESC=unicon

# Include unicon defaults if available
if [ -f /etc/default/unicon-tools ] ; then
	. /etc/default/unicon-tools
fi

set -e

case "$1" in
  start)
	echo -n "Starting $DESC: "
	if [ \( -f /lib/modules/`/bin/uname -r`/kernel/drivers/video/unicon/unikey.o \
	-o -f /lib/modules/`/bin/uname -r`/kernel/drivers/video/unicon/unikey.ko \) \
	-a -x /usr/bin/consolechars \
	-a -x /usr/bin/uniconctrl \
	-a -e /dev/fb0 ]; then
		/sbin/modprobe unikey
		/sbin/modprobe encode-$UNICON_ENCODE

		/usr/bin/consolechars --sfm /usr/lib/unicon/direct.uni

		/usr/bin/uniconctrl --$UNICON_ENCODE tty1
		/usr/bin/uniconctrl --$UNICON_ENCODE tty2
		/usr/bin/uniconctrl --$UNICON_ENCODE tty3
		/usr/bin/uniconctrl --$UNICON_ENCODE tty4
		/usr/bin/uniconctrl --$UNICON_ENCODE tty5
		/usr/bin/uniconctrl --$UNICON_ENCODE tty6
		echo "$NAME."
	else
		echo "failed."
	fi
	;;
  stop)
	echo "Stopping $DESC: ."
	;;
  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop}" >&2
	exit 1
	;;
esac

exit 0
