/*
 * Decompiled with CFR 0.152.
 */
package com.nexwave.nquindexer;

import com.nexwave.nquindexer.SaxHTMLIndex;
import com.nexwave.nquindexer.WriteJSFiles;
import com.nexwave.nsidita.DirList;
import com.nexwave.nsidita.DocFileInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class IndexerTask
extends Task {
    private String txt_no_inputdir = "Input directory not found:";
    private String txt_cannot_create_outputdir = "Cannot create output search directory.";
    private String txt_no_files_found = "No html files found.";
    private String txt_wrong_dita_basedir = "ERROR: Parser initialization failed. Wrong dita base dir";
    private String txt_no_relative_files_found = "No relative html files calculated.";
    private String txt_no_words_gathered = "No words have been indexed in";
    private String txt_no_html_files = "No HTML Files found in";
    private String txt_no_args = "No argument given: you must provide an htmldir to the IndexerTask";
    private String searchdir = "search";
    private File inputDir = null;
    private String outputDir = null;
    private String projectDir = null;
    private String htmldir = null;
    public static String indexerLanguage = "en";
    private String[] supportedLanguages = new String[]{"en", "de", "fr", "zh", "ja", "ko"};
    private ArrayList<String> cleanUpStrings = null;
    private ArrayList<String> cleanUpChars = null;
    private String htmlExtension = "html";

    public void setHtmldir(String htmldir) {
        this.htmldir = htmldir;
    }

    public void setHtmlextension(String htmlExtension) {
        this.htmlExtension = htmlExtension;
        if (this.htmlExtension.startsWith(".")) {
            this.htmlExtension = this.htmlExtension.substring(1);
        }
    }

    public void setIndexerLanguage(String indexerLanguage) {
        if (indexerLanguage != null && !"".equals(indexerLanguage)) {
            int i;
            int temp = indexerLanguage.indexOf(95);
            if (temp != -1) {
                indexerLanguage = indexerLanguage.substring(0, temp);
            }
            for (i = 0; i < this.supportedLanguages.length; ++i) {
                if (!indexerLanguage.equals(this.supportedLanguages[i])) continue;
                IndexerTask.indexerLanguage = this.supportedLanguages[i];
                break;
            }
            if (i >= this.supportedLanguages.length) {
                IndexerTask.indexerLanguage = indexerLanguage;
            }
        } else {
            IndexerTask.indexerLanguage = "@@";
        }
    }

    public void execute() throws BuildException {
        DirList nsiDoc;
        boolean b;
        File tempfile;
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            System.setProperty("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        }
        catch (SecurityException se) {
            System.out.println("[WARNING] Default parser is not set to Xerces. Make sure Saxon6.5.5 is not in your CLASSPATH.");
        }
        catch (Exception e) {
            System.out.println("[WARNING] Default parser is not set to Xerces. Make sure Saxon6.5.5 is not in your CLASSPATH");
        }
        ArrayList<DocFileInfo> filesDescription = null;
        ArrayList<File> htmlFiles = null;
        ArrayList<String> htmlFilesPathRel = null;
        HashMap<String, String> tempDico = new HashMap<String, String>();
        String htmlList = "htmlFileList.js";
        String htmlInfoList = "htmlFileInfoList.js";
        String indexName = ".js";
        Date dateStart = new Date();
        if (this.htmldir == null) {
            System.out.println(this.txt_no_args + ".");
            return;
        }
        this.inputDir = new File(this.htmldir);
        if (this.inputDir == null) {
            IndexerTask.DisplayHelp();
            return;
        }
        if (!this.inputDir.exists()) {
            System.out.println(this.txt_no_inputdir + " " + this.inputDir + ".");
            return;
        }
        if (this.outputDir == null) {
            this.outputDir = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        }
        if (!(tempfile = new File(this.outputDir)).exists() && !(b = new File(this.outputDir).mkdir())) {
            System.out.println(this.txt_cannot_create_outputdir + " " + this.outputDir + ".");
            return;
        }
        if (this.projectDir == null) {
            this.projectDir = this.inputDir.getPath();
        }
        if ((htmlFiles = (nsiDoc = new DirList(this.inputDir, "^.*\\." + this.htmlExtension + "?$", 1)).getListFiles()).isEmpty()) {
            System.out.println(this.txt_no_html_files + " " + this.inputDir + ".");
            return;
        }
        htmlFilesPathRel = nsiDoc.getListFilesRelTo(this.projectDir);
        if (htmlFiles == null) {
            System.out.println(this.txt_no_files_found);
            return;
        }
        if (htmlFilesPathRel == null) {
            System.out.println(this.txt_no_relative_files_found);
            return;
        }
        WriteJSFiles.WriteHTMLList(this.outputDir.concat(File.separator).concat(htmlList), htmlFilesPathRel);
        this.RetrieveCleanUpProps();
        SaxHTMLIndex spe = new SaxHTMLIndex(this.cleanUpStrings, this.cleanUpChars);
        if (spe.init(tempDico) == 0) {
            filesDescription = new ArrayList<DocFileInfo>();
            for (File ftemp : htmlFiles) {
                DocFileInfo docFileInfoTemp = new DocFileInfo(spe.runExtractData(ftemp, indexerLanguage));
                String stemp = (ftemp = docFileInfoTemp.getFullpath()).toString();
                int i = stemp.indexOf(this.projectDir);
                if (i != 0) {
                    System.out.println("the documentation root does not match with the documentation input!");
                    return;
                }
                int ad = 1;
                if (stemp.equals(this.projectDir)) {
                    ad = 0;
                }
                stemp = stemp.substring(i + this.projectDir.length() + ad);
                ftemp = new File(stemp);
                docFileInfoTemp.setFullpath(ftemp);
                filesDescription.add(docFileInfoTemp);
            }
            if (tempDico.containsKey("")) {
                tempDico.remove("");
            }
            if (tempDico.isEmpty()) {
                System.out.println(this.txt_no_words_gathered + " " + this.inputDir + ".");
                return;
            }
            WriteJSFiles.WriteIndex(this.outputDir.concat(File.separator).concat(indexName), tempDico);
            WriteJSFiles.WriteHTMLInfoList(this.outputDir.concat(File.separator).concat(htmlInfoList), filesDescription);
            Date dateEnd = new Date();
            long diff = dateEnd.getTime() - dateStart.getTime();
            if (diff < 1000L) {
                System.out.println("Delay = " + diff + " milliseconds");
            } else {
                System.out.println("Delay = " + diff / 1000L + " seconds");
            }
        } else {
            System.out.println(this.txt_wrong_dita_basedir);
            return;
        }
    }

    private static void DisplayHelp() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("USAGE:" + lSep);
        msg.append("   java -classpath TesterIndexer inputDir outputDir projectDir" + lSep);
        msg.append("with:" + lSep);
        msg.append("   inputDir (mandatory) :  specify the html files ' directory to index" + lSep);
        msg.append("   outputDir (optional) : specify where to output the index files" + lSep);
        msg.append("   projectDir (optional) : specify the root of the documentation directory" + lSep);
        msg.append("Example:" + lSep);
        msg.append("   java -classpath TesterIndexer /home/$USER/DITA/doc" + lSep);
        msg.append("Example 2:" + lSep);
        msg.append("   java -classpath TesterIndexer /home/$USER/DITA/doc/customer/concepts /home/$USER/temp/search /home/$USER/DITA/doc/" + lSep);
        System.out.println(msg.toString());
    }

    private int RetrieveCleanUpProps() {
        String[] punctuationFiles = new String[]{"punctuation.props"};
        Collection<Object> c = new ArrayList();
        DirList props = new DirList(this.inputDir, "^(?!(punctuation)).*\\.props$", 1);
        ArrayList<File> wordsList = props.getListFiles();
        Properties enProps = new Properties();
        String propsDir = this.inputDir.getPath().concat(File.separator).concat(this.searchdir);
        this.cleanUpStrings = new ArrayList();
        this.cleanUpChars = new ArrayList();
        try {
            FileInputStream input;
            File ftemp;
            for (File aWordsList : wordsList) {
                ftemp = aWordsList;
                if (!ftemp.exists()) continue;
                input = new FileInputStream(ftemp.getAbsolutePath());
                enProps.load(input);
                input.close();
                c = enProps.values();
                this.cleanUpStrings.addAll(c);
                enProps.clear();
            }
            for (String punctuationFile : punctuationFiles) {
                String tempStr = propsDir.concat(File.separator).concat(punctuationFile);
                ftemp = new File(tempStr);
                if (!ftemp.exists()) continue;
                input = new FileInputStream(tempStr);
                enProps.load(input);
                input.close();
                c = enProps.values();
                this.cleanUpChars.addAll(c);
                enProps.clear();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
        return 0;
    }
}

