/* @(#) ZFoutlib Ver.1.12 (ZFstart.c : 1996/08/21)
 *
 * (c) Copyright 1994-1996 by M.Sato
 */
#include "ZFbuild.h"

/* 65525L = 0xffff -  SizeOfHeaderAndFooter */
#ifdef   ZF_CHK_MALLOC
#  define  mem_alloc(n,s) \
            ( (((unsigned long)(n))*((unsigned long)(s)) <= 65525L) ? \
             malloc((n)*(s)) : NULL)
#else 
#  define  mem_alloc(n,s) malloc((n)*(s))
#endif

int ZFerrno;

static int fmt[ZF_OUTTYPES] = {PK_LINE, PK_ALL, PK_ALL, PK_ALL, PK_ALL};

int ZFsupport(outtyp)
  int outtyp;
{
  return (outtyp < ZF_OUTTYPES) && (outtyp >= 0);
}

ZFwork *ZFstart(outfp, outtyp, width, height)
  FILE *outfp;
  int outtyp;
  unsigned int width, height;
{
    ZFwork *wk;
    unsigned int w_byte;

    if (!ZFsupport(outtyp)) {
      ZFerrno = ZF_UNSUPP;
      return ZF_NULL;
    }

    if ((wk = (ZFwork *)malloc(sizeof(ZFwork))) == NULL) {
      ZFerrno=ZF_NOMEM;
      return ZF_NULL;
    }
    wk->width = width;
    wk->height = height;
    wk->fmt = fmt[outtyp];

    /* m/(2^n) == m>>n */
    /* (m % 2^n) == (m & ((2^n)-1)) */

    /* width --> byte num */
    w_byte = (width >> 3) + 1;
    if (width & (8-1)) w_byte++;

    /* calc worst data length of runlength compression */
    width = (w_byte >> 7);
    if (w_byte & (0x80-1)) width++;
    w_byte += width;

    if (wk->fmt == PK_LINE) w_byte += LLEN_SIZE;
    if ((wk->buf = (unsigned char *)mem_alloc(height, w_byte)) == NULL) {
      free_mem(wk);
      ZFerrno = ZF_NOMEM;
      return ZF_NULL;
    }

    wk->fp = outfp;
    wk->xpos = 0;
    wk->ypos = 0;
    wk->bitbuf = 0x00;
    wk->bitmask = INI_BITMASK;
    wk->count = 0;
    wk->stat = STAT_UNDEF;

    wk->lbufp = 0;
    /* PK_LINE requires linelength buffer */
    wk->cbufp = ((wk->fmt == PK_LINE) ? LLEN_SIZE : 0);
    wk->bufp = wk->cbufp;
    ZFerrno = ZF_OK;
    return wk;
}
