/* @(#) ZFoutlib Ver.1.12 (ZFcmprs.c : 1996/02/28)
 *
 * (c) Copyright 1994-1996 by M.Sato
 */
#include "ZFbuild.h"

void _ZFcmprs_terminate(wk)
  ZFwork *wk;
{
    if (wk->count == 0) return;
    if (wk->count == 1) {
      wk->buf[wk->cbufp] = 0x00;
    } else if (wk->stat == STAT_CMPRS) {
      wk->buf[wk->cbufp] = 0x101 - wk->count;
    } else {
      wk->buf[wk->cbufp] = wk->count - 1;
    }
    wk->cbufp = ++wk->bufp;
    wk->count = 0;
    wk->stat = STAT_UNDEF;
    if (wk->fmt == PK_ALL) wk->lbufp = wk->cbufp;
}

void _ZFadd_buf(wk)
  ZFwork *wk;
{
    if (wk->count == 0) {
      wk->pre_c = wk->bitbuf;
      wk->buf[++wk->bufp] = wk->pre_c;
      wk->count = 1;
    } else if (wk->count == 1) {
      if (wk->pre_c != wk->bitbuf) {
        wk->stat = STAT_DIFF;
        wk->buf[++wk->bufp] = wk->bitbuf;
        wk->pre_c = wk->bitbuf;
      } else {
        wk->stat = STAT_CMPRS;
      }
      wk->count = 2;
    } else if ((wk->stat == STAT_DIFF) || (wk->stat == STAT_SAME)) {
      if ((wk->bitbuf == wk->pre_c) && (wk->stat == STAT_SAME)) {
        wk->bufp -= 2;
        wk->count -= 2;
        _ZFcmprs_terminate(wk);
        wk->buf[++wk->bufp] = wk->bitbuf;
        wk->stat = STAT_CMPRS;
        wk->count = 3;
      } else {
        wk->buf[++wk->bufp] = wk->bitbuf;
        wk->count++;
        if (wk->bitbuf == wk->pre_c) {
          wk->stat = STAT_SAME;
        } else {
          wk->stat = STAT_DIFF;
          wk->pre_c = wk->bitbuf;
        }
        if (wk->count == 0x80) {
          _ZFcmprs_terminate(wk);
        }
      }
    } else if (wk->stat == STAT_CMPRS) {
      if (wk->bitbuf != wk->pre_c) {
        _ZFcmprs_terminate(wk);
        wk->pre_c = wk->bitbuf;
        wk->buf[++wk->bufp] = wk->pre_c;
        wk->count = 1;
      } else {
        wk->count++;
        if (wk->count == 0x81) {
          _ZFcmprs_terminate(wk);
        }
      }
    }
}
