/*
 * Copyright (c) 1991-1994  Sony Corporation
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL SONY CORPORATION BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR
 * THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Except as contained in this notice, the name of Sony Corporation
 * shall not be used in advertising or otherwise to promote the sale, use
 * or other dealings in this Software without prior written authorization
 * from Sony Corporation.
 *
 */

/*
 * $SonyRCSfile: hinsi.c,v $  
 * $SonyRevision: 1.1 $ 
 * $SonyDate: 1994/06/03 08:03:36 $
 */

#include "sj_hinsi.h"

#include "sj3dic.h"

static	struct	hlist {
	int	code;
	char	*str;
} hinsi[] = {
	{ MEISI_1, "\314\276\273\354" },
	{ MEISI_1, "\314\276\243\261" },
	{ MEISI_2, "\314\276\243\262" },
	{ MEISI_3, "\314\276\243\263" },
	{ MEISI_4, "\314\276\243\264" },
	{ MEISI_5, "\314\276\243\265" },
	{ MEISI_6, "\314\276\243\266" },
	{ MEISI_7, "\314\276\243\267" },
	{ MEISI_8, "\314\276\243\270" },
	{ MEISI_9, "\314\276\243\271" },
	{ MEISI_10, "\314\276\243\261\243\260" },
	{ MEISI_11, "\314\276\243\261\243\261" },
	{ MEISI_20, "\314\276\243\262\243\260" },
	{ D_MEISI_1, "\302\345\314\276\273\354" },
	{ D_MEISI_1, "\302\345\243\261" },
	{ D_MEISI_2, "\302\345\243\262" },
	{ D_MEISI_3, "\302\345\243\263" },
	{ D_MEISI_4, "\302\345\243\264" },
	{ D_MEISI_5, "\302\345\243\265" },
	{ D_MEISI_6, "\302\345\243\266" },
	{ MYOUJI, "\311\304\273\372" },
	{ NAMAE, "\314\276\301\260" },
	{ KIGYOU, "\264\353\266\310" },
	{ TIMEI, "\303\317\314\276" },
	{ KEN_KU, "\270\251\241\277\266\350\314\276" },
	{ KEN_KU, "\270\251\266\350" },
	{ RENTAISI, "\317\242\302\316\273\354" },
	{ RENTAISI, "\317\242\302\316" },
	{ SETUZOKU, "\300\334\302\263\273\354" },
	{ SETUZOKU, "\300\334\302\263" },
	{ KANDOUSI, "\264\266\306\260" },
	{ JOSUUSI, "\275\365\277\364\273\354" },
	{ JOSUUSI, "\275\365\277\364" },
	{ SUUSI, "\277\364\273\354" },
	{ SETTOU_1, "\300\334\306\254\270\354" },
	{ SETTOU_1, "\300\334\306\254\243\261" },
	{ SETTOU_2, "\300\334\306\254\243\262" },
	{ SETTOU_3, "\300\334\306\254\243\263" },
	{ SETTOU_4, "\300\334\306\254\243\264" },
	{ SETTOU_5, "\300\334\306\254\243\265" },
	{ SETUBI_1, "\300\334\310\370\270\354" },
	{ SETUBI_1, "\300\334\310\370\243\261" },
	{ SETUBI_2, "\300\334\310\370\243\262" },
	{ SETUBI_3, "\300\334\310\370\243\263" },
	{ SETUBI_4, "\300\334\310\370\243\264" },
	{ SETUBI_5, "\300\334\310\370\243\265" },
	{ SETUBI_6, "\300\334\310\370\243\266" },
	{ SETUBI_7, "\300\334\310\370\243\267" },
	{ SETUBI_8, "\300\334\310\370\243\270" },
	{ SETUBI_9, "\300\334\310\370\243\271" },
	{ FUKUSI_1, "\311\373\273\354" },
	{ FUKUSI_1, "\311\373\243\261" },
	{ FUKUSI_2, "\311\373\243\262" },
	{ FUKUSI_3, "\311\373\243\263" },
	{ FUKUSI_4, "\311\373\243\264" },
	{ FUKUSI_5, "\311\373\243\265" },
	{ FUKUSI_6, "\311\373\243\266" },
	{ FUKUSI_7, "\311\373\243\267" },
	{ FUKUSI_8, "\311\373\243\270" },
	{ FUKUSI_9, "\311\373\243\271" },
	{ JOSUUSI2, "\275\365\277\364\243\262" },
	{ KEIYOUSI_1, "\267\301\315\306\273\354" },
	{ KEIYOUSI_1, "\267\301\243\261" },
	{ KEIYOUSI_2, "\267\301\243\262" },
	{ KEIYOUSI_3, "\267\301\243\263" },
	{ KEIYOUSI_4, "\267\301\243\264" },
	{ KEIYOUSI_5, "\267\301\243\265" },
	{ KEIYOUSI_6, "\267\301\243\266" },
	{ KEIYOUSI_7, "\267\301\243\267" },
	{ KEIYOUSI_8, "\267\301\243\270" },
	{ KEIYOUSI_9, "\267\301\243\271" },
	{ KEIYOUSI_10, "\267\301\243\261\243\260" },
	{ KEIYOUSI_11, "\267\301\243\261\243\261" },
	{ KE_DOUSI_1, "\267\301\315\306\306\260\273\354" },
	{ KE_DOUSI_1, "\267\301\306\260\243\261" },
	{ KE_DOUSI_2, "\267\301\306\260\243\262" },
	{ KE_DOUSI_3, "\267\301\306\260\243\263" },
	{ KE_DOUSI_4, "\267\301\306\260\243\264" },
	{ KE_DOUSI_5, "\267\301\306\260\243\265" },
	{ KE_DOUSI_6, "\267\301\306\260\243\266" },
	{ KE_DOUSI_7, "\267\301\306\260\243\267" },
	{ KE_DOUSI_8, "\267\301\306\260\243\270" },
	{ KE_DOUSI_9, "\267\301\306\260\243\271" },
	{ DO_SAHEN, "\306\260\241\246\245\265\312\321" },
	{ DO_SAHEN, "\245\265\312\321" },
	{ DO_ZAHEN, "\306\260\241\246\245\266\312\321" },
	{ DO_ZAHEN, "\245\266\312\321" },
	{ DO_1DAN_1, "\306\260\241\246\260\354\303\312" },
	{ DO_1DAN_1, "\260\354\303\312\243\261" },
	{ DO_KAGO_1, "\306\260\241\246\245\253\270\336" },
	{ DO_KAGO_1, "\245\253\270\336\243\261" },
	{ DO_GAGO_1, "\306\260\241\246\245\254\270\336" },
	{ DO_GAGO_1, "\245\254\270\336\243\261" },
	{ DO_SAGO_1, "\306\260\241\246\245\265\270\336" },
	{ DO_SAGO_1, "\245\265\270\336\243\261" },
	{ DO_TAGO_1, "\306\260\241\246\245\277\270\336" },
	{ DO_TAGO_1, "\245\277\270\336\243\261" },
	{ DO_NAGO_1, "\306\260\241\246\245\312\270\336" },
	{ DO_NAGO_1, "\245\312\270\336" },
	{ DO_BAGO_1, "\306\260\241\246\245\320\270\336" },
	{ DO_BAGO_1, "\245\320\270\336\243\261" },
	{ DO_MAGO_1, "\306\260\241\246\245\336\270\336" },
	{ DO_MAGO_1, "\245\336\270\336\243\261" },
	{ DO_RAGO_1, "\306\260\241\246\245\351\270\336" },
	{ DO_RAGO_1, "\245\351\270\336\243\261" },
	{ DO_WAGO_1, "\306\260\241\246\245\357\270\336" },
	{ DO_WAGO_1, "\245\357\270\336\243\261" },
	{ DO_1DAN_2, "\260\354\303\312\243\262" },
	{ DO_KAGO_2, "\245\253\270\336\243\262" },
	{ DO_GAGO_2, "\245\254\270\336\243\262" },
	{ DO_SAGO_2, "\245\265\270\336\243\262" },
	{ DO_TAGO_2, "\245\277\270\336\243\262" },
	{ DO_BAGO_2, "\245\320\270\336\243\262" },
	{ DO_MAGO_2, "\245\336\270\336\243\262" },
	{ DO_RAGO_2, "\245\351\270\336\243\262" },
	{ DO_WAGO_2, "\245\357\270\336\243\262" },
	{ DO_KAGO_5, "\245\253\270\336\243\265" },
	{ DO_GAGO_5, "\245\254\270\336\243\265" },
	{ DO_SAGO_5, "\245\265\270\336\243\265" },
	{ DO_TAGO_5, "\245\277\270\336\243\265" },
	{ DO_BAGO_5, "\245\320\270\336\243\265" },
	{ DO_MAGO_5, "\245\336\270\336\243\265" },
	{ DO_RAGO_5, "\245\351\270\336\243\265" },
	{ DO_WAGO_5, "\245\357\270\336\243\265" },
	{ DO_KAGO_6, "\245\253\270\336\243\266" },
	{ DO_GAGO_6, "\245\254\270\336\243\266" },
	{ DO_SAGO_6, "\245\265\270\336\243\266" },
	{ DO_TAGO_6, "\245\277\270\336\243\266" },
	{ DO_BAGO_6, "\245\320\270\336\243\266" },
	{ DO_MAGO_6, "\245\336\270\336\243\266" },
	{ DO_RAGO_6, "\245\351\270\336\243\266" },
	{ DO_WAGO_6, "\245\357\270\336\243\266" },
	{ DO_1DAN_3, "\260\354\303\312\243\263" },
	{ DO_KAGO_3, "\245\253\270\336\243\263" },
	{ DO_GAGO_3, "\245\254\270\336\243\263" },
	{ DO_SAGO_3, "\245\265\270\336\243\263" },
	{ DO_TAGO_3, "\245\277\270\336\243\263" },
	{ DO_BAGO_3, "\245\320\270\336\243\263" },
	{ DO_MAGO_3, "\245\336\270\336\243\263" },
	{ DO_RAGO_3, "\245\351\270\336\243\263" },
	{ DO_WAGO_3, "\245\357\270\336\243\263" },
	{ DO_1DAN_4, "\260\354\303\312\243\264" },
	{ DO_KAGO_4, "\245\253\270\336\243\264" },
	{ DO_GAGO_4, "\245\254\270\336\243\264" },
	{ DO_SAGO_4, "\245\265\270\336\243\264" },
	{ DO_TAGO_4, "\245\277\270\336\243\264" },
	{ DO_BAGO_4, "\245\320\270\336\243\264" },
	{ DO_MAGO_4, "\245\336\270\336\243\264" },
	{ DO_RAGO_4, "\245\351\270\336\243\264" },
	{ DO_WAGO_4, "\245\357\270\336\243\264" },
	{ DO_KAGO_7, "\245\253\270\336\243\267" },
	{ DO_GAGO_7, "\245\254\270\336\243\267" },
	{ DO_SAGO_7, "\245\265\270\336\243\267" },
	{ DO_TAGO_7, "\245\277\270\336\243\267" },
	{ DO_BAGO_7, "\245\320\270\336\243\267" },
	{ DO_MAGO_7, "\245\336\270\336\243\267" },
	{ DO_RAGO_7, "\245\351\270\336\243\267" },
	{ DO_WAGO_7, "\245\357\270\336\243\267" },
	{ DO_KAGO_8, "\245\253\270\336\243\270" },
	{ DO_GAGO_8, "\245\254\270\336\243\270" },
	{ DO_SAGO_8, "\245\265\270\336\243\270" },
	{ DO_TAGO_8, "\245\277\270\336\243\270" },
	{ DO_BAGO_8, "\245\320\270\336\243\270" },
	{ DO_MAGO_8, "\245\336\270\336\243\270" },
	{ DO_RAGO_8, "\245\351\270\336\243\270" },
	{ DO_WAGO_8, "\245\357\270\336\243\270" },
	{ SP_SA_MI1, "\245\265\312\321\314\244\243\261" },
	{ SP_SA_MI2, "\245\265\312\321\314\244\243\262" },
	{ SP_SA_YOU, "\245\265\312\321\314\244\315\321" },
	{ SP_SA_SYU, "\245\265\312\321\275\252\302\316" },
	{ SP_SA_KAT, "\245\265\312\321\262\276" },
	{ SP_SA_ME1, "\245\265\312\321\314\277\243\261" },
	{ SP_SA_ME2, "\245\265\312\321\314\277\243\262" },
	{ SP_KA_MIZ, "\245\253\312\321\314\244" },
	{ SP_KA_YOU, "\245\253\312\321\315\321" },
	{ SP_KA_SYU, "\245\253\312\321\275\252\302\316" },
	{ SP_KA_KAT, "\245\253\312\321\262\276" },
	{ SP_KA_MEI, "\245\253\312\321\314\277" },
	{ TEINEI1, "\303\372\307\253\243\261" },
	{ TEINEI2, "\303\372\307\253\243\262" },
	{ SP_KA_ONB, "\245\253\270\336\262\273\312\330" },
	{ SP_FUKUSI, "\306\303\274\354\311\373" },
	{ AISATU, "\260\247\273\242" },
	{ SP_KEIYOUSI, "\306\303\274\354\267\301\315\306" },
	{ TANKANJI, "\303\261\264\301\273\372" },
	{ TANKANJI, "\303\261\264\301" },
	{ IKKATU, "\260\354\263\347" },
	{ 0, 0 }
};

char *
hns2str(int code)
{
	struct	hlist	*p;

	for (p = hinsi ; p -> code ; p++) {
		if (p -> code == code)
			return p -> str;
	}

	return "ERROR";
}

int
str2hns(char *str)
{
	struct	hlist	*p;

	for (p = hinsi ; p -> code ; p++) {
		if (strcmp(p -> str, str) == 0)
			return p -> code;
	}

	return 0;
}
