#ifndef _CANFEP_PTY_H_
#define _CANFEP_PTY_H_

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <termios.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/signal.h>
#include <sys/wait.h>
#if defined(sun)
#include <curses.h>
#else
#include <term.h>
#endif

typedef void (*SIG_PF)(int);

class Pty {
public:
    Pty(int ac, char** av, char* amsg = NULL, char* emsg = NULL);
    virtual ~Pty();
private:
    char* shell;
private:
    int master;
    int slave;
private:
    static int child;
    int subchild;
private:
    static struct termios tt;
    struct winsize win;
private:
    char line[BUFSIZ];
private:
    void done();
    void fail();
    void getmaster();
    void getslave();
    void fixtty();
protected:
    int rfd;
    static int wfd;
private:
    static void adjstr(char* str);
protected:
    static int hs;
    char* so;
    char* se;
    char* us;
    char* ue;
    char* sc;
    char* rc;
    static char* ce;
    static char* ts;
    char* fs;
    static char* ds;
private:
    static void finish();
    static void winchange();
public:
    static char endstr[BUFSIZ];
    static char endmsg[BUFSIZ];
};

#endif /* _CANFEP_PTY_H_ */
