/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.functions.Available;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.functions.NamePart;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.SystemProperty;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;

public class SystemFunctionLibrary
implements FunctionLibrary {
    private int functionSet;
    public static final int XPATH_ONLY = 0;
    public static final int FULL_XSLT = 1;
    public static final int USE_WHEN = 2;
    private static SystemFunctionLibrary[] THE_INSTANCES = new SystemFunctionLibrary[3];

    public static SystemFunctionLibrary getSystemFunctionLibrary(int functionSet) {
        if (THE_INSTANCES[functionSet] == null) {
            SystemFunctionLibrary.THE_INSTANCES[functionSet] = new SystemFunctionLibrary(functionSet);
        }
        return THE_INSTANCES[functionSet];
    }

    private SystemFunctionLibrary(int functionSet) {
        this.functionSet = functionSet;
    }

    public boolean isAvailable(StructuredQName functionName, int arity) {
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            StandardFunction.Entry entry = StandardFunction.getFunction(local, arity);
            if (entry == null) {
                return false;
            }
            if (arity != -1 && (arity < entry.minArguments || arity > entry.maxArguments)) {
                return false;
            }
            return this.functionSet != 2 || !local.equals("current") && !local.equals("current-group") && !local.equals("current-grouping-key") && !local.equals("document") && !local.equals("format-date") && !local.equals("format-dateTime") && !local.equals("format-time") && !local.equals("generate-id") && !local.equals("key") && !local.equals("regex-group") && !local.equals("unparsed-entity-uri") && !local.equals("unparsed-entity-public-id") && !local.equals("unparsed-text");
        }
        return false;
    }

    public Expression bind(StructuredQName functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        String uri = functionName.getNamespaceURI();
        String local = functionName.getLocalName();
        if (uri.equals("http://www.w3.org/2005/xpath-functions")) {
            SystemFunction f;
            StandardFunction.Entry entry = StandardFunction.getFunction(local, staticArgs.length);
            if (entry == null) {
                if (StandardFunction.getFunction(local, -1) == null) {
                    XPathException err = new XPathException("Unknown system function " + local + "()");
                    err.setErrorCode("XPST0017");
                    err.setIsStaticError(true);
                    throw err;
                }
                XPathException err = new XPathException("System function " + local + "() cannot be called with " + SystemFunctionLibrary.pluralArguments(staticArgs.length));
                err.setErrorCode("XPST0017");
                err.setIsStaticError(true);
                throw err;
            }
            Class functionClass = entry.implementationClass;
            try {
                f = (SystemFunction)functionClass.newInstance();
            }
            catch (Exception err) {
                throw new AssertionError((Object)("Failed to load system function: " + err.getMessage()));
            }
            f.setDetails(entry);
            f.setFunctionName(functionName);
            if (this.functionSet != 1 && (f instanceof XSLTFunction || f instanceof NamePart && entry.opcode == 3)) {
                if (this.functionSet == 0) {
                    XPathException err = new XPathException("Cannot use the " + local + "() function in a non-XSLT context");
                    err.setErrorCode("XPST0017");
                    err.setIsStaticError(true);
                    throw err;
                }
                if (this.functionSet == 2 && !(f instanceof Available) && !(f instanceof SystemProperty)) {
                    XPathException err = new XPathException("Cannot use the " + local + "() function in a use-when expression");
                    err.setErrorCode("XPST0017");
                    err.setIsStaticError(true);
                    throw err;
                }
            }
            f.setArguments(staticArgs);
            this.checkArgumentCount(staticArgs.length, entry.minArguments, entry.maxArguments, local);
            return f;
        }
        return null;
    }

    private int checkArgumentCount(int numArgs, int min, int max, String local) throws XPathException {
        if (min == max && numArgs != min) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have " + min + SystemFunctionLibrary.pluralArguments(min));
        }
        if (numArgs < min) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have at least " + min + SystemFunctionLibrary.pluralArguments(min));
        }
        if (numArgs > max) {
            throw new XPathException("Function " + Err.wrap(local, 3) + " must have no more than " + max + SystemFunctionLibrary.pluralArguments(max));
        }
        return numArgs;
    }

    private static String pluralArguments(int num) {
        if (num == 1) {
            return " argument";
        }
        return " arguments";
    }

    public FunctionLibrary copy() {
        return this;
    }
}

