/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.InterpretedFunction;
import org.mozilla.javascript.InterpretedScript;
import org.mozilla.javascript.InterpreterData;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.UintMap;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.debug.DebugFrame;

public class Interpreter {
    private static final int BASE_ICODE = 67;
    private static final int Icode_DUP = 68;
    private static final int Icode_DUPSECOND = 69;
    private static final int Icode_SWAP = 70;
    private static final int Icode_IFEQ_POP = 71;
    private static final int Icode_NAMEINC = 72;
    private static final int Icode_PROPINC = 73;
    private static final int Icode_ELEMINC = 74;
    private static final int Icode_VARINC = 75;
    private static final int Icode_NAMEDEC = 76;
    private static final int Icode_PROPDEC = 77;
    private static final int Icode_ELEMDEC = 78;
    private static final int Icode_VARDEC = 79;
    private static final int Icode_SCOPE = 80;
    private static final int Icode_TYPEOFNAME = 81;
    private static final int Icode_NAME_AND_THIS = 82;
    private static final int Icode_PUSH_PARENT = 83;
    private static final int Icode_GETPROTO = 84;
    private static final int Icode_GETSCOPEPARENT = 85;
    private static final int Icode_SETPROTO = 86;
    private static final int Icode_SETPARENT = 87;
    private static final int Icode_CLOSURE = 88;
    private static final int Icode_CALLSPECIAL = 89;
    private static final int Icode_RETUNDEF = 90;
    private static final int Icode_CATCH = 91;
    private static final int Icode_GOSUB = 92;
    private static final int Icode_RETSUB = 93;
    private static final int Icode_LINE = 94;
    private static final int Icode_SHORTNUMBER = 95;
    private static final int Icode_INTNUMBER = 96;
    private static final int END_ICODE = 97;
    private CompilerEnvirons compilerEnv;
    private boolean itsInFunctionFlag;
    private InterpreterData itsData;
    private ScriptOrFnNode scriptOrFn;
    private int itsStackDepth = 0;
    private int itsWithDepth = 0;
    private int itsLineNumber = 0;
    private int itsDoubleTableTop;
    private ObjToIntMap itsStrings = new ObjToIntMap(20);
    private String lastAddString;
    private int itsLocalTop;
    private static final int MIN_LABEL_TABLE_SIZE = 32;
    private static final int MIN_FIXUP_TABLE_SIZE = 40;
    private int[] itsLabelTable;
    private int itsLabelTableTop;
    private long[] itsFixupTable;
    private int itsFixupTableTop;
    private int itsExceptionTableTop;
    private static final int EXCEPTION_SLOT_SIZE = 6;
    private static final int EXCEPTION_TRY_START_SLOT = 0;
    private static final int EXCEPTION_TRY_END_SLOT = 1;
    private static final int EXCEPTION_CATCH_SLOT = 2;
    private static final int EXCEPTION_FINALLY_SLOT = 3;
    private static final int EXCEPTION_WITH_DEPTH_SLOT = 4;
    private static final int EXCEPTION_LOCAL_SLOT = 5;
    private static final Object DBL_MRK = new Object();

    public Object compile(Scriptable scope, CompilerEnvirons compilerEnv, ScriptOrFnNode tree, String encodedSource, boolean returnFunction, Object staticSecurityDomain) {
        Object dynamicDomain;
        Context cx;
        SecurityController sc;
        this.compilerEnv = compilerEnv;
        new NodeTransformer(compilerEnv).transform(tree);
        if (returnFunction) {
            tree = tree.getFunctionNode(0);
        }
        if ((sc = (cx = Context.getContext()).getSecurityController()) != null) {
            dynamicDomain = sc.getDynamicSecurityDomain(staticSecurityDomain);
        } else {
            if (staticSecurityDomain != null) {
                throw new IllegalArgumentException();
            }
            dynamicDomain = null;
        }
        this.scriptOrFn = tree;
        this.itsData = new InterpreterData(sc, dynamicDomain, compilerEnv.getLanguageVersion(), this.scriptOrFn.getSourceName(), encodedSource);
        this.itsData.topLevel = true;
        if (tree instanceof FunctionNode) {
            this.generateFunctionICode();
            return Interpreter.createFunction(cx, scope, this.itsData, false);
        }
        this.generateICodeFromTree(this.scriptOrFn);
        this.itsData.itsFromEvalCode = compilerEnv.isFromEval();
        return new InterpretedScript(this.itsData);
    }

    public void notifyDebuggerCompilationDone(Context cx, Object scriptOrFunction, String debugSource) {
        InterpreterData idata = scriptOrFunction instanceof InterpretedScript ? ((InterpretedScript)scriptOrFunction).itsData : ((InterpretedFunction)scriptOrFunction).itsData;
        Interpreter.notifyDebugger_r(cx, idata, debugSource);
    }

    private static void notifyDebugger_r(Context cx, InterpreterData idata, String debugSource) {
        cx.debugger.handleCompilationDone(cx, idata, debugSource);
        if (idata.itsNestedFunctions != null) {
            for (int i = 0; i != idata.itsNestedFunctions.length; ++i) {
                Interpreter.notifyDebugger_r(cx, idata.itsNestedFunctions[i], debugSource);
            }
        }
    }

    private void generateFunctionICode() {
        FunctionNode theFunction = (FunctionNode)this.scriptOrFn;
        this.itsData.itsFunctionType = theFunction.getFunctionType();
        this.itsData.itsNeedsActivation = theFunction.requiresActivation();
        this.itsData.itsName = theFunction.getFunctionName();
        if ((theFunction.getParamAndVarCount() & 0xFFFFFF00) != 0) {
            this.itsData.itsNeedsActivation = true;
        }
        if (!theFunction.getIgnoreDynamicScope() && this.compilerEnv.isUseDynamicScope()) {
            this.itsData.useDynamicScope = true;
        }
        this.generateICodeFromTree(theFunction.getLastChild());
    }

    private void generateICodeFromTree(Node tree) {
        Object[] tmp;
        this.generateNestedFunctions();
        this.generateRegExpLiterals();
        int theICodeTop = 0;
        theICodeTop = this.generateICode(tree, theICodeTop);
        this.fixLabelGotos();
        if (this.itsData.itsFunctionType == 0) {
            theICodeTop = this.addToken(67, theICodeTop);
        }
        this.itsData.itsICodeTop = theICodeTop = this.addIcode(91, theICodeTop);
        if (this.itsData.itsICode.length != theICodeTop) {
            tmp = new byte[theICodeTop];
            System.arraycopy(this.itsData.itsICode, 0, tmp, 0, theICodeTop);
            this.itsData.itsICode = tmp;
        }
        if (this.itsStrings.size() == 0) {
            this.itsData.itsStringTable = null;
        } else {
            this.itsData.itsStringTable = new String[this.itsStrings.size()];
            ObjToIntMap.Iterator iter = this.itsStrings.newIterator();
            iter.start();
            while (!iter.done()) {
                String str = (String)iter.getKey();
                int index = iter.getValue();
                if (this.itsData.itsStringTable[index] != null) {
                    Kit.codeBug();
                }
                this.itsData.itsStringTable[index] = str;
                iter.next();
            }
        }
        if (this.itsDoubleTableTop == 0) {
            this.itsData.itsDoubleTable = null;
        } else if (this.itsData.itsDoubleTable.length != this.itsDoubleTableTop) {
            tmp = new double[this.itsDoubleTableTop];
            System.arraycopy(this.itsData.itsDoubleTable, 0, tmp, 0, this.itsDoubleTableTop);
            this.itsData.itsDoubleTable = tmp;
        }
        if (this.itsExceptionTableTop != 0 && this.itsData.itsExceptionTable.length != this.itsExceptionTableTop) {
            tmp = new int[this.itsExceptionTableTop];
            System.arraycopy(this.itsData.itsExceptionTable, 0, tmp, 0, this.itsExceptionTableTop);
            this.itsData.itsExceptionTable = tmp;
        }
        this.itsData.itsMaxVars = this.scriptOrFn.getParamAndVarCount();
        this.itsData.itsMaxFrameArray = this.itsData.itsMaxVars + this.itsData.itsMaxLocals + this.itsData.itsMaxStack;
        this.itsData.argNames = this.scriptOrFn.getParamAndVarNames();
        this.itsData.argCount = this.scriptOrFn.getParamCount();
        this.itsData.encodedSourceStart = this.scriptOrFn.getEncodedSourceStart();
        this.itsData.encodedSourceEnd = this.scriptOrFn.getEncodedSourceEnd();
    }

    private void generateNestedFunctions() {
        int functionCount = this.scriptOrFn.getFunctionCount();
        if (functionCount == 0) {
            return;
        }
        InterpreterData[] array = new InterpreterData[functionCount];
        for (int i = 0; i != functionCount; ++i) {
            FunctionNode def = this.scriptOrFn.getFunctionNode(i);
            Interpreter jsi = new Interpreter();
            jsi.compilerEnv = this.compilerEnv;
            jsi.scriptOrFn = def;
            jsi.itsData = new InterpreterData(this.itsData);
            jsi.itsData.itsCheckThis = def.getCheckThis();
            jsi.itsInFunctionFlag = true;
            jsi.generateFunctionICode();
            array[i] = jsi.itsData;
        }
        this.itsData.itsNestedFunctions = array;
    }

    private void generateRegExpLiterals() {
        int N = this.scriptOrFn.getRegexpCount();
        if (N == 0) {
            return;
        }
        Context cx = Context.getContext();
        RegExpProxy rep = ScriptRuntime.checkRegExpProxy(cx);
        Object[] array = new Object[N];
        for (int i = 0; i != N; ++i) {
            String string = this.scriptOrFn.getRegexpString(i);
            String flags = this.scriptOrFn.getRegexpFlags(i);
            array[i] = rep.compileRegExp(cx, string, flags);
        }
        this.itsData.itsRegExpLiterals = array;
    }

    private int updateLineNumber(Node node, int iCodeTop) {
        int lineno = node.getLineno();
        if (lineno != this.itsLineNumber && lineno >= 0) {
            this.itsLineNumber = lineno;
            iCodeTop = this.addIcode(94, iCodeTop);
            iCodeTop = this.addShort(lineno, iCodeTop);
        }
        return iCodeTop;
    }

    private void badTree(Node node) {
        throw new RuntimeException("Un-handled node: " + node.toString());
    }

    private int generateICode(Node node, int iCodeTop) {
        Node child;
        int type = node.getType();
        Node firstChild = child = node.getFirstChild();
        int savedStackDepth = this.itsStackDepth++;
        int stackDelta = 0;
        boolean stackShouldBeZero = false;
        block0 : switch (type) {
            case 87: {
                int fnIndex = node.getExistingIntProp(1);
                FunctionNode fn = this.scriptOrFn.getFunctionNode(fnIndex);
                if (fn.getFunctionType() != 1) {
                    stackDelta = 1;
                    iCodeTop = this.addIcode(88, iCodeTop);
                    iCodeTop = this.addIndex(fnIndex, iCodeTop);
                    if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                    this.itsData.itsMaxStack = this.itsStackDepth;
                    break;
                }
                stackShouldBeZero = true;
                break;
            }
            case 118: {
                stackShouldBeZero = true;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    if (child.getType() != 87) {
                        iCodeTop = this.generateICode(child, iCodeTop);
                    }
                    child = child.getNext();
                }
                break;
            }
            case 93: {
                child = child.getNext();
            }
            case 94: 
            case 101: 
            case 106: 
            case 107: 
            case 110: 
            case 112: {
                stackShouldBeZero = true;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNext();
                }
                break;
            }
            case 124: {
                stackShouldBeZero = true;
                if ((this.itsLocalTop & 0xFFFFFF00) != 0) {
                    throw Context.reportRuntimeError("Program too complex (out of locals)");
                }
                node.putIntProp(3, this.itsLocalTop);
                ++this.itsLocalTop;
                if (this.itsLocalTop > this.itsData.itsMaxLocals) {
                    this.itsData.itsMaxLocals = this.itsLocalTop;
                }
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    child = child.getNext();
                }
                --this.itsLocalTop;
                break;
            }
            case 57: {
                stackDelta = 1;
                iCodeTop = this.addToken(57, iCodeTop);
                iCodeTop = this.addLocalBlockRef(node, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 77: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                while (null != (child = child.getNext())) {
                    if (1 != this.itsStackDepth - savedStackDepth) {
                        Kit.codeBug();
                    }
                    iCodeTop = this.addToken(51, iCodeTop);
                    --this.itsStackDepth;
                    iCodeTop = this.generateICode(child, iCodeTop);
                }
                break;
            }
            case 123: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                while (null != (child = child.getNext())) {
                    if (1 != this.itsStackDepth - savedStackDepth) {
                        Kit.codeBug();
                    }
                    iCodeTop = this.addIcode(68, iCodeTop);
                    iCodeTop = this.generateICode(child, iCodeTop);
                    iCodeTop = this.addToken(51, iCodeTop);
                    --this.itsStackDepth;
                }
                break;
            }
            case 120: {
                stackDelta = 1;
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 92: {
                stackShouldBeZero = true;
                Node.Jump switchNode = (Node.Jump)node;
                iCodeTop = this.updateLineNumber(switchNode, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                ObjArray cases = (ObjArray)switchNode.getProp(8);
                for (int i = 0; i < cases.size(); ++i) {
                    Node thisCase = (Node)cases.get(i);
                    Node first = thisCase.getFirstChild();
                    iCodeTop = this.generateICode(first, iCodeTop);
                    iCodeTop = this.addIcode(69, iCodeTop);
                    ++this.itsStackDepth;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addToken(48, iCodeTop);
                    --this.itsStackDepth;
                    Node.Target target = new Node.Target();
                    thisCase.addChildAfter(target, first);
                    iCodeTop = this.addGoto(target, 71, iCodeTop);
                    --this.itsStackDepth;
                }
                iCodeTop = this.addToken(51, iCodeTop);
                --this.itsStackDepth;
                Node defaultNode = (Node)switchNode.getProp(9);
                if (defaultNode != null) {
                    Node.Target defaultTarget = new Node.Target();
                    defaultNode.getFirstChild().addChildToFront(defaultTarget);
                    iCodeTop = this.addGoto(defaultTarget, 6, iCodeTop);
                }
                Node.Target breakTarget = switchNode.target;
                iCodeTop = this.addGoto(breakTarget, 6, iCodeTop);
                break;
            }
            case 111: {
                stackShouldBeZero = true;
                this.markTargetLabel((Node.Target)node, iCodeTop);
                break;
            }
            case 31: 
            case 38: {
                stackDelta = 1;
                if (type == 31) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                } else {
                    iCodeTop = this.generateCallFunAndThis(child, iCodeTop);
                    if (this.itsStackDepth - savedStackDepth != 2) {
                        Kit.codeBug();
                    }
                }
                String functionName = null;
                int childType = child.getType();
                if (childType == 39 || childType == 34 || childType == 59) {
                    functionName = this.lastAddString;
                }
                int argCount = 0;
                while ((child = child.getNext()) != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    ++argCount;
                }
                int callType = node.getIntProp(17, 0);
                if (callType != 0) {
                    iCodeTop = this.addIcode(89, iCodeTop);
                    iCodeTop = this.addByte(callType, iCodeTop);
                    iCodeTop = this.addByte(type == 31 ? 1 : 0, iCodeTop);
                    iCodeTop = this.addShort(this.itsLineNumber, iCodeTop);
                } else {
                    iCodeTop = this.addToken(type, iCodeTop);
                    iCodeTop = this.addString(functionName, iCodeTop);
                }
                this.itsStackDepth = type == 31 ? (this.itsStackDepth -= argCount) : (this.itsStackDepth -= argCount + 1);
                iCodeTop = this.addIndex(argCount, iCodeTop);
                if (argCount <= this.itsData.itsMaxCalleeArgs) break;
                this.itsData.itsMaxCalleeArgs = argCount;
                break;
            }
            case 7: 
            case 8: {
                iCodeTop = this.generateICode(child, iCodeTop);
                --this.itsStackDepth;
            }
            case 6: {
                stackShouldBeZero = true;
                Node.Target target = ((Node.Jump)node).target;
                iCodeTop = this.addGoto(target, (byte)type, iCodeTop);
                break;
            }
            case 115: {
                stackShouldBeZero = true;
                Node.Target target = ((Node.Jump)node).target;
                iCodeTop = this.addGoto(target, 92, iCodeTop);
                break;
            }
            case 103: {
                stackShouldBeZero = true;
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int finallyRegister = this.getLocalBlockRef(node);
                iCodeTop = this.addToken(56, iCodeTop);
                iCodeTop = this.addByte(finallyRegister, iCodeTop);
                --this.itsStackDepth;
                while (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    if (this.itsStackDepth != 0) {
                        Kit.codeBug();
                    }
                    child = child.getNext();
                }
                iCodeTop = this.addIcode(93, iCodeTop);
                iCodeTop = this.addByte(finallyRegister, iCodeTop);
                break;
            }
            case 82: 
            case 83: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addIcode(68, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth > this.itsData.itsMaxStack) {
                    this.itsData.itsMaxStack = this.itsStackDepth;
                }
                int afterSecondJumpStart = iCodeTop;
                int jump = type == 83 ? 8 : 7;
                iCodeTop = this.addForwardGoto(jump, iCodeTop);
                --this.itsStackDepth;
                iCodeTop = this.addToken(51, iCodeTop);
                --this.itsStackDepth;
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                this.resolveForwardGoto(afterSecondJumpStart, iCodeTop);
                break;
            }
            case 80: {
                stackDelta = 1;
                Node ifThen = child.getNext();
                Node ifElse = ifThen.getNext();
                int elseJumpStart = iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addForwardGoto(8, iCodeTop);
                --this.itsStackDepth;
                int afterElseJumpStart = iCodeTop = this.generateICode(ifThen, iCodeTop);
                iCodeTop = this.addForwardGoto(6, iCodeTop);
                this.resolveForwardGoto(elseJumpStart, iCodeTop);
                this.itsStackDepth = savedStackDepth;
                iCodeTop = this.generateICode(ifElse, iCodeTop);
                this.resolveForwardGoto(afterElseJumpStart, iCodeTop);
                break;
            }
            case 34: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                int special = node.getIntProp(11, 0);
                if (special != 0) {
                    if (special == 1) {
                        iCodeTop = this.addIcode(84, iCodeTop);
                        break;
                    }
                    if (special == 2) {
                        iCodeTop = this.addIcode(85, iCodeTop);
                        break;
                    }
                    this.badTree(node);
                    break;
                }
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(34, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 36: 
            case 48: 
            case 49: 
            case 54: 
            case 55: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 104: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                if (type == 104) {
                    iCodeTop = this.addToken(51, iCodeTop);
                    iCodeTop = this.addToken(61, iCodeTop);
                    break;
                }
                iCodeTop = this.addToken(type, iCodeTop);
                break;
            }
            case 35: 
            case 121: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                int special = node.getIntProp(11, 0);
                if (special != 0) {
                    if (type == 121) {
                        iCodeTop = this.addIcode(68, iCodeTop);
                        if (this.itsStackDepth > this.itsData.itsMaxStack) {
                            this.itsData.itsMaxStack = this.itsStackDepth;
                        }
                        if (special == 1) {
                            iCodeTop = this.addIcode(84, iCodeTop);
                        } else if (special == 2) {
                            iCodeTop = this.addIcode(85, iCodeTop);
                        } else {
                            this.badTree(node);
                        }
                        --this.itsStackDepth;
                    }
                    iCodeTop = this.generateICode(child, iCodeTop);
                    if (special == 1) {
                        iCodeTop = this.addIcode(86, iCodeTop);
                    } else if (special == 2) {
                        iCodeTop = this.addIcode(87, iCodeTop);
                    } else {
                        this.badTree(node);
                    }
                    --this.itsStackDepth;
                    break;
                }
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                if (type == 121) {
                    iCodeTop = this.addIcode(69, iCodeTop);
                    iCodeTop = this.addIcode(69, iCodeTop);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addToken(34, iCodeTop);
                    --this.itsStackDepth;
                    --this.itsStackDepth;
                }
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(35, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 37: 
            case 122: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                if (type == 122) {
                    iCodeTop = this.addIcode(69, iCodeTop);
                    iCodeTop = this.addIcode(69, iCodeTop);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addToken(36, iCodeTop);
                    --this.itsStackDepth;
                    --this.itsStackDepth;
                }
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(37, iCodeTop);
                this.itsStackDepth -= 2;
                break;
            }
            case 9: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(9, iCodeTop);
                iCodeTop = this.addString(firstChild.getString(), iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 119: {
                stackDelta = 1;
                String name = node.getString();
                int index = -1;
                if (this.itsInFunctionFlag && !this.itsData.itsNeedsActivation) {
                    index = this.scriptOrFn.getParamOrVarIndex(name);
                }
                if (index == -1) {
                    iCodeTop = this.addIcode(81, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                } else {
                    iCodeTop = this.addToken(59, iCodeTop);
                    iCodeTop = this.addByte(index, iCodeTop);
                    iCodeTop = this.addToken(33, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 39: 
            case 41: 
            case 52: 
            case 58: {
                stackDelta = 1;
                iCodeTop = this.addToken(type, iCodeTop);
                iCodeTop = this.addString(node.getString(), iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 84: 
            case 85: {
                stackDelta = 1;
                int childType = child.getType();
                switch (childType) {
                    case 59: {
                        String name = child.getString();
                        if (this.itsData.itsNeedsActivation) {
                            iCodeTop = this.addIcode(80, iCodeTop);
                            iCodeTop = this.addToken(41, iCodeTop);
                            iCodeTop = this.addString(name, iCodeTop);
                            this.itsStackDepth += 2;
                            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                                this.itsData.itsMaxStack = this.itsStackDepth;
                            }
                            iCodeTop = this.addIcode(type == 84 ? 73 : 77, iCodeTop);
                            --this.itsStackDepth;
                            break;
                        }
                        int i = this.scriptOrFn.getParamOrVarIndex(name);
                        iCodeTop = this.addIcode(type == 84 ? 75 : 79, iCodeTop);
                        iCodeTop = this.addByte(i, iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                    case 34: 
                    case 36: {
                        Node getPropChild = child.getFirstChild();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        getPropChild = getPropChild.getNext();
                        iCodeTop = this.generateICode(getPropChild, iCodeTop);
                        int icode = childType == 34 ? (type == 84 ? 73 : 77) : (type == 84 ? 74 : 78);
                        iCodeTop = this.addIcode(icode, iCodeTop);
                        --this.itsStackDepth;
                        break;
                    }
                    default: {
                        iCodeTop = this.addIcode(type == 84 ? 72 : 76, iCodeTop);
                        iCodeTop = this.addString(child.getString(), iCodeTop);
                        ++this.itsStackDepth;
                        if (this.itsStackDepth <= this.itsData.itsMaxStack) break block0;
                        this.itsData.itsMaxStack = this.itsStackDepth;
                        break;
                    }
                }
                break;
            }
            case 40: {
                stackDelta = 1;
                double num = node.getDouble();
                int inum = (int)num;
                if ((double)inum == num) {
                    if (inum == 0) {
                        iCodeTop = this.addToken(42, iCodeTop);
                        if (1.0 / num < 0.0) {
                            iCodeTop = this.addToken(30, iCodeTop);
                        }
                    } else if (inum == 1) {
                        iCodeTop = this.addToken(43, iCodeTop);
                    } else if ((short)inum == inum) {
                        iCodeTop = this.addIcode(95, iCodeTop);
                        iCodeTop = this.addShort(inum, iCodeTop);
                    } else {
                        iCodeTop = this.addIcode(96, iCodeTop);
                        iCodeTop = this.addInt(inum, iCodeTop);
                    }
                } else {
                    iCodeTop = this.addToken(40, iCodeTop);
                    iCodeTop = this.addDouble(num, iCodeTop);
                }
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 2: {
                stackShouldBeZero = true;
            }
            case 51: {
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(type, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 3: {
                stackShouldBeZero = true;
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(3, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 62: {
                stackDelta = 1;
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(62, iCodeTop);
                iCodeTop = this.addString(node.getString(), iCodeTop);
                break;
            }
            case 4: {
                stackShouldBeZero = true;
                iCodeTop = this.addToken(4, iCodeTop);
                break;
            }
            case 69: {
                stackShouldBeZero = true;
                Node.Jump tryNode = (Node.Jump)node;
                int exceptionObjectLocal = this.getLocalBlockRef(tryNode);
                Node.Target catchTarget = tryNode.target;
                Node.Target finallyTarget = tryNode.getFinally();
                int tryStart = iCodeTop;
                int tryEnd = -1;
                int catchStart = -1;
                int finallyStart = -1;
                while (child != null) {
                    boolean generated = false;
                    if (child == catchTarget) {
                        if (tryEnd >= 0) {
                            Kit.codeBug();
                        }
                        tryEnd = iCodeTop;
                        catchStart = iCodeTop;
                        this.markTargetLabel((Node.Target)child, iCodeTop);
                        generated = true;
                    } else if (child == finallyTarget) {
                        if (tryEnd < 0) {
                            tryEnd = iCodeTop;
                        }
                        finallyStart = iCodeTop;
                        this.markTargetLabel((Node.Target)child, iCodeTop);
                        generated = true;
                    }
                    if (!generated) {
                        iCodeTop = this.generateICode(child, iCodeTop);
                    }
                    child = child.getNext();
                }
                this.addExceptionHandler(tryStart, tryEnd, catchStart, finallyStart, this.itsWithDepth, exceptionObjectLocal);
                break;
            }
            case 53: {
                stackShouldBeZero = true;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(53, iCodeTop);
                iCodeTop = this.addShort(this.itsLineNumber, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 5: {
                stackShouldBeZero = true;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                if (child != null) {
                    iCodeTop = this.generateICode(child, iCodeTop);
                    iCodeTop = this.addToken(5, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                iCodeTop = this.addIcode(90, iCodeTop);
                break;
            }
            case 67: {
                stackShouldBeZero = true;
                iCodeTop = this.updateLineNumber(node, iCodeTop);
                iCodeTop = this.addToken(67, iCodeTop);
                break;
            }
            case 59: {
                stackDelta = 1;
                String name = node.getString();
                if (this.itsData.itsNeedsActivation) {
                    iCodeTop = this.addIcode(80, iCodeTop);
                    iCodeTop = this.addToken(41, iCodeTop);
                    iCodeTop = this.addString(name, iCodeTop);
                    this.itsStackDepth += 2;
                    if (this.itsStackDepth > this.itsData.itsMaxStack) {
                        this.itsData.itsMaxStack = this.itsStackDepth;
                    }
                    iCodeTop = this.addToken(34, iCodeTop);
                    --this.itsStackDepth;
                    break;
                }
                int index = this.scriptOrFn.getParamOrVarIndex(name);
                iCodeTop = this.addToken(59, iCodeTop);
                iCodeTop = this.addByte(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 60: {
                stackDelta = 1;
                if (this.itsData.itsNeedsActivation) {
                    child.setType(52);
                    node.setType(9);
                    iCodeTop = this.generateICode(node, iCodeTop);
                    break;
                }
                String name = child.getString();
                child = child.getNext();
                iCodeTop = this.generateICode(child, iCodeTop);
                int index = this.scriptOrFn.getParamOrVarIndex(name);
                iCodeTop = this.addToken(60, iCodeTop);
                iCodeTop = this.addByte(index, iCodeTop);
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 61: 
            case 66: {
                stackDelta = 1;
                iCodeTop = this.addToken(type, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 63: {
                stackShouldBeZero = true;
                iCodeTop = this.generateICode(child, iCodeTop);
                iCodeTop = this.addToken(63, iCodeTop);
                iCodeTop = this.addLocalBlockRef(node, iCodeTop);
                --this.itsStackDepth;
                break;
            }
            case 64: 
            case 65: {
                stackDelta = 1;
                iCodeTop = this.addToken(type, iCodeTop);
                iCodeTop = this.addLocalBlockRef(node, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            case 50: {
                stackDelta = 1;
                int index = node.getExistingIntProp(7);
                iCodeTop = this.addToken(50, iCodeTop);
                iCodeTop = this.addIndex(index, iCodeTop);
                ++this.itsStackDepth;
                if (this.itsStackDepth <= this.itsData.itsMaxStack) break;
                this.itsData.itsMaxStack = this.itsStackDepth;
                break;
            }
            default: {
                this.badTree(node);
            }
        }
        if (stackDelta != this.itsStackDepth - savedStackDepth) {
            Kit.codeBug();
        }
        if (stackShouldBeZero && (stackDelta != 0 || this.itsStackDepth != 0)) {
            Kit.codeBug();
        }
        return iCodeTop;
    }

    private int generateCallFunAndThis(Node left, int iCodeTop) {
        int type = left.getType();
        if (type == 39) {
            String name = left.getString();
            iCodeTop = this.addIcode(82, iCodeTop);
            iCodeTop = this.addString(name, iCodeTop);
            this.itsStackDepth += 2;
            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = this.itsStackDepth;
            }
        } else if (type == 34 || type == 36) {
            Node leftLeft = left.getFirstChild();
            left.removeChild(leftLeft);
            left.addChildToFront(new Node(120));
            iCodeTop = this.generateICode(leftLeft, iCodeTop);
            iCodeTop = this.addIcode(68, iCodeTop);
            iCodeTop = this.generateICode(left, iCodeTop);
            iCodeTop = this.addIcode(70, iCodeTop);
        } else {
            iCodeTop = this.generateICode(left, iCodeTop);
            iCodeTop = this.addIcode(83, iCodeTop);
            ++this.itsStackDepth;
            if (this.itsStackDepth > this.itsData.itsMaxStack) {
                this.itsData.itsMaxStack = this.itsStackDepth;
            }
        }
        return iCodeTop;
    }

    private int getLocalBlockRef(Node node) {
        Node localBlock = (Node)node.getProp(4);
        return localBlock.getExistingIntProp(3);
    }

    private int addLocalBlockRef(Node node, int iCodeTop) {
        int localSlot = this.getLocalBlockRef(node);
        iCodeTop = this.addByte(localSlot, iCodeTop);
        return iCodeTop;
    }

    private int getTargetLabel(Node.Target target) {
        int label = target.labelId;
        if (label != -1) {
            return label;
        }
        label = this.itsLabelTableTop;
        if (this.itsLabelTable == null || label == this.itsLabelTable.length) {
            if (this.itsLabelTable == null) {
                this.itsLabelTable = new int[32];
            } else {
                int[] tmp = new int[this.itsLabelTable.length * 2];
                System.arraycopy(this.itsLabelTable, 0, tmp, 0, label);
                this.itsLabelTable = tmp;
            }
        }
        this.itsLabelTableTop = label + 1;
        this.itsLabelTable[label] = -1;
        target.labelId = label;
        return label;
    }

    private void markTargetLabel(Node.Target target, int iCodeTop) {
        int label = this.getTargetLabel(target);
        if (this.itsLabelTable[label] != -1) {
            Kit.codeBug();
        }
        this.itsLabelTable[label] = iCodeTop;
    }

    private int addGoto(Node.Target target, int gotoOp, int iCodeTop) {
        int label = this.getTargetLabel(target);
        if (label >= this.itsLabelTableTop) {
            Kit.codeBug();
        }
        int targetPC = this.itsLabelTable[label];
        int gotoPC = iCodeTop;
        iCodeTop = gotoOp > 67 ? this.addIcode(gotoOp, iCodeTop) : this.addToken(gotoOp, iCodeTop);
        int jumpSite = iCodeTop;
        iCodeTop = this.addShort(0, iCodeTop);
        if (targetPC != -1) {
            this.recordJumpOffset(jumpSite, targetPC - gotoPC);
        } else {
            int top = this.itsFixupTableTop;
            if (this.itsFixupTable == null || top == this.itsFixupTable.length) {
                if (this.itsFixupTable == null) {
                    this.itsFixupTable = new long[40];
                } else {
                    long[] tmp = new long[this.itsFixupTable.length * 2];
                    System.arraycopy(this.itsFixupTable, 0, tmp, 0, top);
                    this.itsFixupTable = tmp;
                }
            }
            this.itsFixupTableTop = top + 1;
            this.itsFixupTable[top] = (long)label << 32 | (long)jumpSite;
        }
        return iCodeTop;
    }

    private void fixLabelGotos() {
        byte[] codeBuffer = this.itsData.itsICode;
        for (int i = 0; i < this.itsFixupTableTop; ++i) {
            long fixup = this.itsFixupTable[i];
            int label = (int)(fixup >> 32);
            int fixupSite = (int)fixup;
            int pc = this.itsLabelTable[label];
            if (pc == -1) {
                throw new RuntimeException();
            }
            int offset = pc - (fixupSite - 1);
            if ((short)offset != offset) {
                throw new RuntimeException("Program too complex: too big jump offset");
            }
            codeBuffer[fixupSite] = (byte)(offset >> 8);
            codeBuffer[fixupSite + 1] = (byte)offset;
        }
        this.itsFixupTableTop = 0;
    }

    private int addForwardGoto(int gotoOp, int iCodeTop) {
        iCodeTop = this.addToken(gotoOp, iCodeTop);
        iCodeTop = this.addShort(0, iCodeTop);
        return iCodeTop;
    }

    private void resolveForwardGoto(int jumpStart, int iCodeTop) {
        if (jumpStart + 3 > iCodeTop) {
            Kit.codeBug();
        }
        int offset = iCodeTop - jumpStart;
        this.recordJumpOffset(jumpStart + 1, offset);
    }

    private void recordJumpOffset(int pos, int offset) {
        if (offset != (short)offset) {
            throw Context.reportRuntimeError0("msg.too.big.jump");
        }
        this.itsData.itsICode[pos] = (byte)(offset >> 8);
        this.itsData.itsICode[pos + 1] = (byte)offset;
    }

    private int addByte(int value, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop == array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 1);
        }
        array[iCodeTop++] = (byte)value;
        return iCodeTop;
    }

    private int addToken(int token, int iCodeTop) {
        if (2 > token || token > 67) {
            Kit.codeBug();
        }
        return this.addByte(token, iCodeTop);
    }

    private int addIcode(int icode, int iCodeTop) {
        if (67 >= icode || icode >= 97) {
            Kit.codeBug();
        }
        return this.addByte(icode, iCodeTop);
    }

    private int addShort(int s, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 2 > array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 2);
        }
        array[iCodeTop] = (byte)(s >>> 8);
        array[iCodeTop + 1] = (byte)s;
        return iCodeTop + 2;
    }

    private int addIndex(int index, int iCodeTop) {
        if (index < 0) {
            Kit.codeBug();
        }
        if (index > 65535) {
            throw Context.reportRuntimeError0("msg.too.big.index");
        }
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 2 > array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 2);
        }
        array[iCodeTop] = (byte)(index >>> 8);
        array[iCodeTop + 1] = (byte)index;
        return iCodeTop + 2;
    }

    private int addInt(int i, int iCodeTop) {
        byte[] array = this.itsData.itsICode;
        if (iCodeTop + 4 > array.length) {
            array = this.increaseICodeCapasity(iCodeTop, 4);
        }
        array[iCodeTop] = (byte)(i >>> 24);
        array[iCodeTop + 1] = (byte)(i >>> 16);
        array[iCodeTop + 2] = (byte)(i >>> 8);
        array[iCodeTop + 3] = (byte)i;
        return iCodeTop + 4;
    }

    private int addDouble(double num, int iCodeTop) {
        int index = this.itsDoubleTableTop;
        if (index == 0) {
            this.itsData.itsDoubleTable = new double[64];
        } else if (this.itsData.itsDoubleTable.length == index) {
            double[] na = new double[index * 2];
            System.arraycopy(this.itsData.itsDoubleTable, 0, na, 0, index);
            this.itsData.itsDoubleTable = na;
        }
        this.itsData.itsDoubleTable[index] = num;
        this.itsDoubleTableTop = index + 1;
        iCodeTop = this.addIndex(index, iCodeTop);
        return iCodeTop;
    }

    private int addString(String str, int iCodeTop) {
        int index = this.itsStrings.get(str, -1);
        if (index == -1) {
            index = this.itsStrings.size();
            this.itsStrings.put(str, index);
        }
        iCodeTop = this.addIndex(index, iCodeTop);
        this.lastAddString = str;
        return iCodeTop;
    }

    private void addExceptionHandler(int icodeStart, int icodeEnd, int catchStart, int finallyStart, int withDepth, int exceptionObjectLocal) {
        int top = this.itsExceptionTableTop;
        int[] table = this.itsData.itsExceptionTable;
        if (table == null) {
            if (top != 0) {
                Kit.codeBug();
            }
            this.itsData.itsExceptionTable = table = new int[12];
        } else if (table.length == top) {
            table = new int[table.length * 2];
            System.arraycopy(this.itsData.itsExceptionTable, 0, table, 0, top);
            this.itsData.itsExceptionTable = table;
        }
        table[top + 0] = icodeStart;
        table[top + 1] = icodeEnd;
        table[top + 2] = catchStart;
        table[top + 3] = finallyStart;
        table[top + 4] = withDepth;
        table[top + 5] = exceptionObjectLocal;
        this.itsExceptionTableTop = top + 6;
    }

    private byte[] increaseICodeCapasity(int iCodeTop, int extraSize) {
        int capacity = this.itsData.itsICode.length;
        if (iCodeTop + extraSize <= capacity) {
            Kit.codeBug();
        }
        if (iCodeTop + extraSize > (capacity *= 2)) {
            capacity = iCodeTop + extraSize;
        }
        byte[] array = new byte[capacity];
        System.arraycopy(this.itsData.itsICode, 0, array, 0, iCodeTop);
        this.itsData.itsICode = array;
        return array;
    }

    private static int getShort(byte[] iCode, int pc) {
        return iCode[pc] << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getIndex(byte[] iCode, int pc) {
        return (iCode[pc] & 0xFF) << 8 | iCode[pc + 1] & 0xFF;
    }

    private static int getInt(byte[] iCode, int pc) {
        return iCode[pc] << 24 | (iCode[pc + 1] & 0xFF) << 16 | (iCode[pc + 2] & 0xFF) << 8 | iCode[pc + 3] & 0xFF;
    }

    private static int getTarget(byte[] iCode, int pc) {
        int displacement = Interpreter.getShort(iCode, pc);
        return pc - 1 + displacement;
    }

    private static int getExceptionHandler(int[] exceptionTable, int pc) {
        if (exceptionTable == null) {
            return -1;
        }
        int best = -1;
        int bestStart = 0;
        int bestEnd = 0;
        for (int i = 0; i != exceptionTable.length; i += 6) {
            int start = exceptionTable[i + 0];
            int end = exceptionTable[i + 1];
            if (start > pc || pc >= end || best >= 0 && bestStart > start) continue;
            if (best >= 0 && bestEnd < end) {
                Kit.codeBug();
            }
            best = i;
            bestStart = start;
            bestEnd = end;
        }
        return best;
    }

    private static String icodeToName(int icode) {
        return "";
    }

    private static void dumpICode(InterpreterData idata) {
    }

    private static int icodeTokenLength(int icodeToken) {
        switch (icodeToken) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 54: 
            case 55: 
            case 61: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 73: 
            case 74: 
            case 77: 
            case 78: 
            case 80: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 90: 
            case 91: {
                return 1;
            }
            case 53: {
                return 3;
            }
            case 6: 
            case 7: 
            case 8: 
            case 71: 
            case 92: {
                return 3;
            }
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 63: 
            case 64: 
            case 65: 
            case 75: 
            case 79: 
            case 93: {
                return 2;
            }
            case 89: {
                return 7;
            }
            case 50: {
                return 3;
            }
            case 88: {
                return 3;
            }
            case 31: 
            case 38: {
                return 5;
            }
            case 95: {
                return 3;
            }
            case 96: {
                return 5;
            }
            case 40: {
                return 3;
            }
            case 9: 
            case 39: 
            case 41: 
            case 52: 
            case 58: 
            case 62: 
            case 72: 
            case 76: 
            case 81: 
            case 82: {
                return 3;
            }
            case 94: {
                return 3;
            }
        }
        Kit.codeBug();
        return 0;
    }

    static int[] getLineNumbers(InterpreterData data) {
        int icodeLength;
        UintMap presentLines = new UintMap();
        int iCodeLength = data.itsICodeTop;
        byte[] iCode = data.itsICode;
        for (int pc = 0; pc != iCodeLength; pc += icodeLength) {
            int icodeToken = iCode[pc] & 0xFF;
            icodeLength = Interpreter.icodeTokenLength(icodeToken);
            if (icodeToken != 94) continue;
            if (icodeLength != 3) {
                Kit.codeBug();
            }
            int line = Interpreter.getShort(iCode, pc + 1);
            presentLines.put(line, 0);
        }
        return presentLines.getKeys();
    }

    static String getSourcePositionFromStack(Context cx, int[] linep) {
        InterpreterData idata = cx.interpreterData;
        linep[0] = Interpreter.getShort(idata.itsICode, cx.interpreterLineIndex);
        return idata.itsSourceFile;
    }

    static String getEncodedSource(InterpreterData idata) {
        if (idata.encodedSource == null) {
            return null;
        }
        return idata.encodedSource.substring(idata.encodedSourceStart, idata.encodedSourceEnd);
    }

    private static Scriptable[] wrapRegExps(Context cx, Scriptable scope, InterpreterData idata) {
        if (idata.itsRegExpLiterals == null) {
            Kit.codeBug();
        }
        RegExpProxy rep = ScriptRuntime.checkRegExpProxy(cx);
        int N = idata.itsRegExpLiterals.length;
        Scriptable[] array = new Scriptable[N];
        for (int i = 0; i != N; ++i) {
            array[i] = rep.wrapRegExp(cx, scope, idata.itsRegExpLiterals[i]);
        }
        return array;
    }

    private static InterpretedFunction createFunction(Context cx, Scriptable scope, InterpreterData idata, boolean fromEvalCode) {
        InterpretedFunction fn = new InterpretedFunction(idata);
        if (idata.itsRegExpLiterals != null) {
            fn.itsRegExps = Interpreter.wrapRegExps(cx, scope, idata);
        }
        ScriptRuntime.initFunction(cx, scope, fn, idata.itsFunctionType, fromEvalCode);
        return fn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object interpret(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, double[] argsDbl, int argShift, int argCount, NativeFunction fnOrScript, InterpreterData idata) throws JavaScriptException {
        int pc;
        int i;
        if (cx.interpreterSecurityDomain != idata.securityDomain) {
            if (argsDbl != null) {
                args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
            }
            SecurityController sc = idata.securityController;
            Object savedDomain = cx.interpreterSecurityDomain;
            cx.interpreterSecurityDomain = idata.securityDomain;
            try {
                Object object = sc.callWithDomain(idata.securityDomain, cx, fnOrScript, scope, thisObj, args);
                return object;
            }
            finally {
                cx.interpreterSecurityDomain = savedDomain;
            }
        }
        Object DBL_MRK = Interpreter.DBL_MRK;
        Scriptable undefined = Undefined.instance;
        boolean VAR_SHFT = false;
        int maxFrameArray = idata.itsMaxFrameArray;
        int maxVars = idata.itsMaxVars;
        int LOCAL_SHFT = 0 + maxVars;
        int STACK_SHFT = LOCAL_SHFT + idata.itsMaxLocals;
        if (maxFrameArray != STACK_SHFT + idata.itsMaxStack) {
            Kit.codeBug();
        }
        Object[] stack = new Object[maxFrameArray];
        double[] sDbl = new double[maxFrameArray];
        int stackTop = STACK_SHFT - 1;
        int withDepth = 0;
        int definedArgs = fnOrScript.argCount;
        if (definedArgs > argCount) {
            definedArgs = argCount;
        }
        for (i = 0; i != definedArgs; ++i) {
            Object arg;
            stack[0 + i] = arg = args[argShift + i];
            if (arg != DBL_MRK) continue;
            sDbl[0 + i] = argsDbl[argShift + i];
        }
        for (i = definedArgs; i != maxVars; ++i) {
            stack[0 + i] = undefined;
        }
        DebugFrame debuggerFrame = null;
        if (cx.debugger != null) {
            debuggerFrame = cx.debugger.getFrame(cx, idata);
        }
        if (idata.itsFunctionType != 0) {
            InterpretedFunction f = (InterpretedFunction)fnOrScript;
            if (!idata.useDynamicScope) {
                scope = fnOrScript.getParentScope();
            }
            if (idata.itsCheckThis) {
                thisObj = ScriptRuntime.getThis(thisObj);
            }
            if (idata.itsNeedsActivation) {
                if (argsDbl != null) {
                    args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
                    argShift = 0;
                    argsDbl = null;
                }
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
        } else {
            ScriptRuntime.initScript(cx, scope, fnOrScript, thisObj, idata.itsFromEvalCode);
        }
        if (idata.itsNestedFunctions != null) {
            if (idata.itsFunctionType != 0 && !idata.itsNeedsActivation) {
                Kit.codeBug();
            }
            for (int i2 = 0; i2 < idata.itsNestedFunctions.length; ++i2) {
                InterpreterData fdata = idata.itsNestedFunctions[i2];
                if (fdata.itsFunctionType != 1) continue;
                Interpreter.createFunction(cx, scope, fdata, idata.itsFromEvalCode);
            }
        }
        Scriptable[] scriptRegExps = null;
        boolean useActivationVars = false;
        if (debuggerFrame != null) {
            if (argsDbl != null) {
                args = Interpreter.getArgsArray(args, argsDbl, argShift, argCount);
                argShift = 0;
                argsDbl = null;
            }
            if (idata.itsFunctionType != 0 && !idata.itsNeedsActivation) {
                useActivationVars = true;
                scope = ScriptRuntime.initVarObj(cx, scope, fnOrScript, thisObj, args);
            }
            debuggerFrame.onEnter(cx, scope, thisObj, args);
        }
        InterpreterData savedData = cx.interpreterData;
        cx.interpreterData = idata;
        Object result = undefined;
        Throwable javaException = null;
        int exceptionPC = -1;
        byte[] iCode = idata.itsICode;
        String[] strings = idata.itsStringTable;
        int pcPrevBranch = pc = 0;
        int instructionThreshold = cx.instructionThreshold;
        int instructionCount = cx.instructionCount;
        int INVOCATION_COST = 100;
        block104: while (true) {
            try {
                block105: while (true) {
                    switch (iCode[pc] & 0xFF) {
                        case 91: {
                            if (javaException == null) {
                                Kit.codeBug();
                            }
                            int pcNew = -1;
                            boolean doCatch = false;
                            int handlerOffset = Interpreter.getExceptionHandler(idata.itsExceptionTable, exceptionPC);
                            if (handlerOffset >= 0) {
                                boolean SCRIPT_CAN_CATCH = false;
                                boolean ONLY_FINALLY = true;
                                int OTHER = 2;
                                int exType = javaException instanceof JavaScriptException ? 0 : (javaException instanceof EcmaError ? 0 : (javaException instanceof EvaluatorException ? 0 : (javaException instanceof RuntimeException ? 1 : 2)));
                                if (exType != 2) {
                                    if (exType == 0 && (pcNew = idata.itsExceptionTable[handlerOffset + 2]) >= 0) {
                                        doCatch = true;
                                    }
                                    if (pcNew < 0) {
                                        pcNew = idata.itsExceptionTable[handlerOffset + 3];
                                    }
                                }
                            }
                            if (debuggerFrame != null && !(javaException instanceof Error)) {
                                debuggerFrame.onExceptionThrown(cx, javaException);
                            }
                            if (pcNew < 0) break block104;
                            int tryWithDepth = idata.itsExceptionTable[handlerOffset + 4];
                            while (tryWithDepth != withDepth) {
                                if (scope == null) {
                                    Kit.codeBug();
                                }
                                scope = ScriptRuntime.leaveWith(scope);
                                --withDepth;
                            }
                            if (doCatch) {
                                stackTop = STACK_SHFT - 1;
                                int exLocal = idata.itsExceptionTable[handlerOffset + 5];
                                stack[LOCAL_SHFT + exLocal] = ScriptRuntime.getCatchObject(cx, scope, javaException);
                            } else {
                                stackTop = STACK_SHFT;
                                stack[stackTop] = javaException;
                            }
                            javaException = null;
                            if (instructionThreshold != 0 && instructionCount > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = pcNew;
                            continue block105;
                        }
                        case 53: {
                            Object value = stack[stackTop];
                            if (value == DBL_MRK) {
                                value = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            int sourceLine = Interpreter.getShort(iCode, pc + 1);
                            javaException = new JavaScriptException(value, idata.itsSourceFile, sourceLine);
                            exceptionPC = pc;
                            if (instructionThreshold != 0 && (instructionCount += pc + 1 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getJavaCatchPC(iCode);
                            continue block105;
                        }
                        case 18: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl <= lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 16: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl <= rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LE(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 17: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && rDbl < lDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(rhs, lhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 15: {
                            boolean valBln;
                            Object rhs = stack[--stackTop + 1];
                            Object lhs = stack[stackTop];
                            if (rhs == DBL_MRK || lhs == DBL_MRK) {
                                double rDbl = Interpreter.stack_double(stack, sDbl, stackTop + 1);
                                double lDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                                valBln = rDbl == rDbl && lDbl == lDbl && lDbl < rDbl;
                            } else {
                                valBln = 1 == ScriptRuntime.cmp_LT(lhs, rhs);
                            }
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 54: {
                            Object lhs;
                            boolean valBln;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.in(lhs, rhs, scope)) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 55: {
                            Object lhs;
                            boolean valBln;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = (valBln = ScriptRuntime.instanceOf(lhs, rhs, scope)) ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 13: {
                            boolean valBln = Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 14: {
                            boolean valBln = !Interpreter.do_eq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 48: {
                            boolean valBln = Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 49: {
                            boolean valBln = !Interpreter.do_sheq(stack, sDbl, --stackTop);
                            stack[stackTop] = valBln ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 8: {
                            boolean valBln = Interpreter.stack_boolean(stack, sDbl, stackTop);
                            --stackTop;
                            if (!valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block105;
                            }
                            pc += 2;
                            break;
                        }
                        case 7: {
                            boolean valBln = Interpreter.stack_boolean(stack, sDbl, stackTop);
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                continue block105;
                            }
                            pc += 2;
                            break;
                        }
                        case 71: {
                            boolean valBln = Interpreter.stack_boolean(stack, sDbl, stackTop);
                            --stackTop;
                            if (valBln) {
                                if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                    cx.observeInstructionCount(instructionCount);
                                    instructionCount = 0;
                                }
                                pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                                stack[stackTop--] = null;
                                continue block105;
                            }
                            pc += 2;
                            break;
                        }
                        case 6: {
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block105;
                        }
                        case 92: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = pc + 3;
                            if (instructionThreshold != 0 && (instructionCount += pc + 3 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            pcPrevBranch = pc = Interpreter.getTarget(iCode, pc + 1);
                            continue block105;
                        }
                        case 93: {
                            int newPC;
                            Object value;
                            int slot = iCode[pc + 1] & 0xFF;
                            if (instructionThreshold != 0 && (instructionCount += pc + 2 - pcPrevBranch) > instructionThreshold) {
                                cx.observeInstructionCount(instructionCount);
                                instructionCount = 0;
                            }
                            if ((value = stack[LOCAL_SHFT + slot]) != DBL_MRK) {
                                javaException = (Throwable)value;
                                exceptionPC = pc;
                                newPC = Interpreter.getJavaCatchPC(iCode);
                            } else {
                                newPC = (int)sDbl[LOCAL_SHFT + slot];
                            }
                            pcPrevBranch = pc = newPC;
                            continue block105;
                        }
                        case 51: {
                            stack[stackTop] = null;
                            --stackTop;
                            break;
                        }
                        case 68: {
                            stack[stackTop + 1] = stack[stackTop];
                            sDbl[stackTop + 1] = sDbl[stackTop];
                            ++stackTop;
                            break;
                        }
                        case 69: {
                            stack[stackTop + 1] = stack[stackTop - 1];
                            sDbl[stackTop + 1] = sDbl[stackTop - 1];
                            ++stackTop;
                            break;
                        }
                        case 70: {
                            Object o = stack[stackTop];
                            stack[stackTop] = stack[stackTop - 1];
                            stack[stackTop - 1] = o;
                            double d = sDbl[stackTop];
                            sDbl[stackTop] = sDbl[stackTop - 1];
                            sDbl[stackTop - 1] = d;
                            break;
                        }
                        case 2: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = null;
                            --stackTop;
                            break;
                        }
                        case 5: {
                            result = stack[stackTop];
                            if (result == DBL_MRK) {
                                result = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            break block104;
                        }
                        case 67: {
                            break block104;
                        }
                        case 90: {
                            result = undefined;
                            break block104;
                        }
                        case 28: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ~rIntValue;
                            break;
                        }
                        case 12: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue & rIntValue;
                            break;
                        }
                        case 10: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue | rIntValue;
                            break;
                        }
                        case 11: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue ^ rIntValue;
                            break;
                        }
                        case 19: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue << rIntValue;
                            break;
                        }
                        case 20: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop);
                            int lIntValue = Interpreter.stack_int32(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lIntValue >> rIntValue;
                            break;
                        }
                        case 21: {
                            int rIntValue = Interpreter.stack_int32(stack, sDbl, stackTop) & 0x1F;
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = ScriptRuntime.toUint32(lDbl) >>> rIntValue;
                            break;
                        }
                        case 22: {
                            Interpreter.do_add(stack, sDbl, --stackTop);
                            break;
                        }
                        case 23: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl - rDbl;
                            break;
                        }
                        case 30: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = -rDbl;
                            break;
                        }
                        case 29: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = rDbl;
                            break;
                        }
                        case 24: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl * rDbl;
                            break;
                        }
                        case 25: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl / rDbl;
                            break;
                        }
                        case 26: {
                            double rDbl = Interpreter.stack_double(stack, sDbl, stackTop);
                            double lDbl = Interpreter.stack_double(stack, sDbl, --stackTop);
                            stack[stackTop] = DBL_MRK;
                            sDbl[stackTop] = lDbl % rDbl;
                            break;
                        }
                        case 27: {
                            stack[stackTop] = Interpreter.stack_boolean(stack, sDbl, stackTop) ? Boolean.FALSE : Boolean.TRUE;
                            break;
                        }
                        case 52: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.bind(scope, name);
                            pc += 2;
                            break;
                        }
                        case 58: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.getBase(scope, name);
                            pc += 2;
                            break;
                        }
                        case 9: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Scriptable lhs = (Scriptable)stack[--stackTop];
                            stack[stackTop] = ScriptRuntime.setName(lhs, rhs, scope, name);
                            pc += 2;
                            break;
                        }
                        case 32: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.delete(cx, scope, lhs, rhs);
                            break;
                        }
                        case 34: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProp(lhs, name, scope);
                            break;
                        }
                        case 35: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            String name = (String)stack[--stackTop];
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProp(lhs, name, rhs, scope);
                            break;
                        }
                        case 36: {
                            Interpreter.do_getElem(cx, stack, sDbl, stackTop, scope);
                            --stackTop;
                            break;
                        }
                        case 37: {
                            Interpreter.do_setElem(cx, stack, sDbl, stackTop, scope);
                            stackTop -= 2;
                            break;
                        }
                        case 73: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrement(lhs, name, scope);
                            break;
                        }
                        case 77: {
                            String name = (String)stack[stackTop];
                            Object lhs = stack[--stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrement(lhs, name, scope);
                            break;
                        }
                        case 74: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postIncrementElem(lhs, rhs, scope);
                            break;
                        }
                        case 78: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.postDecrementElem(lhs, rhs, scope);
                            break;
                        }
                        case 56: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[LOCAL_SHFT + slot] = stack[stackTop];
                            sDbl[LOCAL_SHFT + slot] = sDbl[stackTop];
                            --stackTop;
                            break;
                        }
                        case 57: {
                            int slot = iCode[++pc] & 0xFF;
                            stack[++stackTop] = stack[LOCAL_SHFT + slot];
                            sDbl[stackTop] = sDbl[LOCAL_SHFT + slot];
                            break;
                        }
                        case 89: {
                            Object functionThis;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int callType = iCode[pc + 1] & 0xFF;
                            boolean isNew = iCode[pc + 2] != 0;
                            int sourceLine = Interpreter.getShort(iCode, pc + 3);
                            int count = Interpreter.getIndex(iCode, pc + 5);
                            Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, (stackTop -= count) + 1, count);
                            if (isNew) {
                                functionThis = null;
                            } else {
                                functionThis = stack[stackTop];
                                if (functionThis == DBL_MRK) {
                                    functionThis = Interpreter.doubleWrap(sDbl[stackTop]);
                                }
                                --stackTop;
                            }
                            Object function = stack[stackTop];
                            if (function == DBL_MRK) {
                                function = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.callSpecial(cx, function, isNew, functionThis, outArgs, scope, thisObj, callType, idata.itsSourceFile, sourceLine);
                            pc += 6;
                            instructionCount = cx.instructionCount;
                            break;
                        }
                        case 38: {
                            Function f;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int count = Interpreter.getIndex(iCode, pc + 3);
                            int calleeArgShft = (stackTop -= count) + 1;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Object lhs = stack[--stackTop];
                            Scriptable calleeScope = scope;
                            if (idata.itsNeedsActivation) {
                                calleeScope = ScriptableObject.getTopLevelScope(scope);
                            }
                            Scriptable calleeThis = rhs instanceof Scriptable || rhs == null ? (Scriptable)rhs : ScriptRuntime.toObject(cx, calleeScope, rhs);
                            if (lhs instanceof InterpretedFunction) {
                                f = (InterpretedFunction)lhs;
                                stack[stackTop] = Interpreter.interpret(cx, calleeScope, calleeThis, stack, sDbl, calleeArgShft, count, (NativeFunction)f, ((InterpretedFunction)f).itsData);
                            } else if (lhs instanceof Function) {
                                f = (Function)lhs;
                                Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, calleeArgShft, count);
                                stack[stackTop] = f.call(cx, calleeScope, calleeThis, outArgs);
                            } else {
                                if (lhs == DBL_MRK) {
                                    lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                                } else if (lhs == undefined && (lhs = strings[Interpreter.getIndex(iCode, pc + 1)]) == null) {
                                    lhs = undefined;
                                }
                                throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(lhs));
                            }
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break;
                        }
                        case 31: {
                            Function f;
                            if (instructionThreshold != 0) {
                                cx.instructionCount = instructionCount += 100;
                                instructionCount = -1;
                            }
                            int count = Interpreter.getIndex(iCode, pc + 3);
                            int calleeArgShft = (stackTop -= count) + 1;
                            Object lhs = stack[stackTop];
                            if (lhs instanceof InterpretedFunction) {
                                f = (InterpretedFunction)lhs;
                                Scriptable newInstance = ((BaseFunction)f).createObject(cx, scope);
                                Object callResult = Interpreter.interpret(cx, scope, newInstance, stack, sDbl, calleeArgShft, count, (NativeFunction)f, ((InterpretedFunction)f).itsData);
                                stack[stackTop] = callResult instanceof Scriptable && callResult != undefined ? callResult : newInstance;
                            } else if (lhs instanceof Function) {
                                f = (Function)lhs;
                                Object[] outArgs = Interpreter.getArgsArray(stack, sDbl, calleeArgShft, count);
                                stack[stackTop] = f.construct(cx, scope, outArgs);
                            } else {
                                if (lhs == DBL_MRK) {
                                    lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                                } else if (lhs == undefined && (lhs = strings[Interpreter.getIndex(iCode, pc + 1)]) == null) {
                                    lhs = undefined;
                                }
                                throw ScriptRuntime.typeError1("msg.isnt.function", ScriptRuntime.toString(lhs));
                            }
                            pc += 4;
                            instructionCount = cx.instructionCount;
                            break;
                        }
                        case 33: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.typeof(lhs);
                            break;
                        }
                        case 81: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.typeofName(scope, name);
                            pc += 2;
                            break;
                        }
                        case 82: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            Scriptable base = ScriptRuntime.getBase(scope, name);
                            stack[++stackTop] = ScriptRuntime.getProp(base, name, scope);
                            stack[++stackTop] = ScriptRuntime.getThis(base);
                            pc += 2;
                            break;
                        }
                        case 41: {
                            stack[++stackTop] = strings[Interpreter.getIndex(iCode, pc + 1)];
                            pc += 2;
                            break;
                        }
                        case 95: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getShort(iCode, pc + 1);
                            pc += 2;
                            break;
                        }
                        case 96: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = Interpreter.getInt(iCode, pc + 1);
                            pc += 4;
                            break;
                        }
                        case 40: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = idata.itsDoubleTable[Interpreter.getIndex(iCode, pc + 1)];
                            pc += 2;
                            break;
                        }
                        case 39: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.name(scope, name);
                            pc += 2;
                            break;
                        }
                        case 72: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.postIncrement(scope, name);
                            pc += 2;
                            break;
                        }
                        case 76: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[++stackTop] = ScriptRuntime.postDecrement(scope, name);
                            pc += 2;
                            break;
                        }
                        case 60: {
                            int slot = iCode[++pc] & 0xFF;
                            if (!useActivationVars) {
                                stack[0 + slot] = stack[stackTop];
                                sDbl[0 + slot] = sDbl[stackTop];
                                break;
                            }
                            Object val = stack[stackTop];
                            if (val == DBL_MRK) {
                                val = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            Interpreter.activationPut(fnOrScript, scope, slot, val);
                            break;
                        }
                        case 59: {
                            int slot = iCode[++pc] & 0xFF;
                            ++stackTop;
                            if (!useActivationVars) {
                                stack[stackTop] = stack[0 + slot];
                                sDbl[stackTop] = sDbl[0 + slot];
                                break;
                            }
                            stack[stackTop] = Interpreter.activationGet(fnOrScript, scope, slot);
                            break;
                        }
                        case 75: {
                            Object val;
                            int slot = iCode[++pc] & 0xFF;
                            ++stackTop;
                            if (!useActivationVars) {
                                stack[stackTop] = stack[0 + slot];
                                sDbl[stackTop] = sDbl[0 + slot];
                                stack[0 + slot] = DBL_MRK;
                                sDbl[0 + slot] = Interpreter.stack_double(stack, sDbl, stackTop) + 1.0;
                                break;
                            }
                            stack[stackTop] = val = Interpreter.activationGet(fnOrScript, scope, slot);
                            val = Interpreter.doubleWrap(ScriptRuntime.toNumber(val) + 1.0);
                            Interpreter.activationPut(fnOrScript, scope, slot, val);
                            break;
                        }
                        case 79: {
                            Object val;
                            int slot = iCode[++pc] & 0xFF;
                            ++stackTop;
                            if (!useActivationVars) {
                                stack[stackTop] = stack[0 + slot];
                                sDbl[stackTop] = sDbl[0 + slot];
                                stack[0 + slot] = DBL_MRK;
                                sDbl[0 + slot] = Interpreter.stack_double(stack, sDbl, stackTop) - 1.0;
                                break;
                            }
                            stack[stackTop] = val = Interpreter.activationGet(fnOrScript, scope, slot);
                            val = Interpreter.doubleWrap(ScriptRuntime.toNumber(val) - 1.0);
                            Interpreter.activationPut(fnOrScript, scope, slot, val);
                            break;
                        }
                        case 42: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 0.0;
                            break;
                        }
                        case 43: {
                            stack[++stackTop] = DBL_MRK;
                            sDbl[stackTop] = 1.0;
                            break;
                        }
                        case 44: {
                            stack[++stackTop] = null;
                            break;
                        }
                        case 45: {
                            stack[++stackTop] = thisObj;
                            break;
                        }
                        case 66: {
                            stack[++stackTop] = fnOrScript;
                            break;
                        }
                        case 46: {
                            stack[++stackTop] = Boolean.FALSE;
                            break;
                        }
                        case 47: {
                            stack[++stackTop] = Boolean.TRUE;
                            break;
                        }
                        case 61: {
                            stack[++stackTop] = Undefined.instance;
                            break;
                        }
                        case 3: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            scope = ScriptRuntime.enterWith(lhs, scope);
                            ++withDepth;
                            break;
                        }
                        case 4: {
                            scope = ScriptRuntime.leaveWith(scope);
                            --withDepth;
                            break;
                        }
                        case 62: {
                            String name = strings[Interpreter.getIndex(iCode, pc + 1)];
                            stack[stackTop] = ScriptRuntime.newCatchScope(name, stack[stackTop]);
                            pc += 2;
                            break;
                        }
                        case 63: {
                            int slot = iCode[++pc] & 0xFF;
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            --stackTop;
                            stack[LOCAL_SHFT + slot] = ScriptRuntime.enumInit(lhs, scope);
                            break;
                        }
                        case 64: 
                        case 65: {
                            int slot = iCode[++pc] & 0xFF;
                            Object val = stack[LOCAL_SHFT + slot];
                            stack[++stackTop] = (iCode[pc - 1] & 0xFF) == 64 ? ScriptRuntime.enumNext(val) : ScriptRuntime.enumId(val);
                            break;
                        }
                        case 84: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getProto(lhs, scope);
                            break;
                        }
                        case 83: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[++stackTop] = ScriptRuntime.getParent(lhs);
                            break;
                        }
                        case 85: {
                            Object lhs = stack[stackTop];
                            if (lhs == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.getParent(lhs, scope);
                            break;
                        }
                        case 86: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setProto(lhs, rhs, scope);
                            break;
                        }
                        case 87: {
                            Object lhs;
                            Object rhs = stack[stackTop];
                            if (rhs == DBL_MRK) {
                                rhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            if ((lhs = stack[--stackTop]) == DBL_MRK) {
                                lhs = Interpreter.doubleWrap(sDbl[stackTop]);
                            }
                            stack[stackTop] = ScriptRuntime.setParent(lhs, rhs, scope);
                            break;
                        }
                        case 80: {
                            stack[++stackTop] = scope;
                            break;
                        }
                        case 88: {
                            int i3 = Interpreter.getIndex(iCode, pc + 1);
                            InterpreterData closureData = idata.itsNestedFunctions[i3];
                            stack[++stackTop] = Interpreter.createFunction(cx, scope, closureData, idata.itsFromEvalCode);
                            pc += 2;
                            break;
                        }
                        case 50: {
                            Scriptable regexp;
                            int i4 = Interpreter.getIndex(iCode, pc + 1);
                            if (idata.itsFunctionType != 0) {
                                regexp = ((InterpretedFunction)fnOrScript).itsRegExps[i4];
                            } else {
                                if (scriptRegExps == null) {
                                    scriptRegExps = Interpreter.wrapRegExps(cx, scope, idata);
                                }
                                regexp = scriptRegExps[i4];
                            }
                            stack[++stackTop] = regexp;
                            pc += 2;
                            break;
                        }
                        case 94: {
                            cx.interpreterLineIndex = pc + 1;
                            if (debuggerFrame != null) {
                                int line = Interpreter.getShort(iCode, pc + 1);
                                debuggerFrame.onLineChange(cx, line);
                            }
                            pc += 2;
                            break;
                        }
                        default: {
                            Interpreter.dumpICode(idata);
                            throw new RuntimeException("Unknown icode : " + (iCode[pc] & 0xFF) + " @ pc : " + pc);
                        }
                    }
                    ++pc;
                }
            }
            catch (Throwable ex) {
                if (instructionThreshold != 0) {
                    if (instructionCount < 0) {
                        instructionCount = cx.instructionCount;
                    } else {
                        cx.instructionCount = instructionCount += pc - pcPrevBranch;
                    }
                }
                javaException = ex;
                exceptionPC = pc;
                pc = Interpreter.getJavaCatchPC(iCode);
                continue;
            }
            break;
        }
        cx.interpreterData = savedData;
        if (debuggerFrame != null) {
            if (javaException != null) {
                debuggerFrame.onExit(cx, true, javaException);
            } else {
                debuggerFrame.onExit(cx, false, result);
            }
        }
        if (idata.itsNeedsActivation || debuggerFrame != null) {
            ScriptRuntime.popActivation(cx);
        }
        if (instructionThreshold != 0) {
            if (instructionCount > instructionThreshold) {
                cx.observeInstructionCount(instructionCount);
                instructionCount = 0;
            }
            cx.instructionCount = instructionCount;
        }
        if (javaException != null) {
            if (javaException instanceof JavaScriptException) {
                throw (JavaScriptException)javaException;
            }
            if (javaException instanceof RuntimeException) {
                throw (RuntimeException)javaException;
            }
            throw (Error)javaException;
        }
        return result;
    }

    private static Object doubleWrap(double x) {
        return new Double(x);
    }

    private static int stack_int32(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toInt32(x) : ScriptRuntime.toInt32(stackDbl[i]);
    }

    private static double stack_double(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        return x != DBL_MRK ? ScriptRuntime.toNumber(x) : stackDbl[i];
    }

    private static boolean stack_boolean(Object[] stack, double[] stackDbl, int i) {
        Object x = stack[i];
        if (x == DBL_MRK) {
            double d = stackDbl[i];
            return d == d && d != 0.0;
        }
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        if (x == null || x == Undefined.instance) {
            return false;
        }
        if (x instanceof Number) {
            double d = ((Number)x).doubleValue();
            return d == d && d != 0.0;
        }
        return ScriptRuntime.toBoolean(x);
    }

    private static void do_add(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                int n = stackTop;
                stackDbl[n] = stackDbl[n] + rDbl;
            } else {
                Interpreter.do_add(lhs, rDbl, stack, stackDbl, stackTop, true);
            }
        } else if (lhs == DBL_MRK) {
            Interpreter.do_add(rhs, stackDbl[stackTop], stack, stackDbl, stackTop, false);
        } else {
            if (lhs instanceof Scriptable) {
                lhs = ((Scriptable)lhs).getDefaultValue(null);
            }
            if (rhs instanceof Scriptable) {
                rhs = ((Scriptable)rhs).getDefaultValue(null);
            }
            if (lhs instanceof String) {
                String lstr = (String)lhs;
                String rstr = ScriptRuntime.toString(rhs);
                stack[stackTop] = lstr.concat(rstr);
            } else if (rhs instanceof String) {
                String lstr = ScriptRuntime.toString(lhs);
                String rstr = (String)rhs;
                stack[stackTop] = lstr.concat(rstr);
            } else {
                double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
                double rDbl = rhs instanceof Number ? ((Number)rhs).doubleValue() : ScriptRuntime.toNumber(rhs);
                stack[stackTop] = DBL_MRK;
                stackDbl[stackTop] = lDbl + rDbl;
            }
        }
    }

    private static void do_add(Object lhs, double rDbl, Object[] stack, double[] stackDbl, int stackTop, boolean left_right_order) {
        if (lhs instanceof Scriptable) {
            lhs = lhs == Undefined.instance ? ScriptRuntime.NaNobj : ((Scriptable)lhs).getDefaultValue(null);
        }
        if (lhs instanceof String) {
            String lstr = (String)lhs;
            String rstr = ScriptRuntime.toString(rDbl);
            stack[stackTop] = left_right_order ? lstr.concat(rstr) : rstr.concat(lstr);
        } else {
            double lDbl = lhs instanceof Number ? ((Number)lhs).doubleValue() : ScriptRuntime.toNumber(lhs);
            stack[stackTop] = DBL_MRK;
            stackDbl[stackTop] = lDbl + rDbl;
        }
    }

    private static boolean do_eq(Object[] stack, double[] stackDbl, int stackTop) {
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        boolean result = rhs == DBL_MRK ? (lhs == DBL_MRK ? stackDbl[stackTop] == stackDbl[stackTop + 1] : Interpreter.do_eq(stackDbl[stackTop + 1], lhs)) : (lhs == DBL_MRK ? Interpreter.do_eq(stackDbl[stackTop], rhs) : ScriptRuntime.eq(lhs, rhs));
        return result;
    }

    private static boolean do_eq(double x, Object y) {
        while (true) {
            if (y instanceof Number) {
                return x == ((Number)y).doubleValue();
            }
            if (y instanceof String) {
                return x == ScriptRuntime.toNumber((String)y);
            }
            if (y instanceof Boolean) {
                return x == (double)((Boolean)y != false ? 1 : 0);
            }
            if (!(y instanceof Scriptable)) break;
            if (y == Undefined.instance) {
                return false;
            }
            y = ScriptRuntime.toPrimitive(y);
        }
        return false;
    }

    private static boolean do_sheq(Object[] stack, double[] stackDbl, int stackTop) {
        boolean result;
        Object rhs = stack[stackTop + 1];
        Object lhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            double rDbl = stackDbl[stackTop + 1];
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else if (rhs instanceof Number) {
            double rDbl = ((Number)rhs).doubleValue();
            if (lhs == DBL_MRK) {
                result = stackDbl[stackTop] == rDbl;
            } else {
                result = lhs instanceof Number;
                if (result) {
                    result = ((Number)lhs).doubleValue() == rDbl;
                }
            }
        } else {
            result = ScriptRuntime.shallowEq(lhs, rhs);
        }
        return result;
    }

    private static void do_getElem(Context cx, Object[] stack, double[] stackDbl, int stackTop, Scriptable scope) {
        Object result;
        Object id;
        Object lhs = stack[stackTop - 1];
        if (lhs == DBL_MRK) {
            lhs = Interpreter.doubleWrap(stackDbl[stackTop - 1]);
        }
        if ((id = stack[stackTop]) != DBL_MRK) {
            result = ScriptRuntime.getElem(lhs, id, scope);
        } else {
            double val = stackDbl[stackTop];
            if (lhs == null || lhs == Undefined.instance) {
                throw ScriptRuntime.undefReadError(lhs, ScriptRuntime.toString(val));
            }
            Scriptable obj = lhs instanceof Scriptable ? (Scriptable)lhs : ScriptRuntime.toObject(cx, scope, lhs);
            int index = (int)val;
            if ((double)index == val) {
                result = ScriptRuntime.getElem(obj, index);
            } else {
                String s = ScriptRuntime.toString(val);
                result = ScriptRuntime.getStrIdElem(obj, s);
            }
        }
        stack[stackTop - 1] = result;
    }

    private static void do_setElem(Context cx, Object[] stack, double[] stackDbl, int stackTop, Scriptable scope) {
        Object result;
        Object id;
        Object lhs;
        Object rhs = stack[stackTop];
        if (rhs == DBL_MRK) {
            rhs = Interpreter.doubleWrap(stackDbl[stackTop]);
        }
        if ((lhs = stack[stackTop - 2]) == DBL_MRK) {
            lhs = Interpreter.doubleWrap(stackDbl[stackTop - 2]);
        }
        if ((id = stack[stackTop - 1]) != DBL_MRK) {
            result = ScriptRuntime.setElem(lhs, id, rhs, scope);
        } else {
            double val = stackDbl[stackTop - 1];
            if (lhs == null || lhs == Undefined.instance) {
                throw ScriptRuntime.undefWriteError(lhs, ScriptRuntime.toString(val), rhs);
            }
            Scriptable obj = lhs instanceof Scriptable ? (Scriptable)lhs : ScriptRuntime.toObject(cx, scope, lhs);
            int index = (int)val;
            if ((double)index == val) {
                result = ScriptRuntime.setElem(obj, index, rhs);
            } else {
                String s = ScriptRuntime.toString(val);
                result = ScriptRuntime.setStrIdElem(obj, s, rhs, scope);
            }
        }
        stack[stackTop - 2] = result;
    }

    private static Object[] getArgsArray(Object[] stack, double[] sDbl, int shift, int count) {
        if (count == 0) {
            return ScriptRuntime.emptyArgs;
        }
        Object[] args = new Object[count];
        int i = 0;
        while (i != count) {
            Object val = stack[shift];
            if (val == DBL_MRK) {
                val = Interpreter.doubleWrap(sDbl[shift]);
            }
            args[i] = val;
            ++i;
            ++shift;
        }
        return args;
    }

    private static Object activationGet(NativeFunction f, Scriptable activation, int slot) {
        String name = f.argNames[slot];
        Object val = activation.get(name, activation);
        if (val == Scriptable.NOT_FOUND) {
            Kit.codeBug();
        }
        return val;
    }

    private static void activationPut(NativeFunction f, Scriptable activation, int slot, Object value) {
        String name = f.argNames[slot];
        activation.put(name, activation, value);
    }

    private static int getJavaCatchPC(byte[] iCode) {
        int pc = iCode.length - 1;
        if ((iCode[pc] & 0xFF) != 91) {
            Kit.codeBug();
        }
        return pc;
    }
}

