/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.document;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyVetoException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XControlShape;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.document.DatabaseControl;
import com.sun.star.wizards.document.FormHandler;
import com.sun.star.wizards.document.GridControl;

public class TimeStampControl
extends DatabaseControl {
    DatabaseControl oDateControl;
    DatabaseControl oTimeControl;
    Resource oResource;
    private String sDateAppendix;
    private String sTimeAppendix;
    XShapes xGroupShapes = null;
    double nreldatewidth;
    double nreltimewidth;
    int nTimeWidth;
    int nDBWidth;
    int nDateWidth;
    XShape xShapeGroup;

    public TimeStampControl(Resource resource, FormHandler formHandler, XNameContainer xNameContainer, String string, Point point) {
        super(formHandler, "com.sun.star.drawing.ShapeCollection", point);
        this.oResource = resource;
        this.oDateControl = new DatabaseControl(this.oFormHandler, xNameContainer, string, 91, this.aPoint);
        int n = this.oDateControl.getDBHeight();
        this.nDateWidth = this.oDateControl.getPreferredWidth();
        this.oDateControl.setSize(new Size(this.nDateWidth, n));
        Point point2 = new Point(this.aPoint.X + 10 + this.nDateWidth, this.aPoint.Y);
        this.oTimeControl = new DatabaseControl(this.oFormHandler, xNameContainer, string, 92, point2);
        this.nTimeWidth = this.oTimeControl.getPreferredWidth();
        this.oTimeControl.setSize(new Size(this.nTimeWidth, n));
        this.nDBWidth = this.nDateWidth + this.nTimeWidth + 10;
        this.xShapes.add(this.oDateControl.xShape);
        this.xShapes.add(this.oTimeControl.xShape);
        this.xShapeGroup = formHandler.xShapeGrouper.group(this.xShapes);
        this.xShapeGroup = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)this.xShapeGroup);
        this.nreldatewidth = 1.0 / ((double)this.getSize().Width / (double)this.nDateWidth);
        this.nreltimewidth = 1.0 - this.nreldatewidth;
    }

    public XPropertySet getControlofGroupShapeByIndex(int n) {
        try {
            if (n < this.xShapes.getCount()) {
                Object object = this.xShapes.getByIndex(n);
                XControlShape xControlShape = (XControlShape)UnoRuntime.queryInterface(XControlShape.class, (Object)object);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xControlShape.getControl());
                return xPropertySet;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return null;
    }

    public TimeStampControl(Resource resource, GridControl gridControl, FieldColumn fieldColumn) {
        super(gridControl, fieldColumn);
        this.oResource = resource;
        this.sDateAppendix = this.oResource.getResText(2288);
        this.sTimeAppendix = this.oResource.getResText(2289);
        this.oDateControl = new DatabaseControl(gridControl, fieldColumn, 91, fieldColumn.getFieldTitle() + " " + this.sDateAppendix);
        this.oTimeControl = new DatabaseControl(gridControl, fieldColumn, 92, fieldColumn.getFieldTitle() + " " + this.sTimeAppendix);
    }

    public void setPropertyValue(String string, Object object) throws Exception {
        this.oDateControl.setPropertyValue(string, object);
        this.oTimeControl.setPropertyValue(string, object);
    }

    public int getPreferredWidth() {
        return this.nDBWidth;
    }

    public void setSize(Size size) {
        try {
            int n = (int)(this.nreldatewidth * (double)size.Width);
            int n2 = (int)(this.nreltimewidth * (double)size.Width);
            this.oDateControl.xShape.setSize(new Size(n, size.Height));
            this.oTimeControl.xShape.setSize(new Size(n2, size.Height));
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace(System.out);
        }
    }

    public Size getSize() {
        int n = this.oDateControl.xShape.getSize().Width + this.oTimeControl.xShape.getSize().Width;
        return new Size(n, this.oDateControl.xShape.getSize().Height);
    }

    public Point getPosition() {
        return this.xShapeGroup.getPosition();
    }

    public void setPosition(Point point) {
        Point point2 = this.xShapeGroup.getPosition();
        this.xShapeGroup.setPosition(point);
        Point point3 = this.xShapeGroup.getPosition();
    }

    public int getControlType() {
        return 8;
    }
}

