/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree;

import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeArrayIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tree.ChildEnumeration;
import net.sf.saxon.tree.NodeImpl;
import net.sf.saxon.tree.TextImpl;

abstract class ParentNodeImpl
extends NodeImpl {
    private Object children = null;
    protected int sequence;

    ParentNodeImpl() {
    }

    protected final long getSequenceNumber() {
        return (long)this.sequence << 32;
    }

    public final boolean hasChildNodes() {
        return this.children != null;
    }

    protected final AxisIterator enumerateChildren(NodeTest test) {
        if (this.children == null) {
            return EmptyIterator.getInstance();
        }
        if (this.children instanceof NodeImpl) {
            NodeImpl child = (NodeImpl)this.children;
            if (test == null || test instanceof AnyNodeTest) {
                return SingleNodeIterator.makeIterator(child);
            }
            return Navigator.filteredSingleton(child, test);
        }
        if (test == null || test instanceof AnyNodeTest) {
            return new NodeArrayIterator((NodeImpl[])this.children);
        }
        return new ChildEnumeration(this, test);
    }

    public final NodeInfo getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeImpl[])this.children)[0];
    }

    public final NodeInfo getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeImpl[] n = (NodeImpl[])this.children;
        return n[n.length - 1];
    }

    protected final NodeImpl getNthChild(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this.children : null;
        }
        NodeImpl[] nodes = (NodeImpl[])this.children;
        if (n < 0 || n >= nodes.length) {
            return null;
        }
        return nodes[n];
    }

    public String getStringValue() {
        return ((Object)this.getStringValueCS()).toString();
    }

    public CharSequence getStringValueCS() {
        FastStringBuffer sb = null;
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = next.getNextInDocument(this)) {
            if (!(next instanceof TextImpl)) continue;
            if (sb == null) {
                sb = new FastStringBuffer(1024);
            }
            sb.append(next.getStringValueCS());
        }
        if (sb == null) {
            return "";
        }
        return sb.condense();
    }

    protected void useChildrenArray(NodeImpl[] array) {
        this.children = array;
    }

    public void addChild(NodeImpl node, int index) {
        NodeImpl[] c;
        if (this.children == null) {
            c = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            c = new NodeImpl[10];
            c[0] = (NodeImpl)this.children;
        } else {
            c = (NodeImpl[])this.children;
        }
        if (index >= c.length) {
            NodeImpl[] kids = new NodeImpl[c.length * 2];
            System.arraycopy(c, 0, kids, 0, c.length);
            c = kids;
        }
        c[index] = node;
        node.parent = this;
        node.index = index;
        this.children = c;
    }

    public void compact(int size) {
        if (size == 0) {
            this.children = null;
        } else if (size == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            NodeImpl[] kids = new NodeImpl[size];
            System.arraycopy(this.children, 0, kids, 0, size);
            this.children = kids;
        }
    }
}

