/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.ItemType;

public class RoleLocator
implements Serializable {
    private int kind;
    private Object container;
    private int operand;
    private NamePool namePool;
    private String errorCode = "XPTY0004";
    private SourceLocator sourceLocator;
    public static final int FUNCTION = 0;
    public static final int BINARY_EXPR = 1;
    public static final int TYPE_OP = 2;
    public static final int VARIABLE = 3;
    public static final int INSTRUCTION = 4;
    public static final int FUNCTION_RESULT = 5;
    public static final int ORDER_BY = 6;
    public static final int TEMPLATE_RESULT = 7;
    public static final int PARAM = 8;
    public static final int UNARY_EXPR = 9;

    public RoleLocator(int kind, Object container, int operand, NamePool namePool) {
        this.kind = kind;
        this.container = container;
        this.operand = operand;
        this.namePool = namePool;
    }

    public void setErrorCode(String code) {
        if (code != null) {
            this.errorCode = code;
        }
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setSourceLocator(SourceLocator locator) {
        this.sourceLocator = locator instanceof ExpressionLocation ? locator : new ExpressionLocation(locator);
    }

    public SourceLocator getSourceLocator() {
        return this.sourceLocator;
    }

    public String getMessage() {
        String name = this.container instanceof String ? (String)this.container : (this.container instanceof StructuredQName ? ((StructuredQName)this.container).getDisplayName() : (this.namePool == null ? "*unknown*" : this.namePool.getDisplayName((Integer)this.container)));
        switch (this.kind) {
            case 0: {
                return RoleLocator.ordinal(this.operand + 1) + " argument of " + name + "()";
            }
            case 1: {
                return RoleLocator.ordinal(this.operand + 1) + " operand of '" + name + '\'';
            }
            case 9: {
                return "operand of '-'";
            }
            case 2: {
                return "value in '" + name + "' expression";
            }
            case 3: {
                return "value of variable $" + name;
            }
            case 4: {
                int slash = name.indexOf(47);
                String attributeName = "";
                if (slash >= 0) {
                    attributeName = name.substring(slash + 1);
                    name = name.substring(0, slash);
                }
                return '@' + attributeName + " attribute of " + name;
            }
            case 5: {
                return "result of function " + name + "()";
            }
            case 7: {
                return "result of template " + name;
            }
            case 6: {
                return RoleLocator.ordinal(this.operand + 1) + " sort key";
            }
            case 8: {
                return "value of parameter $" + name;
            }
        }
        return "";
    }

    public String composeRequiredMessage(ItemType requiredItemType, NamePool pool) {
        return "Required item type of " + this.getMessage() + " is " + requiredItemType.toString(pool);
    }

    public String composeErrorMessage(ItemType requiredItemType, ItemType suppliedItemType, NamePool pool) {
        return "Required item type of " + this.getMessage() + " is " + requiredItemType.toString(pool) + "; supplied value has item type " + suppliedItemType.toString(pool);
    }

    private static String ordinal(int n) {
        switch (n) {
            case 1: {
                return "first";
            }
            case 2: {
                return "second";
            }
            case 3: {
                return "third";
            }
        }
        return n + "th";
    }
}

