/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import virtuoso.jdbc3.ConnectionWrapper;
import virtuoso.jdbc3.ResultSetWrapper;
import virtuoso.jdbc3.VirtuosoException;

public class DatabaseMetaDataWrapper
implements DatabaseMetaData {
    private ConnectionWrapper wconn;
    private DatabaseMetaData dbmd;

    protected DatabaseMetaDataWrapper(ConnectionWrapper connectionWrapper, DatabaseMetaData databaseMetaData) {
        this.wconn = connectionWrapper;
        this.dbmd = databaseMetaData;
    }

    private void exceptionOccurred(SQLException sQLException) {
        if (this.wconn != null) {
            this.wconn.exceptionOccurred(sQLException);
        }
    }

    public synchronized void finalize() throws Throwable {
        this.close();
    }

    protected void close() throws SQLException {
        if (this.dbmd == null) {
            return;
        }
        this.dbmd = null;
        this.wconn = null;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.allProceduresAreCallable();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean allTablesAreSelectable() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.allTablesAreSelectable();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getURL() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getURL();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getUserName() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getUserName();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.nullsAreSortedHigh();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean nullsAreSortedLow() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.nullsAreSortedLow();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.nullsAreSortedAtStart();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.nullsAreSortedAtEnd();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getDatabaseProductName() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDatabaseProductName();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDatabaseProductVersion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getDriverName() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDriverName();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getDriverVersion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDriverVersion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getDriverMajorVersion() {
        return this.dbmd.getDriverMajorVersion();
    }

    public int getDriverMinorVersion() {
        return this.dbmd.getDriverMinorVersion();
    }

    public boolean usesLocalFiles() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.usesLocalFiles();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.usesLocalFilePerTable();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.storesUpperCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.storesLowerCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.storesMixedCaseIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.storesUpperCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.storesLowerCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.storesMixedCaseQuotedIdentifiers();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getIdentifierQuoteString() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getIdentifierQuoteString();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getSQLKeywords() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getSQLKeywords();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getNumericFunctions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getNumericFunctions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getStringFunctions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getStringFunctions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getSystemFunctions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getSystemFunctions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getTimeDateFunctions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getTimeDateFunctions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getSearchStringEscape() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getSearchStringEscape();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getExtraNameCharacters() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getExtraNameCharacters();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsAlterTableWithAddColumn();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsAlterTableWithDropColumn();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsColumnAliasing() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsColumnAliasing();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.nullPlusNonNullIsNull();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsConvert() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsConvert();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsConvert(n, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsDifferentTableCorrelationNames();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsExpressionsInOrderBy();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsOrderByUnrelated();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsGroupBy() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsGroupBy();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsGroupByUnrelated();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsGroupByBeyondSelect();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsLikeEscapeClause();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsMultipleResultSets();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsMultipleTransactions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsNonNullableColumns();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsMinimumSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCoreSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsExtendedSQLGrammar();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsANSI92EntryLevelSQL();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsANSI92IntermediateSQL();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsANSI92FullSQL();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsIntegrityEnhancementFacility();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsOuterJoins() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsOuterJoins();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsFullOuterJoins();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsLimitedOuterJoins();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getSchemaTerm() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getSchemaTerm();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getProcedureTerm() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getProcedureTerm();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getCatalogTerm() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getCatalogTerm();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean isCatalogAtStart() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.isCatalogAtStart();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getCatalogSeparator() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getCatalogSeparator();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSchemasInDataManipulation();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSchemasInProcedureCalls();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSchemasInTableDefinitions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSchemasInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSchemasInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCatalogsInDataManipulation();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCatalogsInProcedureCalls();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCatalogsInTableDefinitions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCatalogsInIndexDefinitions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCatalogsInPrivilegeDefinitions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsPositionedDelete() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsPositionedDelete();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsPositionedUpdate();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSelectForUpdate();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsStoredProcedures() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsStoredProcedures();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSubqueriesInComparisons();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSubqueriesInExists();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSubqueriesInIns();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSubqueriesInQuantifieds();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsCorrelatedSubqueries();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsUnion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsUnion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsUnionAll() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsUnionAll();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsOpenCursorsAcrossCommit();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsOpenCursorsAcrossRollback();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsOpenStatementsAcrossCommit();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsOpenStatementsAcrossRollback();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxBinaryLiteralLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxCharLiteralLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxCharLiteralLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxColumnNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxColumnNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxColumnsInGroupBy();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxColumnsInIndex() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxColumnsInIndex();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxColumnsInOrderBy();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxColumnsInSelect() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxColumnsInSelect();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxColumnsInTable();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxConnections() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxConnections();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxCursorNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxCursorNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxIndexLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxIndexLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxSchemaNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxSchemaNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxProcedureNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxProcedureNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxCatalogNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxCatalogNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxRowSize() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxRowSize();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.doesMaxRowSizeIncludeBlobs();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxStatementLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxStatementLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxStatements() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxStatements();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxTableNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxTableNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxTablesInSelect() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxTablesInSelect();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getMaxUserNameLength() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getMaxUserNameLength();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDefaultTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsTransactions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsTransactions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsTransactionIsolationLevel(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsTransactionIsolationLevel(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsDataDefinitionAndDataManipulationTransactions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsDataManipulationTransactionsOnly();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.dataDefinitionCausesTransactionCommit();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.dataDefinitionIgnoredInTransactions();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getProcedures(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getProcedures(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getProcedureColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getProcedureColumns(string, string2, string3, string4);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getTables(String string, String string2, String string3, String[] stringArray) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getTables(string, string2, string3, stringArray);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getSchemas() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getSchemas();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getCatalogs() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getCatalogs();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getTableTypes() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getTableTypes();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getColumns(String string, String string2, String string3, String string4) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getColumns(string, string2, string3, string4);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getColumnPrivileges(String string, String string2, String string3, String string4) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getColumnPrivileges(string, string2, string3, string4);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getTablePrivileges(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getTablePrivileges(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getBestRowIdentifier(String string, String string2, String string3, int n, boolean bl) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getBestRowIdentifier(string, string2, string3, n, bl);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getVersionColumns(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getVersionColumns(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getPrimaryKeys(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getPrimaryKeys(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getImportedKeys(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getImportedKeys(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getExportedKeys(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getExportedKeys(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getCrossReference(String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getCrossReference(string, string2, string3, string4, string5, string6);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getTypeInfo() throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getTypeInfo();
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getIndexInfo(String string, String string2, String string3, boolean bl, boolean bl2) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getIndexInfo(string, string2, string3, bl, bl2);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsResultSetType(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsResultSetType(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsResultSetConcurrency(int n, int n2) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsResultSetConcurrency(n, n2);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean ownUpdatesAreVisible(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.ownUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean ownDeletesAreVisible(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.ownDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean ownInsertsAreVisible(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.ownInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean othersUpdatesAreVisible(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.othersUpdatesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean othersDeletesAreVisible(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.othersDeletesAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean othersInsertsAreVisible(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.othersInsertsAreVisible(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean updatesAreDetected(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.updatesAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean deletesAreDetected(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.deletesAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean insertsAreDetected(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.insertsAreDetected(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsBatchUpdates() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsBatchUpdates();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getUDTs(String string, String string2, String string3, int[] nArray) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getUDTs(string, string2, string3, nArray);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public Connection getConnection() throws SQLException {
        this.check_close();
        return this.wconn;
    }

    public boolean supportsSavepoints() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsSavepoints();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsNamedParameters() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsNamedParameters();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsMultipleOpenResults();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsGetGeneratedKeys();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getSuperTypes(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getSuperTypes(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getSuperTables(String string, String string2, String string3) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getSuperTables(string, string2, string3);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public ResultSet getAttributes(String string, String string2, String string3, String string4) throws SQLException {
        this.check_close();
        try {
            ResultSet resultSet = this.dbmd.getAttributes(string, string2, string3, string4);
            if (resultSet != null) {
                return new ResultSetWrapper(this.wconn, resultSet);
            }
            return null;
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsResultSetHoldability(int n) throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsResultSetHoldability(n);
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getResultSetHoldability() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getResultSetHoldability();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getDatabaseMajorVersion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDatabaseMajorVersion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getDatabaseMinorVersion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getDatabaseMinorVersion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getJDBCMajorVersion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getJDBCMajorVersion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getJDBCMinorVersion() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getJDBCMinorVersion();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public int getSQLStateType() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.getSQLStateType();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.locatorsUpdateCopy();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public boolean supportsStatementPooling() throws SQLException {
        this.check_close();
        try {
            return this.dbmd.supportsStatementPooling();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    private void check_close() throws SQLException {
        if (this.dbmd == null) {
            throw new VirtuosoException("The connection is closed.", 0);
        }
    }
}

