/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by Tobias Hunger <tobias.hunger@basyskom.de>
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QTTELEPATHY_CONNECTIONCAPABILITIESINTERFACETYPES_H
#define QTTELEPATHY_CONNECTIONCAPABILITIESINTERFACETYPES_H

#include <QtCore/QHash>
#include <QtCore/QString>
#include <QtCore/QList>
#include <QtDBus/QDBusArgument>
#include <QtTelepathy/Common/BaseTypes>

namespace org {
namespace freedesktop {
namespace Telepathy {

enum CapabilityFlag {
    CONNECTION_CAPABILITY_FLAG_NONE   = 0x00000000,
    CONNECTION_CAPABILITY_FLAG_CREATE = 0x00000001,
    CONNECTION_CAPABILITY_FLAG_INVITE = 0x00000002,
    CONNECTION_CAPABILITY_FLAG_ALL    = 0xFFFFFFFF
};
Q_DECLARE_FLAGS(CapabilityFlags, CapabilityFlag)

class LocalCapabilityInfo
{
public:
    QString channelType;
    quint32 typeSpecificFlags;
};
typedef QList<LocalCapabilityInfo> LocalCapabilityInfoList;

class CapabilityInfo
{
public:
    uint contactHandle;
    QString channelType;
    quint32 genericFlags;
    quint32 typeSpecificFlags;
};
typedef QList<CapabilityInfo> CapabilityInfoList;

class CapabilitiesChangedInfo
{
public:
    uint contactHandle;
    QString channelType;
    quint32 oldGenericFlags;
    quint32 newGenericFlags;
    quint32 oldTypeSpecificFlags;
    quint32 newTypeSpecificFlags;
};
typedef QList<CapabilitiesChangedInfo> CapabilitiesChangedInfoList;

} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::LocalCapabilityInfo)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::LocalCapabilityInfoList)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::CapabilityInfo)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::CapabilityInfoList)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::CapabilitiesChangedInfo)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::CapabilitiesChangedInfoList)

Q_DECLARE_OPERATORS_FOR_FLAGS(org::freedesktop::Telepathy::CapabilityFlags)

const QDBusArgument &operator>>(const QDBusArgument &, org::freedesktop::Telepathy::LocalCapabilityInfo &);
QDBusArgument &operator<<(QDBusArgument &, const org::freedesktop::Telepathy::LocalCapabilityInfo &);

const QDBusArgument &operator>>(const QDBusArgument &, org::freedesktop::Telepathy::CapabilityInfo &);
QDBusArgument &operator<<(QDBusArgument &, const org::freedesktop::Telepathy::CapabilityInfo &);

const QDBusArgument &operator>>(const QDBusArgument &, org::freedesktop::Telepathy::CapabilitiesChangedInfo &);
QDBusArgument &operator<<(QDBusArgument &, const org::freedesktop::Telepathy::CapabilitiesChangedInfo &);

#endif
