/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.collections;

import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedSizeQueue<E>
extends LinkedList<E> {
    private static final long serialVersionUID = 1L;
    private int m_maxSize = Integer.MAX_VALUE;

    public FixedSizeQueue(int maxSize) {
        this.m_maxSize = maxSize;
    }

    public FixedSizeQueue(int maxSize, Collection<? extends E> c) {
        super(c);
        this.setMaxSize(maxSize);
    }

    public void setMaxSize(int maxSize) {
        this.m_maxSize = maxSize;
        this.enforceMaxSize();
    }

    public int getMaxSize() {
        return this.m_maxSize;
    }

    private void enforceMaxSize() {
        if (this.size() > this.getMaxSize()) {
            this.removeRange(0, this.size() - this.m_maxSize);
        }
    }

    @Override
    public boolean add(E o) {
        boolean result = super.add(o);
        this.enforceMaxSize();
        return result;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        this.enforceMaxSize();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean result = super.addAll(c);
        this.enforceMaxSize();
        return result;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean result = super.addAll(index, c);
        this.enforceMaxSize();
        return result;
    }

    @Override
    public void addFirst(E o) {
        super.addFirst(o);
        this.enforceMaxSize();
    }

    @Override
    public void addLast(E o) {
        super.addLast(o);
        this.enforceMaxSize();
    }
}

