/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_DBUSNAMES_H_
#define _DECIBEL_DBUSNAMES_H_

namespace Decibel {

const QString organisation_name("de.basyskom");
const QString system_name("Decibel");
const QString daemon_name("Daemon");
const QString log_name("Log");

/** D-Bus names used by Decibel: */
const QString decibel_service_namespace(organisation_name + '.' +
                                        system_name);

const QString daemon_service(decibel_service_namespace + '.' + daemon_name);
const QString daemon_accountmanager_path("/AccountManager");
const QString daemon_componentmanager_path("/ComponentManager");
const QString daemon_contactmanager_path("/ContactManager");
const QString daemon_protocolmanager_path("/ProtocolManager");

const QString log_service(decibel_service_namespace + '.' + log_name);
const QString log_path("/Log");

const QString channelhandler_path("/ChannelHandler");

} // namespace

#endif
