# prime-config.rb: Setting of global variables and default variables for PRIME.
# $Id: prime-config.rb.in,v 1.5 2005/03/07 07:51:32 komatsu Exp $
#
# Copyright (C) 2003 Hiroyuki Komatsu <komatsu@taiyaki.org>
#     All rights reserved.
#     This is free software with ABSOLUTELY NO WARRANTY.
#
# You can redistribute it and/or modify it under the terms of 
# the GNU General Public License version 2.

require 'etc'
home = Etc.getpwuid['dir']
# home = ENV['HOME']

PRIME_USER_DIR    = ENV['PRIME_USER_DIR']    || home + '/.prime'
PRIME_DATA_DIR    = ENV['PRIME_DATA_DIR']    || '/usr/share/prime'
PRIME_GRAMMAR_DIR = ENV['PRIME_GRAMMAR_DIR'] || '/usr/share/prime/grammar'
PRIME_CONFIG_DIR  = ENV['PRIME_CONFIG_DIR']  || '/etc/prime'
PRIME_DOC_DIR     = ENV['PRIME_DOC_DIR']     || '/usr/share/doc/prime'

PRIME_COMMAND                  = 'prime'
PRIME_COMMAND_REFRESH          = 'prime-refresh'
PRIME_COMMAND_USERDICT_CONVERT = 'prime-userdict-convert'
PRIME_COMMAND_USERDICT_UPDATE  = 'prime-userdict-update'
PRIME_COMMAND_DICT_CONVERT     = 'prime-dict-convert'
PRIME_COMMAND_DICT_INDEX       = 'prime-dict-index'

#### Default settings
PRIME_ENV = {}

## Enginges: kana-kanji conversion engines.
PRIME_ENV['engines'] = [
  :PrimeEngineBasic,
  :PrimeEngineUserdict2,
  :PrimeEnginePersonalDict,
  :PrimeEngineAlphabet,
  :PrimeEngineNumber,
]

## Suikyo: romaji-kana conversion library.
PRIME_TYPING_METHOD_DEFAULT         = 'romaji'
PRIME_ENV['typing_method']          = PRIME_TYPING_METHOD_DEFAULT

## If true, PRIME considers the validation of the preedition.
## ex). "pl" => "apple".  The available values are [nil, true, false].
PRIME_ENV['hybrid_typing']          = nil

#PRIME_ENV['suikyo_tables']         = ["romaji"]
#PRIME_ENV['suikyo_reverse_tables'] = ["romaji_reverse"]
PRIME_ENV['suikyo_use_cache']      = true

PRIME_ENV['style_auto_space']         = false
PRIME_ENV['style_mask_pending_chars'] = false
PRIME_ENV['style_japanese_period']    = ''
PRIME_ENV['style_japanese_comma']     = ''

PRIME_ENV['char_encoding'] = 'EUC-JP'

PRIME_TYPING_TABLE = {'romaji' => ['romaji', 'egg-mark'],
                      'kana'   => ['kana'],
                      'tcode'  => ['tcode']}
PRIME_TYPING_REVERSE_TABLE = {'romaji' => ['romaji_reverse',
                                           'egg-mark_reverse'],
                              'kana'   => ['kana_reverse'],
                              'tcode'  => ['tcode_reverse']}

# --- Text properties for Emacs. ---
# Local variables:
# mode: ruby
# End:
