/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.message.Attachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;

public final class DataHandlerAttachment
implements Attachment {
    private final DataHandler dh;
    private final String contentId;

    public DataHandlerAttachment(@NotNull String string, @NotNull DataHandler dataHandler) {
        this.dh = dataHandler;
        this.contentId = string;
    }

    public String getContentId() {
        return this.contentId;
    }

    public String getContentType() {
        return this.dh.getContentType();
    }

    public byte[] asByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.dh.writeTo(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public DataHandler asDataHandler() {
        return this.dh;
    }

    public Source asSource() {
        try {
            return new StreamSource(this.dh.getInputStream());
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public InputStream asInputStream() {
        try {
            return this.dh.getInputStream();
        }
        catch (IOException iOException) {
            throw new WebServiceException(iOException);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.dh.writeTo(outputStream);
    }

    public void writeTo(SOAPMessage sOAPMessage) throws SOAPException {
        AttachmentPart attachmentPart = sOAPMessage.createAttachmentPart();
        attachmentPart.setDataHandler(this.dh);
        attachmentPart.setContentId(this.contentId);
        sOAPMessage.addAttachmentPart(attachmentPart);
    }
}

