#!/bin/bash
# wxWidgets	(http://www.wxwidgets.org)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-06-24
# require:
#	X11R7
#	GTK2
#
WX_VER=2.8.8
SRC_URI=ftp://biolpc22.york.ac.uk/pub/${WX_VER}/wxWidgets-${WX_VER}.tar.gz 
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/develop
PAC_DIR=$PLAMO/Packages/4.5/Develop
BUILD_DIR=$PLAMO/wxwidgets
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
export PKG_CONFIG_PATH=/usr/lib/pkgconfig:/usr/X11R7/lib/pkgconfig
export CFLAGS="-I/usr/X11R7/include $CFLAGS" \
	LDFLAGS=-L/usr/X11R7/lib
export CPPFLAGS=$CFLAGS
./configure --enable-monolithic --enable-unicode --with-gtk --prefix=/usr
make
make install DESTDIR=$WORK/

# install documents
DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mkdir -p $DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
      BuildCVS.txt \
      docs/*.txt     \
      docs/index.htm  \
  $DOC_DIR/
cp -a  docs/{html,gtk,motif,msw}/ \
  $DOC_DIR/
tar cf - -C contrib/src */README* */*.txt | tar xvf - -C $DOC_DIR/
chown -R root.root $DOC_DIR/
chmod -R a+rX,go-w $DOC_DIR/


# Contrib Libraries
# Install wxWidgets STC (Styled Text Control), OGL, and so on.
#
cd contrib/
make all
make install DESTDIR=$WORK/


cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
