/* -*- Mode: C ; Coding: euc-japan -*- */
/* Time-stamp: <2010-02-17 22:02:37 cyamauch> */

/*
 ʱߤž륵ץ륳

 Իؤΰ˭ͤWebڡ:
   http://ylb.jp/Cguide/_eggx_samples.html
 餤ΤԽޤ
*/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <eggx.h>

#define AREA_WIDTH 400
#define AREA_HEIGHT 400 

/*
 * eclipse
 * ɸ (x, y) 濴ˡ w, ⤵ h ʱߤ angle ʥ饸ñ̡
 * ž
 * ʱߤĺ¿¿ѷȤ fillpoly ؿѤ
 */
#define ECLIPSEPOINTS 90 // 90 ѷȤ
void eclipse(int win, float x, float y, float w, float h, float angle)
{
  float ptx[ECLIPSEPOINTS], pty[ECLIPSEPOINTS]; // ĺɸ
  float th; // ʱߤγĺ֤ݤγ
  float xx, yy; // βžʤʱߤγĺ
  int i;

  /* ĺκɸ֤ */
  for(i=0; i<ECLIPSEPOINTS; i++) {
    th = 2*M_PI * ((float)i/ECLIPSEPOINTS);
    xx=cos(th)*w;
    yy=sin(th)*h;
    ptx[i] = x + xx * cos(angle) - yy * sin(angle);
    pty[i] = y + xx * sin(angle) + yy * cos(angle);
  }
  /*  */
  fillpoly(win, ptx, pty, ECLIPSEPOINTS, 0);
}
#undef ECLIPSEPOINTS

/*
 * rotateX , rotateY
 * ɸ (posX, posY) (orgX, orgY) 濴 angle ٤ž
 * ɸ֤ X, Y ʬ
 */
float rotateX(float orgX, float orgY, float posX, float posY, float angle)
{
  float x, y; // (orgX, orgY) Ȥ (posX, posY) ɸ 
  float rotX; // (x, y)  angle ٲžɸ֡ʤ X ʬ
  x = posX - orgX;
  y = posY - orgY;
  rotX = x * cos(angle) - y * sin(angle);
  return rotX + orgX; // ͤˤ orgX ͤäƤ
}

float rotateY(float orgX, float orgY, float posX, float posY, float angle)
{
  float x, y; // (orgX, orgY) Ȥ (posX, posY) ɸ 
  float rotY; // (x, y)  angle ٲžɸ֡ʤ Y ʬ
  x = posX - orgX;
  y = posY - orgY;
  rotY = x * sin(angle) + y * cos(angle);
  return rotY + orgY; // ͤˤ orgX ͤäƤ
}

/*
 * main
 */
int main()
{
  int win;
  float theta;

  win = gopen(AREA_WIDTH*2, AREA_WIDTH*2);  
  winname(win, "rotation");

  /* 쥤򤹤 */
  layer(win, 0,1);
  /* Υ֥å⡼ɤˤ */
  gsetnonblock(ENABLE);

  theta = 0.0;

  while (1) {

    gclr(win);

    /*
     * ꥢ1: ɤ٤줿ʱߤ
     */
    coordinate(win, 0,0, 0,0, 1.0,1.0);
    // ɸ
    newpen(win, 9); 
    newlinestyle(win, LineOnOffDash);
    drawline(win, 0.0, AREA_HEIGHT/2, AREA_WIDTH, AREA_HEIGHT/2); 
    drawline(win, AREA_WIDTH/2, 0.0, AREA_WIDTH/2, AREA_HEIGHT); 
    newlinestyle(win, LineSolid);

    newpen(win, 2);  // ֿ
    eclipse(win, 200.0, 100.0, 100.0, 50.0, 0.0);     // žʤ
    newpen(win, 3);  // п
    eclipse(win, 200.0, 200.0, 100.0, 50.0, theta);   // ž

    /*
     * ꥢ2: ʱߤ
     */
    coordinate(win, AREA_WIDTH,0, 0,0, 1.0,1.0);

#define POLYNUM 90 // 90 ѷȤ
    {
      float posx[POLYNUM], posy[POLYNUM]; // ĺֺɸ
      float newx[POLYNUM], newy[POLYNUM]; // žκɸ
      float th;
      int i;
      // ɸ
      newpen(win, 1); 
      newlinestyle(win, LineOnOffDash);
      drawline(win, 0.0, AREA_HEIGHT/2, AREA_WIDTH, AREA_HEIGHT/2); 
      drawline(win, AREA_WIDTH/2, 0.0, AREA_WIDTH/2, AREA_HEIGHT); 
      newlinestyle(win, LineSolid);

      // ΰ֤׻ʿʱߤ

      // 
      newpen(win, 2);  // ֿ
      for(i=0; i<POLYNUM; i++) {
	th = 2*M_PI * ((float)i/POLYNUM);
	posx[i] = 250.0 + cos(th)*100.0;
	posy[i] = 150.0 + sin(th)*50.0;
      }
      drawpoly(win, posx, posy, POLYNUM);

      // žΰ֤
      newpen(win, 3);  // п
      for(i=0; i<POLYNUM; i++) {
	/* (200,200) 濴ˡ(x,y) ž֤׻*/
	newx[i] = rotateX(200.0, 200.0, posx[i], posy[i], theta); // ž
	newy[i] = rotateY(200.0, 200.0, posx[i], posy[i], theta);
      }
      drawpoly(win, newx, newy, POLYNUM);
    }
#undef POLYNUM

    /*
     * ꥢ3: Ĺ
     */
    coordinate(win, 0,AREA_HEIGHT, 0,0, 1.0,1.0);

    {
      float posx[4], posy[4]; // ͳѷĺֺɸ
      float newx[4], newy[4]; // žκɸ
      int i;
      // ɸ
      newpen(win, 1); 
      newlinestyle(win, LineOnOffDash);
      drawline(win, 0.0, AREA_HEIGHT/2, AREA_WIDTH, AREA_HEIGHT/2); 
      drawline(win, AREA_WIDTH/2, 0.0, AREA_WIDTH/2, AREA_HEIGHT); 
      newlinestyle(win, LineSolid);

      // ŬĹγĺɸ֤˳Ǽ
      posx[0]=150.0;    posy[0]=100.0;
      posx[1]=320.0;    posy[1]=100.0;
      posx[2]=320.0;    posy[2]=140.0;
      posx[3]=150.0;    posy[3]=140.0;  

      newpen(win, 2);  // ֿ
      fillpoly(win, posx, posy, 4, 0); // Ĺ

      /* (200,200) 濴ˡĺˤĤƲž֤׻ */
      /* ̤˳Ǽ                                             */
      for(i=0; i<4; i++) {
	newx[i] = rotateX(200.0, 200.0, posx[i], posy[i], theta); // ž
	newy[i] = rotateY(200.0, 200.0, posx[i], posy[i], theta);
      }
      newpen(win, 3);  // п
      fillpoly(win, newx, newy, 4, 0); // žĹ
    }

    /*
     * ꥢ4: 
     */
    coordinate(win, AREA_WIDTH,AREA_HEIGHT, 0,0, 1.0,1.0);

#define POLYNUM 12 // ¿ѷγѤο
#define LENGTH 150.0
    {
      float posx[POLYNUM], posy[POLYNUM]; // ĺֺɸ
      float newx[POLYNUM], newy[POLYNUM]; // žκɸ
      float th, l; // ѿ
      float x,y;
      int i;
      x=200.0;
      y=200.0;

      /* ĺɸ֤˳Ǽ */
      for(i=0;i<POLYNUM;i++) {
	th=2.0*M_PI/(float)POLYNUM*(float)i;
	if(i%2==0) { // ĺֹ椬λϳ
	  l=LENGTH;
	} else { // λ
	  l=LENGTH * 0.4; 
	}
	posx[i]=cos(th)*l + x;
	posy[i]=sin(th)*l + y;
      }

      newpen(win, 1);  // 򿧤

      for(i=0;i<POLYNUM;i++) { // ĺȤ th žɸ֤
	newx[i]=rotateX(x, y, posx[i], posy[i], theta);
	newy[i]=rotateY(x, y, posx[i], posy[i], theta);
      }
      fillpoly(win, newx, newy, POLYNUM, 0); // ¿ѷ
    }
#undef LENGTH
#undef POLYNUM

    theta += M_PI/90.0; // žʤ
    if ( M_PI * 2 < theta ) theta -= M_PI * 2;

    copylayer(win,1,0);
    msleep(20);

    if ( 0 < ggetch() ) break; // 򲡤Ƚλ

  }	/* while (1) */

  gclose(win); 

  return 0;
}
