/*
ͥ륮򴹤¿γҷϤǤϡ®ʬۤMaxWell-BoltzmannʬۤˤʤȤ
ϳؤδܸδ륷ߥ졼
ʬۤȯNĤʬҤΰ͹Ԥ®ʬۤɽ
 */

#include <stdlib.h>
#include <sys/times.h>
#include <math.h>
#include "eggx.h"
#include "e_ctrls.h"

#define N     20000

#define Dmax  50
#define L     400
#define A     5

double Ndisp = 500.0;
int Collision = 40;
double dT = 3.0;

typedef struct vec3d {
    double x;
    double y;
    double z;
} Vec3d;

Vec3d pos[N], v[N];
int   vdist[Dmax];

void getstatis()
{
  int i, j;
  double vi;

  for (i=0; i< Dmax; i++) vdist[i]=0;
  for (i=0; i< N; i++){
    vi = sqrt(pow(v[i].x,2)+pow(v[i].y,2)+pow(v[i].z,2));
    j = (int)(floor(Dmax*vi*20));
    if (j >= Dmax) continue;
    vdist[j]++;
  }
}

void step(void)
{
  int i, j, k;
  double vr, vmx, vmy, vmz, cost, sint, phi, vrax, vray, vraz;

  for (i=0; i< N ; i++) {
    pos[i].x += v[i].x*dT;
    pos[i].y += v[i].y*dT;
    pos[i].z += v[i].z*dT;
    if (pos[i].x>+A && v[i].x>0) v[i].x=-fabs(v[i].x);
    if (pos[i].x<-A && v[i].x<0) v[i].x=+fabs(v[i].x);
    if (pos[i].y>+A && v[i].y>0) v[i].y=-fabs(v[i].y);
    if (pos[i].y<-A && v[i].y<0) v[i].y=+fabs(v[i].y);
    if (pos[i].z>+A && v[i].z>0) v[i].z=-fabs(v[i].z);
    if (pos[i].z<-A && v[i].z<0) v[i].z=+fabs(v[i].z);
  }

  // εФȥͥ륮
  for (i = 0; i < Collision; i++){
    k = j =(int)(N*drand48());
    while ( k == j ){
      k = (int)(N*drand48());
    };
    vmx = (v[j].x + v[k].x)/2.0;
    vmy = (v[j].y + v[k].y)/2.0;
    vmz = (v[j].z + v[k].z)/2.0;
    vr = sqrt( pow((v[j].x - v[k].x),2)
              + pow((v[j].y - v[k].y),2)
	       + pow((v[j].z - v[k].z),2) );
    phi = 2*M_PI*drand48();
    cost = 2.0*drand48()-1.0;
    sint = sqrt(1-cost*cost);
    vrax = vr*sint*cos(phi);
    vray = vr*sint*sin(phi);
    vraz = vr*cost;
    v[j].x = vmx + vrax/2.0;
    v[j].y = vmz + vray/2.0;
    v[j].z = vmz + vraz/2.0;
    v[k].x = vmx - vrax/2.0;
    v[k].y = vmz - vray/2.0;
    v[k].z = vmz - vraz/2.0;
  }
 
  // ʬۤμ
  getstatis();
}

void init()
{
  int i;

  srand48(times(NULL));
  for (i=0; i < N; i++){
    v[i].x = 
    v[i].y = 
    v[i].z = 4e-2*(drand48()-0.5);
  }
  for (i=0; i < N; i++){
    pos[i].x = (2*A)*(drand48()-0.5);
    pos[i].y = (2*A)*(drand48()-0.5);
    pos[i].z = (2*A)*(drand48()-0.5);
  }
  getstatis();
}  

int win, plwin, cwin, iscwin;
int type, button;
double run = 1, reset = 0, quit = 0;
double sc = L/(2*A), psc = L/Dmax, vdistmax;

void draw()
{
  int i;
  gclr(win);
  gclr(plwin);

  newcolor(win, "cyan4"); 
  for (i=0; i < Ndisp; i++) {
    fillarc(win, sc*(pos[i].x)-2, sc*(pos[i].y)-2, 4, 4, 0, 360, 0);
  }
  newcolor(win, "#006666");
  for (i=0; i < Ndisp; i++) {
    drawarc(win, sc*(pos[i].x)-2, sc*(pos[i].y)-2, 4, 4, 0, 360, 0);
  }
  newcolor(plwin, "#006600");
  vdistmax = vdist[0];
  for (i = 0; i < Dmax; i++) { 
    if (vdistmax < vdist[i]) vdistmax = vdist[i]; 
  }
  for (i = 0; i < Dmax; i++) {
    fillrect(plwin, psc*i, 0, psc, vdist[i]/vdistmax*L/2);
  }
  newcolor(plwin, "#003300");
  for (i = 0; i < Dmax; i++) {
    drawrect(plwin, psc*i, 0, psc, vdist[i]/vdistmax*L/2);
  }
  copylayer(plwin, 1, 0);
  copylayer(win, 1, 0);
}

int main(int argc, char *argv[])
{
  float wx = -1, wy = -100;

  _CTRL ctrls[] = {
    {"dt", &dT, 0.1},
    {"Number disp.", &Ndisp, 100},
    {"_Run", &run},
    {"_Reset", &reset},
    {"_Quit", &quit}
  };
  init_ctrls(&cwin,5);

  win = gopen(L, L);
  plwin = gopen(L, L/2);
  window(win, -L/2, -L/2, L/2, L/2);
  window(plwin, 0, 0, L, 1.1*L/2);
  init();
  layer(win, 0, 1);
  layer(plwin, 0, 1);
  gsetbgcolor(win, "#000033");
  gsetbgcolor(plwin, "white");
  gsetnonblock(ENABLE);

  while (!quit){
    iscwin = ggetxpress(&type, &button, &wx, &wy);
    display_ctrls(cwin, ctrls, 5, wx, wy, iscwin, type, button);
    if (run) {
      step();
      draw();
    }
    if (reset) { run = 0; init(); draw(); reset = 0;}
    msleep(20);
    copylayer(cwin, 1, 0);
  }
  gcloseall();
  return 0;
}
