;;; egg-canna.el --- Canna Conversion Facility in Egg Input
;;;                     Method Architecture

;; Copyright (C) 2000 Free Software Foundation, Inc

;; Author: ITOH Kinji <kinji-i@gray.plala.or.jp>

;; Keywords: mule, multilingual, input method, canna

;; This file is not part of EGG.

;; egg-canna.el is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; egg-canna.el is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:


;;; Code:


(require 'egg-sim)

;;; canna-touroku
(defun canna-touroku ()
  "Register a word into a kana-to-kanji dictionary."
  (interactive)
  (condition-case err
      (egg-toroku-string (read-multilingual-string "$BC18l(B?: "))
    (error (message "$BEPO?$G$-$^$;$s$G$7$?(B"))))

(defun canna-delete-word ()
  "Delete a word into a kana-to-kanji dictionary."
  (interactive)
  (let* ((ret
	  (condition-case err
	      (canna-word-delete-regist 'canna-backend-Japanese
					(read-multilingual-string "$BFI$_(B?: "))
	    (error  nil)))
	 kanji yomi hinshi dic)
    (if ret
	(progn
	  (setq kanji  (nth 0 ret)
		yomi   (nth 1 ret)
		hinshi (nth 2 ret)
		dic    (nth 3 ret))
	  (message (concat "$B<-=q9`L\!X(B" kanji "$B!Y(B(" yomi ": " hinshi ")$B$r(B " dic
			   " $B$+$i:o=|$7$^$7$?(B")))
      (message "$B:o=|$G$-$^$;$s$G$7$?(B"))))

(fset 'canna-touroku-region 'egg-toroku-region)

;;;  canna-get-hinshi-info
(defun canna-get-hinshi-info ()
  (interactive)
  (let* ((b (car (egg-get-major-bunsetsu (point))))
	 (env (canna-bunsetsu-get-env b))
	 (bp (canna-bunsetsu-get-bunsetsu-pos b))
	 (zpos (canna-bunsetsu-get-zenkouho-pos b))
	 res)
    (setq res (cannarpc-get-hinshi env bp (or zpos 0)))
    (message res)))

(define-key egg-conversion-map "\C-y" 'canna-get-hinshi-info)

;;; canna-kigou-mode
(defvar canna-sim-kigou-menu
  `(menu "$B5-9f(B:" , (make-char-list 'japanese-jisx0208 1 2)))
(defvar canna-sim-kigou-menu nil)

(defun canna-kigou-mode ()
  "Enter symbol choosing mode."
  (interactive "*")
  (let* ((ret (menudiag-select canna-sim-kigou-menu)))
    (insert ret)))

;;; canna-bushu-mode
(defvar canna-sim-bushu-menu
  `(menu "$BIt<s(B:"
	 (("$B0l(B" . "$B$$$A(B") ("$BP((B" . "$B$N(B") ("$BQa(B" . "$B$&$1$P$3(B") ("$B==(B" . "$B$8$e$&(B")
	  ("$BRG(B" . "$B$U$7(B") ("$BEa(B" . "$B$+$?$J(B") ("$B4"!J$j$C$H$&!K(B" . "$B$j$C$H$&(B")
	  ("$BNO(B" . "$B$+(B") ("$BRL(B" . "$B$,$s(B") ("$BR1(B" . "$B$/(B") ("$BQDR9Sx(B" . "$B$+$^$((B")
	  ("$BP5(B" . "$B$J$Y(B") ("$BQR(B" . "$B$K(B") ("$B?M!??N!J$K$s$Y$s!K(B" . "$B$R$H(B")
	  ("$BKt(B" . "$B$L(B") ("$BQ\(B" . "$B$D$/$((B") ("$BH,(B" . "$B$O$A(B") ("$BQ9(B" . "$B$k(B")
	  ("$BQL(B" . "$B$o(B") ("$BU_(B" . "$B$&(B") ("$BW.(B" . "$B$($s(B")
	  ("$B0j!J$*$*$6$H(B)" . "$B$*$*$6$H(B") ("$B8J(B" . "$B$*$N$l(B") ("$B=w(B" . "$B$*$s$J(B")
	  ("$BWF(B" . "$B$.$g$&(B") ("$B8}(B" . "$B$m(B") ("$BAp!J$/$5$+$s$`$j(B)" . "$B$/$5(B")
	  ("$BFH!J$1$b$N$X$s!K(B" . "$B$1$b$N(B") ("$B;R(B" . "$B$3(B")
	  ("$Boz!J$3$6$H!K(B" . "$B$3$6$H(B") ("$B;N(B" . "$B$5$`$i$$(B")
	  ("$B9>!J$5$s$:$$!K(B" . "$B$7(B") ("$BW5(B" . "$B$7$-(B") ("$BUy(B" . "$B$7$c$/(B")
	  ("$B>.!?C1!J$D!K(B" . "$B$D(B") ("$Bmh!J$7$s$K$g$&!K(B" . "$B$7$s(B") ("$B@#(B" . "$B$9$s(B")
	  ("$BBg(B" . "$B$@$$(B") ("$BEZ(B" . "$B$I(B") ("$B<j!J$F$X$s!K(B" . "$B$F(B") ("$B6R(B" . "$B$O$P(B")
	  ("$BVx(B" . "$B$^(B") ("$B;3(B" . "$B$d$^(B") ("$BM<(B" . "$B$f$&(B") ("$B5](B" . "$B$f$_(B")
	  ("$BK;!J$j$C$7$s$Y$s!K(B" . "$B$j$C$7$s(B") ("$B7g(B" . "$B$1$D(B") ("$B]F(B" . "$B$$$A$?(B")
	  ("$B8$(B" . "$B$$$L(B") ("$B5m!?24!J$&$7$X$s!K(B" . "$B$&$7(B") ("$BJR(B" . "$B$+$?(B")
	  ("$BLZ(B" . "$B$-(B") ("$B]c(B" . "$B$-$,$^$((B") ("$BLS(B" . "$B$1(B") ("$B?4(B" . "$B$3$3$m(B")
	  ("$B?e(B" . "$B$9$$(B") ("$B7n(B" . "$B$D$-(B") ("$BD^(B" . "$B$D$a(B") ("$BF|(B" . "$B$K$A(B")
	  ("$BZ>(B" . "$B$N$V$s(B") ("$B2P(B" . "$B$R(B") ("$BJ}(B" . "$B$[$&(B") ("$BXy(B" . "$B$[$3(B")
	  ("$BE@!J$l$C$+!K(B" . "$B$h$D$F$s(B") ("$B]U(B" . "$B$k$^$?(B") ("$B7j(B" . "$B$"$J(B")
	  ("$B@P(B" . "$B$$$7(B") ("$B6L(B" . "$B$*$&(B") ("$BHi(B" . "$B$+$o(B") ("$B4$(B" . "$B$+$o$i(B")
	  ("$B;.(B" . "$B$5$i(B") ("$B<((B" . "$B$7$a$9(B") ("$B?@!J$7$a$9$X$s!K(B" . "$B$M(B")
	  ("$BGr(B" . "$B$7$m(B") ("$BED(B" . "$B$?(B") ("$BN)(B" . "$B$?$D(B") ("$B2S(B" . "$B$N$.(B")
	  ("$BL\(B" . "$B$a(B") ("$Bb"(B" . "$B$O$D(B") ("$BLp(B" . "$B$d(B")
	  ("$BaK!J$d$^$$$@$l!K(B" . "$B$d$^$$(B") ("$B;M(B" . "$B$h$s(B") ("$B;e(B" . "$B$$$H(B")
	  ("$B11(B" . "$B$&$9(B") ("$B1;(B" . "$B$&$j(B") ("$BO7(B" . "$B$*$$(B") ("$B4L(B" . "$B$+$s(B")
	  ("$B0a(B" . "$B$-$L(B") ("$B=i!J$3$m$b$X$s!K(B" . "$B$3$m$b(B") ("$BJF(B" . "$B$3$a(B")
	  ("$B@e(B" . "$B$7$?(B") ("$BfP(B" . "$B$9$-(B") ("$BC]!J$?$1$+$s$`$j!K(B" . "$B$?$1(B")
	  ("$B7l(B" . "$B$A(B") ("$B8W!J$H$i$+$s$`$j!K(B" . "$B$H$i(B") ("$BFy(B" . "$B$K$/(B")
	  ("$B@>(B" . "$B$K$7(B") ("$B1)(B" . "$B$O$M(B") ("$BMS(B" . "$B$R$D$8(B") ("$Bff(B" . "$B$U$G(B")
	  ("$B=.(B" . "$B$U$M(B") ("$B<*(B" . "$B$_$_(B") ("$BCn(B" . "$B$`$7(B") ("$B@V(B" . "$B$"$+(B")
	  ("$BB-!?I%(B" . "$B$"$7(B") ("$Bl5(B" . "$B$$$N$3(B") ("$B?C(B" . "$B$*$_(B") ("$B3-(B" . "$B$+$$(B")
	  ("$B?I(B" . "$B$+$i$$(B") ("$B<V(B" . "$B$/$k$^(B") ("$B8+(B" . "$B$1$s(B") ("$B8@(B" . "$B$4$s(B")
	  ("$BFS(B" . "$B$5$1(B") ("$BAv(B" . "$B$=$&(B") ("$BC+(B" . "$B$?$K(B") ("$B3Q(B" . "$B$D$N(B")
	  ("$BHP(B" . "$B$N$4$a(B") ("$BG~(B" . "$B$P$/(B") ("$BF&(B" . "$B$^$a(B") ("$B?H(B" . "$B$_(B")
	  ("$Bl8(B" . "$B$`$8$J(B") ("$B1+(B" . "$B$"$a(B") ("$BHs(B" . "$B$"$i$:(B") ("$B6b(B" . "$B$+$M(B")
	  ("$BLg(B" . "$B$b$s(B") ("$Bp2(B" . "$B$U$k$H$j(B") ("$BJG(B" . "$B$Z!<$8(B") ("$B2;(B" . "$B$*$H(B")
	  ("$B9a(B" . "$B$3$&(B") ("$B3W(B" . "$B$+$/(B") ("$BIw(B" . "$B$+$<(B") ("$B<s(B" . "$B$/$S(B")
	  ("$B?)(B" . "$B$7$g$/(B") ("$Bpj(B" . "$B$J$a$7(B") ("$BLL(B" . "$B$a$s(B") ("$BGO(B" . "$B$&$^(B")
	  ("$B54(B" . "$B$*$K(B") ("$Bqu(B" . "$B$+$_(B") ("$B9b(B" . "$B$?$+$$(B") ("$Br((B" . "$B$H$&(B")
	  ("$B9|(B" . "$B$[$M(B") ("$B5{(B" . "$B$&$*(B") ("$B55(B" . "$B$+$a(B") ("$BD;(B" . "$B$H$j(B")
	  ("$B9u(B" . "$B$/$m(B") ("$B</(B" . "$B$7$+(B") ("$BI!(B" . "$B$O$J(B") ("$Bso(B" . "$B$O(B")
	  ("$B5-9f(B" . "$B$-$4$&(B") ("$B$=$NB>(B" . "$B$=$N$?(B"))))

(defun canna-bushu-mode ()
  "Enter special mode to convert by BUSHU name."
  (interactive "*")
  (let* ((key (car (menudiag-select canna-sim-bushu-menu nil nil t)))
	 (bushu (car key))
	 (yomi (cdr key))
	 (bunsetsu
	  (canna-start-conversion 'canna-backend-Japanese-Bushu yomi nil))
	 (kouho-list (cdr (canna-list-candidates bunsetsu nil nil nil)))
	 (result (menudiag-select `(menu , (concat bushu ":") , kouho-list))))
    (insert result)
    ))


;;; canna server operation
(defun canna-server-finalize ()
  "disconnect server."
  (interactive)
  (canna-finalize-backend))

(defun canna-server-change ()
  "change server."
  (interactive)
  (let* ((hosts (if (listp canna-hostname) canna-hostname
		  (list canna-hostname)))
	 (hostname (completing-read 
		    "$B%5!<%P!<L>(B: " (mapcar '(lambda (x) (list x)) hosts)
		    nil nil nil))
	 port)
    (if (null (string-match ":" hostname))
	(progn
	  (setq port (if (numberp canna-server-port)
			 (number-to-string canna-server-port)
		       canna-server-port))
	  (setq port (completing-read
		      "$B%]!<%H(B: "
		      (mapcar '(lambda (x) (list x)) (list port))
		      nil nil port nil port)))
      (setq port (substring hostname (match-end 0))
	    hostname (substring hostname 0 (match-beginning 0))))
    (setq canna-server-port port)
    (setq hosts (delete hostname hosts))
    (setq canna-hostname (cons hostname hosts))
    (canna-finalize-backend)
    ))

;;; XXX canna-extend-mode
(defvar canna-sim-russia-menu
  '(menu "$B%m%7%"8l(B:"
	 ("$B'!(B" "$B'"(B" "$B'#(B" "$B'$(B" "$B'%(B" "$B'&(B" "$B''(B" "$B'((B" "$B')(B" "$B'*(B" "$B'+(B" "$B',(B" "$B'-(B"
	  "$B'.(B" "$B'/(B" "$B'0(B" "$B'1(B" "$B'2(B" "$B'3(B" "$B'4(B" "$B'5(B" "$B'6(B" "$B'7(B" "$B'8(B" "$B'9(B" "$B':(B"
	  "$B';(B" "$B'<(B" "$B'=(B" "$B'>(B" "$B'?(B" "$B'@(B" "$B'A(B" "$B'Q(B" "$B'R(B" "$B'S(B" "$B'T(B" "$B'U(B" "$B'V(B"
	  "$B'W(B" "$B'X(B" "$B'Y(B" "$B'Z(B" "$B'[(B" "$B'\(B" "$B'](B" "$B'^(B" "$B'_(B" "$B'`(B" "$B'a(B" "$B'b(B" "$B'c(B"
	  "$B'd(B" "$B'e(B" "$B'f(B" "$B'g(B" "$B'h(B" "$B'i(B" "$B'j(B" "$B'k(B" "$B'l(B" "$B'm(B" "$B'n(B" "$B'o(B" "$B'p(B"
	  "$B'q(B")))

(defvar canna-sim-greek-menu
  '(menu "$B%.%j%7%c8l(B:"
	 ("$B&!(B" "$B&"(B" "$B&#(B" "$B&$(B" "$B&%(B" "$B&&(B" "$B&'(B" "$B&((B" "$B&)(B" "$B&*(B" "$B&+(B" "$B&,(B" "$B&-(B"
	  "$B&.(B" "$B&/(B" "$B&0(B" "$B&1(B" "$B&2(B" "$B&3(B" "$B&4(B" "$B&5(B" "$B&6(B" "$B&7(B" "$B&8(B" "$B&A(B" "$B&B(B"
	  "$B&C(B" "$B&D(B" "$B&E(B" "$B&F(B" "$B&G(B" "$B&H(B" "$B&I(B" "$B&J(B" "$B&K(B" "$B&L(B" "$B&M(B" "$B&N(B" "$B&O(B"
	  "$B&P(B" "$B&Q(B" "$B&R(B" "$B&S(B" "$B&T(B" "$B&U(B" "$B&V(B" "$B&W(B" "$B&X(B")))

(defvar canna-sim-keisen-menu
  '(menu "$B7S@~(B:"
	 ("$B(!(B" "$B("(B" "$B(#(B" "$B($(B" "$B(%(B" "$B(&(B" "$B('(B" "$B(((B" "$B()(B" "$B(*(B" "$B(+(B" "$B(,(B" "$B(-(B"
	  "$B(.(B" "$B(/(B" "$B(0(B" "$B(1(B" "$B(2(B" "$B(3(B" "$B(4(B" "$B(5(B" "$B(6(B" "$B(7(B" "$B(8(B" "$B(9(B" "$B(:(B"
	  "$B(;(B" "$B(<(B" "$B(=(B" "$B(>(B" "$B(?(B" "$B(@(B")))

(defvar canna-kigou-menu
  `(menu "$B5-9f%a%K%e!<(B:" (("$B5-9fA4HL(B"     . , canna-sim-kigou-menu)
			  ("$B%m%7%"8l(B"     . , canna-sim-russia-menu)
			  ("$B%.%j%7%cJ8;z(B" . , canna-sim-greek-menu)
			  ("$B7S@~(B"         . , canna-sim-keisen-menu))))

(defvar canna-toroku-menu
  `(menu "$BC18lEPO?%a%K%e!<(B:" (("$BC18lEPO?(B" . touroku)
			      ("$BC18l:o=|(B" . delete-word)
			      ("$B<-=q%^%&%s%H!?%"%s%^%&%s%H(B" . NO_SUPPORT))))

(defvar canna-server-menu
  `(menu "$B%5!<%PA`:n%a%K%e!<(B:" (("$B%5!<%P$N@Z$jN%$7(B" . server-finalize)
				("$B%5!<%P$N@Z$jBX$((B" . server-change)
				("$B%5!<%P$NI=<((B"     . NO_SUPPORT))))

(defvar canna-environment-menu
  `(menu "$B4D6-@_Dj%a%K%e!<(B:" (("$B%5!<%PA`:n(B" . , canna-server-menu)
			      ("$B<-=q%^%&%s%H!?%"%s%^%&%s%H(B" . NO_SUPPORT)
			      ("$B3X=,>uBVI=<((B" . NO_SUPPORT))))

(defun canna-extend-mode ()
  "To enter an extend-mode of Canna."
  (interactive "*")
  (let* ((key (menudiag-select
	       `(menu "$B%a%K%e!<(B:" (("$B5-9fF~NO(B" . , canna-kigou-menu)
				   ("$B%3!<%IF~NO(B" . NO_SUPPORT)
				   ("$BIt<sF~NO(B" . bushu-mode)
				   ("$BC18lEPO?(B" . , canna-toroku-menu)
				   ("$B4D6-@_Dj(B" . , canna-environment-menu))))))
    (cond ((eq key 'NO_SUPPORT) (message "$B$^$@<B8=$5$l$F$$$^$;$s(B."))
	  ((symbolp key) (funcall
			  (intern (concat "canna-" (symbol-name key)))))
	  ((stringp key) (insert key))
	  (t (insert key))
	  )))

;;; for mlh
(setq mlh-default-backend "canna")

;;; for canna boil
(setq boiling-input-method "japanese-egg-canna")

(autoload 'boiling-rK-trans "boiling-egg" "romaji-kanji conversion" t)
(autoload 'boiling-rhkR-trans "boiling-egg" "romaji-kana conversion" t)

(defun canna-boil ()
  "`canna-boil' cooks `canna' as if `boil' does for `egg'."
  (interactive)
  (local-set-key "\C-j" 'boiling-rK-trans)
  (local-set-key "\ej" 'boiling-rhkR-trans)
  (message "boiled"))


(provide 'egg-canna)
;;; egg-canna.el ends here.
