#!/bin/bash
# torque	(http://www.clusterresources.com/pages/products/torque-resource-manager.php)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-05-23
# require:
#	readline
#
SRC_URI=http://www.clusterresources.com/downloads/torque/torque-2.3.10.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
#SRC_NAME=${SRC_FILE%%.tar.gz}
#VERSION=${SRC_NAME##*_}
#PAC_NAME=${SRC_NAME%%_$VERSION}-$VERSION
#PAC_NAME=${SRC_NAME%%-stable}
#echo $PAC_NAME; exit

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/hpc
PAC_DIR=$PLAMO/Packages/4.7/HPC
BUILD_DIR=$PLAMO/torque
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin:/opt/teTeX/bin:/opt/php5/bin


tar xvfz $SRC_DIR/$SRC_FILE
if [ -f "$PAT_FILE" ]; then
  patch < $PAT_FILE
fi
cd $PAC_NAME || exit 1
./configure --prefix=/usr

# According to the Makefile
make depend
make 
make install DESTDIR=$WORK
# or use chkinstall as below

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
    `find . -maxdepth 1 -type f -name  "[A-Z]*" | grep -vi makefile` \
    $WORK/$DOC_DIR/
chown -R root.root $WORK/$DOC_DIR/
chmod -R a+rX,go-w $WORK/$DOC_DIR/

mkdir -p $WORK/install || exit 1
sed -e 's/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/' \
      $CUSTOM_DIR/%custom_doinst_script%.sh > $WORK/install/doinst.sh

cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD

## or use Plamo version of chkinstall
#chkinstall -P -y
#mv -v ${SRC_NAME}-i386-1.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
## if you add custom install script,
##cd $WORK
##tar xvfz ../${SRC_NAME}-i386-1.tgz
##cat $CUSTOM_DIR/doinst.sh >> install/doinst.sh
##tar cvfz $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz */*
#ls -l $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
#cd $CWD
