/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import gnu.classpath.tools.rmic.AbstractMethodGenerator;
import gnu.classpath.tools.rmic.RmiMethodGenerator;
import gnu.classpath.tools.rmic.SourceGiopRmicCompiler;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Iterator;

public class SourceRmicCompiler
extends SourceGiopRmicCompiler {
    public boolean addZeroSizeObjecArray;

    public String generateStub() {
        String template = this.getResource("Stub_12.jav");
        StringBuffer b = new StringBuffer();
        for (RmiMethodGenerator m : this.methods) {
            b.append(m.generateStubMethod());
        }
        this.vars.put("#stub_methods", b.toString());
        this.vars.put("#imports", this.getImportStatements());
        this.vars.put("#interfaces", this.getAllInterfaces());
        this.vars.put("#stub_method_declarations", this.getStubMethodDeclarations());
        this.vars.put("#stub_method_initializations", this.getStubMethodInitializations());
        if (this.addZeroSizeObjecArray) {
            this.vars.put("#zeroSizeObjecArray", "private static final Object[] NO_ARGS = new Object[0];");
            this.vars.put("#zeroSizeClassArray", "final Class[]  NO_ARGSc = new Class[0];");
        } else {
            this.vars.put("#zeroSizeObjecArray", "");
            this.vars.put("#zeroSizeClassArray", "");
        }
        String output = this.replaceAll(template, this.vars);
        return output;
    }

    protected AbstractMethodGenerator createMethodGenerator(Method m) {
        return new RmiMethodGenerator(m, this);
    }

    public String getStubMethodDeclarations() {
        StringBuffer b = new StringBuffer();
        Iterator iter = this.methods.iterator();
        while (iter.hasNext()) {
            RmiMethodGenerator method = (RmiMethodGenerator)iter.next();
            b.append("    ");
            b.append("private static final Method met_");
            b.append(method.method.getName());
            b.append(';');
            if (!iter.hasNext()) continue;
            b.append('\n');
        }
        return b.toString();
    }

    public String getStubMethodInitializations() {
        StringBuffer b = new StringBuffer();
        for (RmiMethodGenerator method : this.methods) {
            b.append("             ");
            b.append("met_");
            b.append(method.method.getName());
            b.append(" =\n               ");
            b.append(this.name(method.method.getDeclaringClass()));
            b.append(".class.getMethod(");
            b.append('\"');
            b.append(method.method.getName());
            b.append("\", ");
            if (method.method.getParameterTypes().length == 0) {
                b.append("NO_ARGSc);");
            } else {
                b.append("new Class[]\n                 {\n                   ");
                b.append(method.getArgListAsClassArray());
                b.append("\n                 }");
                b.append(");");
            }
            b.append('\n');
        }
        return b.toString();
    }

    public void reset() {
        this.addZeroSizeObjecArray = false;
        super.reset();
    }

    public String convertStubName(String name) {
        return name;
    }

    protected boolean outputTie(File fw, Class c) {
        return true;
    }
}

