/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import gnu.classpath.tools.jar.Updater;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class Indexer
extends Updater {
    private void indexJarFile(StringBuffer result, File fileName, boolean verbose) throws IOException {
        Manifest m;
        if (verbose) {
            String msg = MessageFormat.format(Messages.getString("Indexer.Indexing"), fileName);
            System.err.println(msg);
        }
        JarFile jf = new JarFile(fileName);
        LinkedHashSet<String> entries = new LinkedHashSet<String>();
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String name = entry.getName();
            if (name.startsWith("META-INF/")) continue;
            int index = name.lastIndexOf(47);
            if (index != -1) {
                name = name.substring(0, index);
            }
            entries.add(name);
        }
        if (!entries.isEmpty()) {
            result.append(fileName);
            result.append('\n');
            Iterator i = entries.iterator();
            while (i.hasNext()) {
                result.append(i.next());
                result.append('\n');
            }
            result.append('\n');
        }
        if ((m = jf.getManifest()) != null) {
            File parent = fileName.getParentFile();
            Attributes attrs = m.getMainAttributes();
            String jars = attrs.getValue(Attributes.Name.CLASS_PATH);
            if (jars != null) {
                StringTokenizer st = new StringTokenizer(jars, " ");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    this.indexJarFile(result, new File(parent, name), verbose);
                }
            }
        }
        jf.close();
    }

    protected void writeCommandLineEntries(Main parameters, OutputStream os) throws IOException {
        super.writeCommandLineEntries(parameters, os);
        StringBuffer contents = new StringBuffer();
        this.indexJarFile(contents, parameters.archiveFile, parameters.verbose);
        if (contents.length() != 0) {
            contents.insert(0, "1.0\n\n");
            contents.insert(0, "JarIndex-Version: ");
            ByteArrayInputStream in = new ByteArrayInputStream(contents.toString().getBytes());
            this.writeFile(false, in, "META-INF/INDEX.LIST", parameters.verbose);
        }
    }
}

