/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.swing.SizeRequirements;

public class OverlayLayout
implements LayoutManager2,
Serializable {
    private static final long serialVersionUID = 18082829169631543L;
    private Container target;
    private SizeRequirements[] xChildren;
    private SizeRequirements[] yChildren;
    private SizeRequirements xTotal;
    private SizeRequirements yTotal;
    private int[] offsetsX;
    private int[] offsetsY;
    private int[] spansX;
    private int[] spansY;

    public OverlayLayout(Container target) {
        this.target = target;
    }

    public void invalidateLayout(Container target) {
        this.xChildren = null;
        this.yChildren = null;
        this.xTotal = null;
        this.yTotal = null;
        this.offsetsX = null;
        this.offsetsY = null;
        this.spansX = null;
        this.spansY = null;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void addLayoutComponent(Component component, Object constraints) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container target) {
        if (target != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return new Dimension(this.xTotal.preferred, this.yTotal.preferred);
    }

    public Dimension minimumLayoutSize(Container target) {
        if (target != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return new Dimension(this.xTotal.minimum, this.yTotal.minimum);
    }

    public Dimension maximumLayoutSize(Container target) {
        if (target != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return new Dimension(this.xTotal.maximum, this.yTotal.maximum);
    }

    public float getLayoutAlignmentX(Container target) {
        if (target != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return this.xTotal.alignment;
    }

    public float getLayoutAlignmentY(Container target) {
        if (target != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkTotalRequirements();
        return this.yTotal.alignment;
    }

    public void layoutContainer(Container target) {
        if (target != this.target) {
            throw new AWTError("OverlayLayout can't be shared");
        }
        this.checkLayout();
        Component[] children = target.getComponents();
        int i = 0;
        while (i < children.length) {
            children[i].setBounds(this.offsetsX[i], this.offsetsY[i], this.spansX[i], this.spansY[i]);
            ++i;
        }
    }

    private void checkRequirements() {
        if (this.xChildren == null || this.yChildren == null) {
            Component[] children = this.target.getComponents();
            this.xChildren = new SizeRequirements[children.length];
            this.yChildren = new SizeRequirements[children.length];
            int i = 0;
            while (i < children.length) {
                if (!children[i].isVisible()) {
                    this.xChildren[i] = new SizeRequirements();
                    this.yChildren[i] = new SizeRequirements();
                } else {
                    this.xChildren[i] = new SizeRequirements(children[i].getMinimumSize().width, children[i].getPreferredSize().width, children[i].getMaximumSize().width, children[i].getAlignmentX());
                    this.yChildren[i] = new SizeRequirements(children[i].getMinimumSize().height, children[i].getPreferredSize().height, children[i].getMaximumSize().height, children[i].getAlignmentY());
                }
                ++i;
            }
        }
    }

    private void checkTotalRequirements() {
        if (this.xTotal == null || this.yTotal == null) {
            this.checkRequirements();
            this.xTotal = SizeRequirements.getAlignedSizeRequirements(this.xChildren);
            this.yTotal = SizeRequirements.getAlignedSizeRequirements(this.yChildren);
        }
    }

    private void checkLayout() {
        if (this.offsetsX == null || this.offsetsY == null || this.spansX == null || this.spansY == null) {
            this.checkRequirements();
            this.checkTotalRequirements();
            int len = this.target.getComponents().length;
            this.offsetsX = new int[len];
            this.offsetsY = new int[len];
            this.spansX = new int[len];
            this.spansY = new int[len];
            Insets in = this.target.getInsets();
            int width = this.target.getWidth() - in.left - in.right;
            int height = this.target.getHeight() - in.top - in.bottom;
            SizeRequirements.calculateAlignedPositions(width, this.xTotal, this.xChildren, this.offsetsX, this.spansX);
            SizeRequirements.calculateAlignedPositions(height, this.yTotal, this.yChildren, this.offsetsY, this.spansY);
        }
    }
}

