/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFileFormat {
    private int byteLength;
    private AudioFormat format;
    private Type type;
    private int frameLength;
    private Map<String, Object> properties;

    public AudioFileFormat(Type type, AudioFormat fmt, int frameLen) {
        this.byteLength = -1;
        this.format = fmt;
        this.type = type;
        this.frameLength = frameLen;
        this.properties = Collections.emptyMap();
    }

    public AudioFileFormat(Type type, AudioFormat fmt, int frameLen, Map<String, Object> properties) {
        this.byteLength = -1;
        this.format = fmt;
        this.type = type;
        this.frameLength = frameLen;
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    protected AudioFileFormat(Type type, int byteLen, AudioFormat fmt, int frameLen) {
        this.byteLength = byteLen;
        this.format = fmt;
        this.type = type;
        this.frameLength = frameLen;
        this.properties = Collections.emptyMap();
    }

    public int getByteLength() {
        return this.byteLength;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public String toString() {
        return "byteLength=" + this.byteLength + "; format=" + this.format + "; type=" + this.type + "; frameLength=" + this.frameLength;
    }

    public static class Type {
        public static final Type AIFC = new Type("AIFC", "aifc");
        public static final Type AIFF = new Type("AIFF", "aiff");
        public static final Type AU = new Type("AU", "au");
        public static final Type SND = new Type("SND", "snd");
        public static final Type WAVE = new Type("WAVE", "wav");
        private String name;
        private String extension;

        public Type(String name, String extension) {
            this.name = name;
            this.extension = extension;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Type)) {
                return false;
            }
            Type other = (Type)o;
            return this.name.equals(other.name) && this.extension.equals(other.extension);
        }

        public final int hashCode() {
            return this.name.hashCode() + this.extension.hashCode();
        }

        public String getExtension() {
            return this.extension;
        }

        public final String toString() {
            return this.name;
        }
    }
}

