/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImageIO {
    private static File cacheDirectory;
    private static boolean useCache;

    static {
        useCache = true;
    }

    private ImageIO() {
    }

    private static Iterator<ImageReader> getReadersByFilter(Class<ImageReaderSpi> type, ServiceRegistry.Filter filter, Object readerExtension) {
        try {
            Iterator<ImageReaderSpi> it = ImageIO.getRegistry().getServiceProviders(type, filter, true);
            return new ImageReaderIterator(it, readerExtension);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    private static Iterator<ImageWriter> getWritersByFilter(Class<ImageWriterSpi> type, ServiceRegistry.Filter filter, Object writerExtension) {
        try {
            Iterator<ImageWriterSpi> it = ImageIO.getRegistry().getServiceProviders(type, filter, true);
            return new ImageWriterIterator(it, writerExtension);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    public static File getCacheDirectory() {
        return cacheDirectory;
    }

    public static Iterator<ImageReader> getImageReadersByFormatName(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        return ImageIO.getReadersByFilter(ImageReaderSpi.class, new ReaderFormatFilter(formatName), formatName);
    }

    public static Iterator<ImageReader> getImageReadersByMIMEType(String MIMEType) {
        if (MIMEType == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        return ImageIO.getReadersByFilter(ImageReaderSpi.class, new ReaderMIMETypeFilter(MIMEType), MIMEType);
    }

    public static Iterator<ImageReader> getImageReadersBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        return ImageIO.getReadersByFilter(ImageReaderSpi.class, new ReaderSuffixFilter(fileSuffix), fileSuffix);
    }

    public static Iterator<ImageWriter> getImageWritersByFormatName(String formatName) {
        if (formatName == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        return ImageIO.getWritersByFilter(ImageWriterSpi.class, new WriterFormatFilter(formatName), formatName);
    }

    public static Iterator<ImageWriter> getImageWritersByMIMEType(String MIMEType) {
        if (MIMEType == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        return ImageIO.getWritersByFilter(ImageWriterSpi.class, new WriterMIMETypeFilter(MIMEType), MIMEType);
    }

    public static Iterator<ImageWriter> getImageWritersBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            throw new IllegalArgumentException("fileSuffix may not be null");
        }
        return ImageIO.getWritersByFilter(ImageWriterSpi.class, new WriterSuffixFilter(fileSuffix), fileSuffix);
    }

    public static String[] getReaderFormatNames() {
        try {
            Iterator<ImageReaderSpi> it = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, true);
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                ImageReaderSpi spi = it.next();
                String[] names = spi.getFormatNames();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static String[] getReaderMIMETypes() {
        try {
            Iterator<ImageReaderSpi> it = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, true);
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                ImageReaderSpi spi = it.next();
                String[] names = spi.getMIMETypes();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    private static IIORegistry getRegistry() {
        return IIORegistry.getDefaultInstance();
    }

    public static boolean getUseCache() {
        return useCache;
    }

    public static String[] getWriterFormatNames() {
        try {
            Iterator<ImageWriterSpi> it = ImageIO.getRegistry().getServiceProviders(ImageWriterSpi.class, true);
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                ImageWriterSpi spi = it.next();
                String[] names = spi.getFormatNames();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static String[] getWriterMIMETypes() {
        try {
            Iterator<ImageWriterSpi> it = ImageIO.getRegistry().getServiceProviders(ImageWriterSpi.class, true);
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                ImageWriterSpi spi = it.next();
                String[] names = spi.getMIMETypes();
                int i = names.length - 1;
                while (i >= 0) {
                    result.add(names[i]);
                    --i;
                }
            }
            return result.toArray(new String[result.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static void scanForPlugins() {
        IIORegistry.getDefaultInstance().registerApplicationClasspathSpis();
    }

    public static void setCacheDirectory(File cacheDirectory) {
        if (cacheDirectory != null) {
            if (!cacheDirectory.isDirectory()) {
                throw new IllegalArgumentException("cacheDirectory must be a directory");
            }
            cacheDirectory.canWrite();
        }
        ImageIO.cacheDirectory = cacheDirectory;
    }

    public static void setUseCache(boolean useCache) {
        ImageIO.useCache = useCache;
    }

    public static boolean write(RenderedImage im, String formatName, File output) throws IOException {
        if (im == null || formatName == null || output == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(im, formatName, new FileOutputStream(output));
    }

    public static boolean write(RenderedImage im, String formatName, OutputStream output) throws IOException {
        if (im == null || formatName == null || output == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(im, formatName, new MemoryCacheImageOutputStream(output));
    }

    public static boolean write(RenderedImage im, String formatName, ImageOutputStream output) throws IOException {
        if (im == null || formatName == null || output == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(formatName);
        IIOImage img = new IIOImage(im, null, null);
        while (writers.hasNext()) {
            ImageWriter w = writers.next();
            try {
                w.setOutput(output);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            w.write(null, img, null);
            output.close();
            return true;
        }
        return false;
    }

    public static BufferedImage read(ImageInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageReaderSpi> providers = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, true);
        while (providers.hasNext()) {
            ImageReaderSpi spi = providers.next();
            if (!spi.canDecodeInput(stream)) continue;
            ImageReader reader = spi.createReaderInstance();
            reader.setInput(stream);
            return reader.read(0, null);
        }
        return null;
    }

    public static BufferedImage read(URL input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(input.openStream());
    }

    public static BufferedImage read(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new MemoryCacheImageInputStream(input));
    }

    public static BufferedImage read(File input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new FileInputStream(input));
    }

    public static ImageInputStream createImageInputStream(Object input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageInputStreamSpi> spis = ImageIO.getRegistry().getServiceProviders(ImageInputStreamSpi.class, true);
        ImageInputStreamSpi foundSpi = null;
        while (spis.hasNext()) {
            ImageInputStreamSpi spi = spis.next();
            if (!input.getClass().equals(spi.getInputClass())) continue;
            foundSpi = spi;
            break;
        }
        return foundSpi == null ? null : foundSpi.createInputStreamInstance(input, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static ImageOutputStream createImageOutputStream(Object output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageOutputStreamSpi> spis = ImageIO.getRegistry().getServiceProviders(ImageOutputStreamSpi.class, true);
        ImageOutputStreamSpi foundSpi = null;
        while (spis.hasNext()) {
            ImageOutputStreamSpi spi = spis.next();
            if (!output.getClass().equals(spi.getOutputClass())) continue;
            foundSpi = spi;
            break;
        }
        return foundSpi == null ? null : foundSpi.createOutputStreamInstance(output, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static ImageReader getImageReader(ImageWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageWriterSpi spi = writer.getOriginatingProvider();
        String[] readerSpiNames = spi.getImageReaderSpiNames();
        ImageReader r = null;
        if (readerSpiNames != null) {
            try {
                Class<?> readerClass = Class.forName(readerSpiNames[0]);
                r = (ImageReader)readerClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return r;
    }

    public static Iterator<ImageReader> getImageReaders(Object input) {
        if (input == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageReaderSpi> spiIterator = ImageIO.getRegistry().getServiceProviders(ImageReaderSpi.class, new ReaderObjectFilter(input), true);
        return new ImageReaderIterator(spiIterator);
    }

    public static Iterator<ImageWriter> getImageWriters(ImageTypeSpecifier type, String formatName) {
        if (type == null || formatName == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator<ImageWriterSpi> spiIterator = ImageIO.getRegistry().getServiceProviders(ImageWriterSpi.class, new WriterObjectFilter(type, formatName), true);
        return new ImageWriterIterator(spiIterator);
    }

    public static ImageWriter getImageWriter(ImageReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageReaderSpi spi = reader.getOriginatingProvider();
        String[] writerSpiNames = spi.getImageWriterSpiNames();
        ImageWriter w = null;
        if (writerSpiNames != null) {
            try {
                Class<?> writerClass = Class.forName(writerSpiNames[0]);
                w = (ImageWriter)writerClass.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return w;
    }

    public static Iterator<ImageTranscoder> getImageTranscoders(ImageReader reader, ImageWriter writer) {
        if (reader == null || writer == null) {
            throw new IllegalArgumentException("null argument");
        }
        final Iterator<ImageTranscoderSpi> spiIterator = ImageIO.getRegistry().getServiceProviders(ImageTranscoderSpi.class, new TranscoderFilter(reader, writer), true);
        return new Iterator<ImageTranscoder>(){

            @Override
            public boolean hasNext() {
                return spiIterator.hasNext();
            }

            @Override
            public ImageTranscoder next() {
                return ((ImageTranscoderSpi)spiIterator.next()).createTranscoderInstance();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageReaderIterator
    implements Iterator<ImageReader> {
        Iterator<ImageReaderSpi> it;
        Object readerExtension;

        public ImageReaderIterator(Iterator<ImageReaderSpi> it, Object readerExtension) {
            this.it = it;
            this.readerExtension = readerExtension;
        }

        public ImageReaderIterator(Iterator<ImageReaderSpi> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ImageReader next() {
            try {
                ImageReaderSpi spi = this.it.next();
                return this.readerExtension == null ? spi.createReaderInstance() : spi.createReaderInstance(this.readerExtension);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImageWriterIterator
    implements Iterator<ImageWriter> {
        Iterator<ImageWriterSpi> it;
        Object writerExtension;

        public ImageWriterIterator(Iterator<ImageWriterSpi> it, Object writerExtension) {
            this.it = it;
            this.writerExtension = writerExtension;
        }

        public ImageWriterIterator(Iterator<ImageWriterSpi> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public ImageWriter next() {
            try {
                ImageWriterSpi spi = this.it.next();
                return this.writerExtension == null ? spi.createWriterInstance() : spi.createWriterInstance(this.writerExtension);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ReaderFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public ReaderFormatFilter(String formatName) {
            this.formatName = formatName;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                String[] formatNames = spi.getFormatNames();
                int i = formatNames.length - 1;
                while (i >= 0) {
                    if (this.formatName.equals(formatNames[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }

    private static final class ReaderMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public ReaderMIMETypeFilter(String MIMEType) {
            this.MIMEType = MIMEType;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                String[] mimetypes = spi.getMIMETypes();
                int i = mimetypes.length - 1;
                while (i >= 0) {
                    if (this.MIMEType.equals(mimetypes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }

    private static final class ReaderObjectFilter
    implements ServiceRegistry.Filter {
        private Object object;

        public ReaderObjectFilter(Object object) {
            this.object = object;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                try {
                    if (spi.canDecodeInput(this.object)) {
                        return true;
                    }
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    private static final class ReaderSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public ReaderSuffixFilter(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageReaderSpi) {
                ImageReaderSpi spi = (ImageReaderSpi)provider;
                String[] suffixes = spi.getFileSuffixes();
                int i = suffixes.length - 1;
                while (i >= 0) {
                    if (this.fileSuffix.equals(suffixes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }

    private static final class TranscoderFilter
    implements ServiceRegistry.Filter {
        private ImageReader reader;
        private ImageWriter writer;

        public TranscoderFilter(ImageReader reader, ImageWriter writer) {
            this.reader = reader;
            this.writer = writer;
        }

        public boolean filter(Object provider) {
            ImageTranscoderSpi spi;
            return provider instanceof ImageTranscoderSpi && (spi = (ImageTranscoderSpi)provider).getReaderServiceProviderName().equals(this.reader.getOriginatingProvider().getClass().getName()) && spi.getWriterServiceProviderName().equals(this.writer.getOriginatingProvider().getClass().getName());
        }
    }

    private static final class WriterFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public WriterFormatFilter(String formatName) {
            this.formatName = formatName;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageWriterSpi) {
                ImageWriterSpi spi = (ImageWriterSpi)provider;
                String[] formatNames = spi.getFormatNames();
                int i = formatNames.length - 1;
                while (i >= 0) {
                    if (this.formatName.equals(formatNames[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }

    private static final class WriterMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public WriterMIMETypeFilter(String MIMEType) {
            this.MIMEType = MIMEType;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageWriterSpi) {
                ImageWriterSpi spi = (ImageWriterSpi)provider;
                String[] mimetypes = spi.getMIMETypes();
                int i = mimetypes.length - 1;
                while (i >= 0) {
                    if (this.MIMEType.equals(mimetypes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }

    private static final class WriterObjectFilter
    implements ServiceRegistry.Filter {
        private ImageTypeSpecifier type;
        private String formatName;

        public WriterObjectFilter(ImageTypeSpecifier type, String formatName) {
            this.type = type;
            this.formatName = formatName;
        }

        public boolean filter(Object provider) {
            ImageWriterSpi spi;
            if (provider instanceof ImageWriterSpi && (spi = (ImageWriterSpi)provider).canEncodeImage(this.type)) {
                String[] formatNames = spi.getFormatNames();
                int i = formatNames.length - 1;
                while (i >= 0) {
                    if (this.formatName.equals(formatNames[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }

    private static final class WriterSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public WriterSuffixFilter(String fileSuffix) {
            this.fileSuffix = fileSuffix;
        }

        public boolean filter(Object provider) {
            if (provider instanceof ImageWriterSpi) {
                ImageWriterSpi spi = (ImageWriterSpi)provider;
                String[] suffixes = spi.getFileSuffixes();
                int i = suffixes.length - 1;
                while (i >= 0) {
                    if (this.fileSuffix.equals(suffixes[i])) {
                        return true;
                    }
                    --i;
                }
            }
            return false;
        }
    }
}

