/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    public static final int GZIP_MAGIC = 35615;
    static final int FTEXT = 1;
    static final int FHCRC = 2;
    static final int FEXTRA = 4;
    static final int FNAME = 8;
    static final int FCOMMENT = 16;
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean readGZIPHeader;

    public GZIPInputStream(InputStream in) throws IOException {
        this(in, 4096);
    }

    public GZIPInputStream(InputStream in, int size) throws IOException {
        super(in, new Inflater(true), size);
        this.readHeader();
    }

    public void close() throws IOException {
        super.close();
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        if (!this.readGZIPHeader) {
            this.readHeader();
        }
        if (this.eos) {
            return -1;
        }
        int numRead = super.read(buf, offset, len);
        if (numRead > 0) {
            this.crc.update(buf, offset, numRead);
        }
        if (this.inf.finished()) {
            this.readFooter();
        }
        return numRead;
    }

    private void readHeader() throws IOException {
        int readByte;
        int readByte2;
        CRC32 headCRC = new CRC32();
        int magic = this.in.read();
        if (magic < 0) {
            this.eos = true;
            return;
        }
        int magic2 = this.in.read();
        if (magic + (magic2 << 8) != 35615) {
            throw new IOException("Error in GZIP header, bad magic code");
        }
        headCRC.update(magic);
        headCRC.update(magic2);
        int CM = this.in.read();
        if (CM != 8) {
            throw new IOException("Error in GZIP header, data not in deflate format");
        }
        headCRC.update(CM);
        int flags = this.in.read();
        if (flags < 0) {
            throw new EOFException("Early EOF in GZIP header");
        }
        headCRC.update(flags);
        if ((flags & 0xD0) != 0) {
            throw new IOException("Reserved flag bits in GZIP header != 0");
        }
        int i = 0;
        while (i < 6) {
            readByte2 = this.in.read();
            if (readByte2 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            headCRC.update(readByte2);
            ++i;
        }
        if ((flags & 4) != 0) {
            i = 0;
            while (i < 2) {
                readByte2 = this.in.read();
                if (readByte2 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                headCRC.update(readByte2);
                ++i;
            }
            if (this.in.read() < 0 || this.in.read() < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            int len1 = this.in.read();
            int len2 = this.in.read();
            if (len1 < 0 || len2 < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            headCRC.update(len1);
            headCRC.update(len2);
            int extraLen = len1 << 8 | len2;
            int i2 = 0;
            while (i2 < extraLen) {
                int readByte3 = this.in.read();
                if (readByte3 < 0) {
                    throw new EOFException("Early EOF in GZIP header");
                }
                headCRC.update(readByte3);
                ++i2;
            }
        }
        if ((flags & 8) != 0) {
            while ((readByte = this.in.read()) > 0) {
                headCRC.update(readByte);
            }
            if (readByte < 0) {
                throw new EOFException("Early EOF in GZIP file name");
            }
            headCRC.update(readByte);
        }
        if ((flags & 0x10) != 0) {
            while ((readByte = this.in.read()) > 0) {
                headCRC.update(readByte);
            }
            if (readByte < 0) {
                throw new EOFException("Early EOF in GZIP comment");
            }
            headCRC.update(readByte);
        }
        if ((flags & 2) != 0) {
            int crcval = this.in.read();
            if (crcval < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            int tempByte = this.in.read();
            if (tempByte < 0) {
                throw new EOFException("Early EOF in GZIP header");
            }
            if ((crcval = crcval << 8 | tempByte) != ((int)headCRC.getValue() & 0xFFFF)) {
                throw new IOException("Header CRC value mismatch");
            }
        }
        this.readGZIPHeader = true;
    }

    private void readFooter() throws IOException {
        byte[] footer = new byte[8];
        int avail = this.inf.getRemaining();
        if (avail > 8) {
            avail = 8;
        }
        System.arraycopy(this.buf, this.len - this.inf.getRemaining(), footer, 0, avail);
        int needed = 8 - avail;
        while (needed > 0) {
            int count = this.in.read(footer, 8 - needed, needed);
            if (count <= 0) {
                throw new EOFException("Early EOF in GZIP footer");
            }
            needed -= count;
        }
        int crcval = footer[0] & 0xFF | (footer[1] & 0xFF) << 8 | (footer[2] & 0xFF) << 16 | footer[3] << 24;
        if (crcval != (int)this.crc.getValue()) {
            throw new IOException("GZIP crc sum mismatch, theirs \"" + Integer.toHexString(crcval) + "\" and ours \"" + Integer.toHexString((int)this.crc.getValue()));
        }
        int total = footer[4] & 0xFF | (footer[5] & 0xFF) << 8 | (footer[6] & 0xFF) << 16 | footer[7] << 24;
        if (total != this.inf.getTotalOut()) {
            throw new IOException("Number of bytes mismatch");
        }
        this.eos = true;
    }
}

