/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private transient E[] data;

    public CopyOnWriteArrayList() {
        this.data = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<? extends E> c) {
        this.data = new Object[c.size()];
        int index = 0;
        for (E value : c) {
            this.data[index++] = value;
        }
    }

    public CopyOnWriteArrayList(E[] array) {
        this.data = (Object[])array.clone();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean contains(Object e) {
        return this.indexOf(e) != -1;
    }

    @Override
    public int indexOf(Object e) {
        E[] data = this.data;
        int i = 0;
        while (i < data.length) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(E e, int index) {
        E[] data = this.data;
        int i = index;
        while (i < data.length) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object e) {
        E[] data = this.data;
        int i = data.length - 1;
        while (i >= 0) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public int lastIndexOf(E e, int index) {
        E[] data = this.data;
        int i = index;
        while (i >= 0) {
            if (CopyOnWriteArrayList.equals(e, data[i])) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object clone() {
        CopyOnWriteArrayList clone = null;
        try {
            clone = (CopyOnWriteArrayList)super.clone();
            clone.data = (Object[])this.data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    @Override
    public Object[] toArray() {
        E[] data = this.data;
        Object[] array = new Object[data.length];
        System.arraycopy(data, 0, array, 0, data.length);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        E[] data = this.data;
        if (a.length < data.length) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), data.length);
        } else if (a.length > data.length) {
            a[data.length] = null;
        }
        System.arraycopy(data, 0, a, 0, data.length);
        return a;
    }

    @Override
    public E get(int index) {
        return this.data[index];
    }

    @Override
    public synchronized E set(int index, E e) {
        E result = this.data[index];
        Object[] newData = (Object[])this.data.clone();
        newData[index] = e;
        this.data = newData;
        return result;
    }

    @Override
    public synchronized boolean add(E e) {
        E[] data = this.data;
        Object[] newData = new Object[data.length + 1];
        System.arraycopy(data, 0, newData, 0, data.length);
        newData[data.length] = e;
        this.data = newData;
        return true;
    }

    @Override
    public synchronized void add(int index, E e) {
        E[] data = this.data;
        Object[] newData = new Object[data.length + 1];
        System.arraycopy(data, 0, newData, 0, index);
        newData[index] = e;
        System.arraycopy(data, index, newData, index + 1, data.length - index);
        this.data = newData;
    }

    @Override
    public synchronized E remove(int index) {
        E[] data = this.data;
        Object[] newData = new Object[data.length - 1];
        if (index > 0) {
            System.arraycopy(data, 0, newData, 0, index - 1);
        }
        System.arraycopy(data, index + 1, newData, index, data.length - index - 1);
        E r = data[index];
        this.data = newData;
        return r;
    }

    @Override
    public synchronized void clear() {
        this.data = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.data.length, c);
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> c) {
        E[] data = this.data;
        c.iterator();
        int csize = c.size();
        if (csize == 0) {
            return false;
        }
        Object[] newData = new Object[data.length + csize];
        System.arraycopy(data, 0, newData, 0, data.length);
        int end = data.length;
        for (E value : c) {
            newData[end++] = value;
        }
        this.data = newData;
        return true;
    }

    public synchronized boolean addIfAbsent(E val) {
        if (this.contains(val)) {
            return false;
        }
        this.add(val);
        return true;
    }

    public synchronized int addAllAbsent(Collection<? extends E> c) {
        int result = 0;
        for (E val : c) {
            if (!this.addIfAbsent(val)) continue;
            ++result;
        }
        return result;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        int len = this.data.length;
        s.writeInt(len);
        int i = 0;
        while (i < this.data.length) {
            s.writeObject(this.data[i]);
            ++i;
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int capacity = s.readInt();
        this.data = new Object[capacity];
        int i = 0;
        while (i < capacity) {
            this.data[i] = s.readObject();
            ++i;
        }
    }

    static final boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    Object[] getArray() {
        return this.data;
    }
}

