/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRL;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertStore {
    private static final String CERT_STORE = "CertStore";
    private CertStoreSpi storeSpi;
    private Provider provider;
    private String type;
    private CertStoreParameters params;

    protected CertStore(CertStoreSpi storeSpi, Provider provider, String type, CertStoreParameters params) {
        this.storeSpi = storeSpi;
        this.provider = provider;
        this.type = type;
        this.params = params;
    }

    public static final synchronized String getDefaultType() {
        String type = null;
        type = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("certstore.type");
            }
        });
        if (type == null) {
            type = "LDAP";
        }
        return type;
    }

    public static CertStore getInstance(String type, CertStoreParameters params) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        NoSuchAlgorithmException lastException = null;
        int i = 0;
        while (i < p.length) {
            try {
                return CertStore.getInstance(type, params, p[i]);
            }
            catch (NoSuchAlgorithmException x) {
                lastException = x;
                ++i;
            }
        }
        if (lastException != null) {
            throw lastException;
        }
        throw new NoSuchAlgorithmException(type);
    }

    public static CertStore getInstance(String type, CertStoreParameters params, String provider) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        if (provider == null) {
            throw new IllegalArgumentException("provider MUST NOT be null");
        }
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return CertStore.getInstance(type, params, p);
    }

    public static CertStore getInstance(String type, CertStoreParameters params, Provider provider) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        Throwable cause;
        StringBuilder sb = new StringBuilder("CertStore of type [").append(type).append("] from provider[").append(provider).append("] could not be created");
        try {
            Object[] args = new Object[]{params};
            Object spi = Engine.getInstance(CERT_STORE, type, provider, args);
            return new CertStore((CertStoreSpi)spi, provider, type, params);
        }
        catch (InvocationTargetException x) {
            cause = x.getCause();
            if (cause instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)cause;
            }
            if (cause == null) {
                cause = x;
            }
        }
        catch (ClassCastException x) {
            cause = x;
        }
        NoSuchAlgorithmException x = new NoSuchAlgorithmException(sb.toString());
        x.initCause(cause);
        throw x;
    }

    public final String getType() {
        return this.type;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final CertStoreParameters getCertStoreParameters() {
        return this.params != null ? (CertStoreParameters)this.params.clone() : null;
    }

    public final Collection<? extends Certificate> getCertificates(CertSelector selector) throws CertStoreException {
        return this.storeSpi.engineGetCertificates(selector);
    }

    public final Collection<? extends CRL> getCRLs(CRLSelector selector) throws CertStoreException {
        return this.storeSpi.engineGetCRLs(selector);
    }
}

