/*
 * Decompiled with CFR 0.152.
 */
package java.security;

final class VMSecureRandom {
    VMSecureRandom() {
    }

    static int generateSeed(byte[] buffer, int offset, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be nonnegative");
        }
        if (offset < 0 || offset + length > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        Spinner[] spinners = new Spinner[8];
        int n = 1;
        int i = 0;
        while (i < spinners.length) {
            spinners[i] = new Spinner((byte)n);
            Thread t = new Thread(spinners[i]);
            t.start();
            n <<= 1;
            ++i;
        }
        while (!(spinners[0].running || spinners[1].running || spinners[2].running || spinners[3].running || spinners[4].running || spinners[5].running || spinners[6].running || spinners[7].running)) {
            Thread.yield();
        }
        i = offset;
        while (i < length) {
            buffer[i] = (byte)(spinners[0].value ^ spinners[1].value ^ spinners[2].value ^ spinners[3].value ^ spinners[4].value ^ spinners[5].value ^ spinners[6].value ^ spinners[7].value);
            Thread.yield();
            ++i;
        }
        i = 0;
        while (i < spinners.length) {
            spinners[i].stop();
            ++i;
        }
        return length;
    }

    static class Spinner
    implements Runnable {
        volatile byte value;
        volatile boolean running;

        Spinner(byte initial) {
            this.value = initial;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                this.value = (byte)(this.value + 1);
            }
        }

        private void stop() {
            this.running = false;
        }
    }
}

