/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.activation;

import gnu.java.rmi.server.ActivatableServerRef;
import gnu.java.rmi.server.UnicastServer;
import gnu.java.rmi.server.UnicastServerRef;
import java.lang.reflect.Field;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.rmi.activation.UnknownGroupException;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.UnicastRemoteObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Activatable
extends RemoteServer {
    static final long serialVersionUID = -3120617863591563455L;
    final ActivationID id;

    protected Activatable(String codebase, MarshalledObject<?> data, boolean restart, int port) throws ActivationException, RemoteException {
        ActivationDesc descriptor = new ActivationDesc(this.getClass().getName(), codebase, data, restart);
        this.id = Activatable.obtainId(descriptor);
        Activatable.exportObject((Remote)this, this.id, port);
    }

    protected Activatable(String codebase, MarshalledObject<?> data, boolean restart, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws ActivationException, RemoteException {
        ActivationDesc descriptor = new ActivationDesc(this.getClass().getName(), codebase, data, restart);
        this.id = Activatable.obtainId(descriptor);
        Activatable.exportObject((Remote)this, this.id, port);
    }

    protected Activatable(ActivationID anId, int port) throws RemoteException {
        this.id = anId;
        try {
            Activatable.exportObject((Remote)this, anId, port);
        }
        catch (Exception e) {
            e.printStackTrace();
            RemoteException acex = new RemoteException("cannot export Activatable", e);
            throw acex;
        }
    }

    protected Activatable(ActivationID anId, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        this.id = anId;
        try {
            Activatable.exportObject((Remote)this, anId, port, csf, ssf);
        }
        catch (Exception e) {
            RemoteException acex = new RemoteException();
            acex.initCause(e);
            throw acex;
        }
    }

    protected ActivationID getID() {
        return this.id;
    }

    static ActivationID obtainId(ActivationDesc descriptor) throws RemoteException, UnknownGroupException, ActivationException {
        ActivationGroupID id = descriptor.getGroupID();
        ActivationSystem system = id != null ? id.getSystem() : ActivationGroup.currentGroupID().getSystem();
        return system.registerObject(descriptor);
    }

    public static Remote register(ActivationDesc desc) throws UnknownGroupException, ActivationException, RemoteException {
        ActivationID id = Activatable.obtainId(desc);
        try {
            return Activatable.toStub(id, Thread.currentThread().getContextClassLoader().loadClass(desc.getClassName()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ActivationException("Class not found: " + desc.getClassName());
        }
    }

    public static boolean inactive(ActivationID id) throws UnknownObjectException, ActivationException, RemoteException {
        if (id.group != null) {
            id.group.inactiveObject(id);
        }
        return UnicastRemoteObject.unexportObject(id.activate(false), false);
    }

    public static void unregister(ActivationID id) throws UnknownObjectException, ActivationException, RemoteException {
        ActivationGroup.currentGroupId.getSystem().unregisterObject(id);
        UnicastServer.unregisterActivatable(id);
    }

    public static ActivationID exportObject(Remote obj, String location, MarshalledObject<?> data, boolean restart, int port) throws ActivationException, RemoteException {
        ActivationDesc descriptor = new ActivationDesc(obj.getClass().getName(), location, data, restart);
        ActivationID id = Activatable.obtainId(descriptor);
        Activatable.exportObject(obj, id, port);
        return id;
    }

    public static ActivationID exportObject(Remote obj, String location, MarshalledObject data, boolean restart, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws ActivationException, RemoteException {
        ActivationDesc descriptor = new ActivationDesc(obj.getClass().getName(), location, data, restart);
        ActivationID id = Activatable.obtainId(descriptor);
        Activatable.exportObject(obj, id, port, csf, ssf);
        return id;
    }

    public static Remote exportObject(Remote obj, ActivationID id, int port) throws RemoteException {
        Remote stub = Activatable.export(id, obj, port, null);
        return stub;
    }

    public static Remote exportObject(Remote obj, ActivationID id, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        Remote stub = Activatable.export(id, obj, port, ssf);
        return stub;
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        UnicastServerRef aref = UnicastServer.getExportedRef(obj);
        if (aref instanceof ActivatableServerRef) {
            ActivatableServerRef aar = (ActivatableServerRef)aref;
            UnicastServer.unregisterActivatable(aar.actId);
        }
        return UnicastRemoteObject.unexportObject(obj, force);
    }

    static Remote exportObject(Remote obj, int port, RMIServerSocketFactory serverSocketFactory) throws RemoteException {
        UnicastServerRef sref = null;
        if (obj instanceof RemoteObject) {
            sref = (UnicastServerRef)((RemoteObject)obj).getRef();
        }
        if (sref == null) {
            sref = new UnicastServerRef(new ObjID(), port, serverSocketFactory);
        }
        Remote stub = sref.exportObject(obj);
        return stub;
    }

    public static Remote export(ActivationID id, Remote obj, int port, RMIServerSocketFactory serverSocketFactory) throws RemoteException {
        ActivatableServerRef sref = null;
        sref = new ActivatableServerRef(Activatable.makeId(id), id, port, serverSocketFactory);
        return sref.exportObject(obj);
    }

    public static ObjID makeId(ActivationID aid) {
        ObjID id = new ObjID(0);
        try {
            Field idUid = ObjID.class.getDeclaredField("space");
            Field aidUid = ActivationID.class.getDeclaredField("uid");
            aidUid.setAccessible(true);
            idUid.setAccessible(true);
            idUid.set(id, aidUid.get(aid));
        }
        catch (Exception e) {
            InternalError ierr = new InternalError("Unable to set UID field");
            ierr.initCause(e);
            throw ierr;
        }
        return id;
    }

    static Remote toStub(ActivationID anId, Class stubFor) {
        try {
            ActivatableServerRef asr = new ActivatableServerRef(Activatable.makeId(anId), anId, 0, null);
            UnicastServer.exportActivatableObject(asr);
            return asr.exportClass(stubFor);
        }
        catch (RemoteException e) {
            InternalError ierr = new InternalError("Failed to obtain activatable stub");
            ierr.initCause(e);
            throw ierr;
        }
    }
}

