/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Enum<T extends Enum<T>>
implements Comparable<T>,
Serializable {
    private static final long serialVersionUID = -4300926546619394005L;
    final String name;
    final int ordinal;

    protected Enum(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    public static <S extends Enum<S>> S valueOf(Class<S> etype, String s) {
        if (etype == null || s == null) {
            throw new NullPointerException();
        }
        try {
            Field f = etype.getDeclaredField(s);
            if (!f.isEnumConstant()) {
                throw new IllegalArgumentException(s);
            }
            Class.setAccessible(f);
            return (S)((Enum)f.get(null));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException(s);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Unable to access Enum class");
        }
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public final int compareTo(T e) {
        if (this.getDeclaringClass() != ((Enum)e).getDeclaringClass()) {
            throw new ClassCastException();
        }
        return this.ordinal - ((Enum)e).ordinal;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("can't clone an enum constant");
    }

    public final String name() {
        return this.name;
    }

    public final int ordinal() {
        return this.ordinal;
    }

    public final Class<T> getDeclaringClass() {
        Class<? extends Object> k = this.getClass();
        if (k.getSuperclass() != Enum.class) {
            k = k.getSuperclass();
        }
        return k;
    }

    protected final void finalize() {
    }
}

