/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.Encoder;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.PropertyDescriptor;
import java.beans.Statement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistenceDelegate
extends PersistenceDelegate {
    private String[] constructorPropertyNames;

    public DefaultPersistenceDelegate() {
    }

    public DefaultPersistenceDelegate(String[] constructorPropertyNames) {
        this.constructorPropertyNames = constructorPropertyNames;
    }

    @Override
    protected boolean mutatesTo(Object oldInstance, Object newInstance) {
        try {
            return this.constructorPropertyNames != null && this.constructorPropertyNames.length > 0 && oldInstance.getClass().getDeclaredMethod("equals", Object.class) != null ? oldInstance.equals(newInstance) : super.mutatesTo(oldInstance, newInstance);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return super.mutatesTo(oldInstance, newInstance);
        }
    }

    @Override
    protected Expression instantiate(Object oldInstance, Encoder out) {
        Object[] args = null;
        try {
            if (this.constructorPropertyNames != null) {
                args = new Object[this.constructorPropertyNames.length];
                PropertyDescriptor[] propertyDescs = Introspector.getBeanInfo(oldInstance.getClass()).getPropertyDescriptors();
                int i = 0;
                while (i < this.constructorPropertyNames.length) {
                    int j = 0;
                    while (j < propertyDescs.length) {
                        if (propertyDescs[i].getName().equals(this.constructorPropertyNames[i])) {
                            Method readMethod = propertyDescs[i].getReadMethod();
                            args[i] = readMethod.invoke(oldInstance, null);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        catch (IllegalAccessException iae) {
            out.getExceptionListener().exceptionThrown(iae);
        }
        catch (IllegalArgumentException iarge) {
            out.getExceptionListener().exceptionThrown(iarge);
        }
        catch (InvocationTargetException ite) {
            out.getExceptionListener().exceptionThrown(ite);
        }
        catch (IntrospectionException ie) {
            out.getExceptionListener().exceptionThrown(ie);
        }
        return new Expression(oldInstance, oldInstance.getClass(), "new", args);
    }

    @Override
    protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        super.initialize(type, oldInstance, newInstance, out);
        if (type != oldInstance.getClass()) {
            return;
        }
        try {
            PropertyDescriptor[] propertyDescs = Introspector.getBeanInfo(oldInstance.getClass()).getPropertyDescriptors();
            int i = 0;
            while (i < propertyDescs.length) {
                Object oldValue;
                Method readMethod = propertyDescs[i].getReadMethod();
                Method writeMethod = propertyDescs[i].getWriteMethod();
                if (readMethod != null && writeMethod != null && (oldValue = readMethod.invoke(oldInstance, null)) != null) {
                    out.writeStatement(new Statement(oldInstance, writeMethod.getName(), new Object[]{oldValue}));
                }
                ++i;
            }
        }
        catch (IntrospectionException ie) {
            out.getExceptionListener().exceptionThrown(ie);
        }
        catch (IllegalAccessException iae) {
            out.getExceptionListener().exceptionThrown(iae);
        }
        catch (InvocationTargetException ite) {
            out.getExceptionListener().exceptionThrown(ite);
        }
    }
}

