/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import gnu.xml.xpath.Pattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class UnionExpr
extends Pattern {
    final Expr lhs;
    final Expr rhs;

    public UnionExpr(Expr lhs, Expr rhs) {
        this.lhs = lhs;
        this.rhs = rhs;
    }

    public boolean matches(Node context) {
        if (this.lhs instanceof Pattern && this.rhs instanceof Pattern) {
            return ((Pattern)this.lhs).matches(context) || ((Pattern)this.rhs).matches(context);
        }
        return false;
    }

    public Object evaluate(Node context, int pos, int len) {
        Object left = this.lhs.evaluate(context, pos, len);
        Object right = this.rhs.evaluate(context, pos, len);
        if (left instanceof Collection && right instanceof Collection) {
            HashSet set = new HashSet();
            set.addAll((Collection)left);
            set.addAll((Collection)right);
            ArrayList list2 = new ArrayList(set);
            Collections.sort(list2, documentOrderComparator);
            return list2;
        }
        return Collections.EMPTY_SET;
    }

    public Expr clone(Object context) {
        return new UnionExpr(this.lhs.clone(context), this.rhs.clone(context));
    }

    public boolean references(QName var) {
        return this.lhs.references(var) || this.rhs.references(var);
    }

    public String toString() {
        return this.lhs + " | " + this.rhs;
    }
}

