/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.util;

import java.io.BufferedWriter;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.LocatorImpl;

public class XMLWriter
implements ContentHandler,
LexicalHandler,
DTDHandler,
DeclHandler {
    private static final int CTX_ENTITY = 1;
    private static final int CTX_ATTRIBUTE = 2;
    private static final int CTX_CONTENT = 3;
    private static final int CTX_UNPARSED = 4;
    private static final int CTX_NAME = 5;
    private static String sysEOL;
    private Writer out;
    private boolean inCDATA;
    private int elementNestLevel;
    private String eol = sysEOL;
    private short dangerMask;
    private StringBuffer stringBuf;
    private Locator locator;
    private ErrorHandler errHandler;
    private boolean expandingEntities = false;
    private int entityNestLevel;
    private boolean xhtml;
    private boolean startedDoctype;
    private String encoding;
    private boolean canonical;
    private boolean inDoctype;
    private boolean inEpilogue;
    private boolean prettyPrinting;
    private int column;
    private boolean noWrap;
    private Stack space = new Stack();
    private static final int lineLength = 75;
    private static final String xhtmlFullDTD = "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd";
    private static final String[] HTMLlat1x;
    private static final String[] HTMLsymbolx_GR;
    private static final String[] HTMLsymbolx_gr;

    static {
        try {
            sysEOL = System.getProperty("line.separator", "\n");
            if (!XMLWriter.isLineEnd(sysEOL)) {
                sysEOL = "\n";
            }
        }
        catch (SecurityException securityException) {
            sysEOL = "\n";
        }
        HTMLlat1x = new String[]{"nbsp", "iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
        String[] stringArray = new String[25];
        stringArray[0] = "Alpha";
        stringArray[1] = "Beta";
        stringArray[2] = "Gamma";
        stringArray[3] = "Delta";
        stringArray[4] = "Epsilon";
        stringArray[5] = "Zeta";
        stringArray[6] = "Eta";
        stringArray[7] = "Theta";
        stringArray[8] = "Iota";
        stringArray[9] = "Kappa";
        stringArray[10] = "Lambda";
        stringArray[11] = "Mu";
        stringArray[12] = "Nu";
        stringArray[13] = "Xi";
        stringArray[14] = "Omicron";
        stringArray[15] = "Pi";
        stringArray[16] = "Rho";
        stringArray[18] = "Sigma";
        stringArray[19] = "Tau";
        stringArray[20] = "Upsilon";
        stringArray[21] = "Phi";
        stringArray[22] = "Chi";
        stringArray[23] = "Psi";
        stringArray[24] = "Omega";
        HTMLsymbolx_GR = stringArray;
        HTMLsymbolx_gr = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "omicron", "pi", "rho", "sigmaf", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
    }

    private static boolean isLineEnd(String eol) {
        return "\n".equals(eol) || "\r".equals(eol) || "\r\n".equals(eol);
    }

    public XMLWriter() throws IOException {
        this(System.out);
    }

    public XMLWriter(OutputStream out) throws IOException {
        this(new OutputStreamWriter(out, "UTF8"));
    }

    public XMLWriter(Writer writer) {
        this(writer, null);
    }

    public XMLWriter(Writer writer, String encoding) {
        this.setWriter(writer, encoding);
    }

    private void setEncoding(String encoding) {
        if (encoding == null && this.out instanceof OutputStreamWriter) {
            encoding = ((OutputStreamWriter)this.out).getEncoding();
        }
        if (encoding != null) {
            if ("UTF8".equals(encoding = encoding.toUpperCase())) {
                encoding = "UTF-8";
            } else if ("US-ASCII".equals(encoding) || "ASCII".equals(encoding)) {
                this.dangerMask = (short)-128;
                encoding = "US-ASCII";
            } else if ("ISO-8859-1".equals(encoding) || "8859_1".equals(encoding) || "ISO8859_1".equals(encoding)) {
                this.dangerMask = (short)-256;
                encoding = "ISO-8859-1";
            } else if ("UNICODE".equals(encoding) || "UNICODE-BIG".equals(encoding) || "UNICODE-LITTLE".equals(encoding)) {
                encoding = "UTF-16";
            }
            if (this.dangerMask != 0) {
                this.stringBuf = new StringBuffer();
            }
        }
        this.encoding = encoding;
    }

    public final void setWriter(Writer writer, String encoding) {
        if (this.out != null) {
            throw new IllegalStateException("can't change stream in mid course");
        }
        this.out = writer;
        if (this.out != null) {
            this.setEncoding(encoding);
        }
        if (!(this.out instanceof BufferedWriter)) {
            this.out = new BufferedWriter(this.out);
        }
        this.space.push("default");
    }

    public final void setEOL(String eolString) {
        if (eolString == null) {
            this.eol = sysEOL;
        } else if (!XMLWriter.isLineEnd(eolString)) {
            this.eol = eolString;
        } else {
            throw new IllegalArgumentException(eolString);
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.errHandler = handler;
    }

    protected void fatal(String message, Exception e) throws SAXException {
        SAXParseException x = this.locator == null ? new SAXParseException(message, null, null, -1, -1, e) : new SAXParseException(message, this.locator, e);
        if (this.errHandler != null) {
            this.errHandler.fatalError(x);
        }
        throw x;
    }

    public final void setXhtml(boolean value) {
        if (this.locator != null) {
            throw new IllegalStateException("started parsing");
        }
        this.xhtml = value;
        if (this.xhtml) {
            this.canonical = false;
        }
    }

    public final boolean isXhtml() {
        return this.xhtml;
    }

    public final void setExpandingEntities(boolean value) {
        if (this.locator != null) {
            throw new IllegalStateException("started parsing");
        }
        this.expandingEntities = value;
        if (!this.expandingEntities) {
            this.canonical = false;
        }
    }

    public final boolean isExpandingEntities() {
        return this.expandingEntities;
    }

    public final void setPrettyPrinting(boolean value) {
        if (this.locator != null) {
            throw new IllegalStateException("started parsing");
        }
        this.prettyPrinting = value;
        if (this.prettyPrinting) {
            this.canonical = false;
        }
    }

    public final boolean isPrettyPrinting() {
        return this.prettyPrinting;
    }

    public final void setCanonical(boolean value) {
        if (value && !"UTF-8".equals(this.encoding)) {
            throw new IllegalArgumentException("encoding != UTF-8");
        }
        this.canonical = value;
        if (this.canonical) {
            this.xhtml = false;
            this.prettyPrinting = false;
            this.expandingEntities = true;
            this.eol = "\n";
        }
    }

    public final boolean isCanonical() {
        return this.canonical;
    }

    public final void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    public final void write(String data) throws SAXException {
        char[] buf = data.toCharArray();
        this.characters(buf, 0, buf.length);
    }

    public void writeElement(String uri, String localName, String qName, Attributes atts, String content) throws SAXException {
        if (content == null || content.length() == 0) {
            this.writeEmptyElement(uri, localName, qName, atts);
            return;
        }
        this.startElement(uri, localName, qName, atts);
        char[] chars = content.toCharArray();
        this.characters(chars, 0, chars.length);
        this.endElement(uri, localName, qName);
    }

    public void writeElement(String uri, String localName, String qName, Attributes atts, int content) throws SAXException {
        this.writeElement(uri, localName, qName, atts, Integer.toString(content));
    }

    public final void setDocumentLocator(Locator l) {
        this.locator = l;
    }

    public void startDocument() throws SAXException {
        try {
            if (this.out == null) {
                throw new IllegalStateException("null Writer given to XMLWriter");
            }
            if (this.locator == null) {
                this.locator = new LocatorImpl();
            }
            if (!this.canonical && this.dangerMask != -128 && this.encoding != null) {
                this.rawWrite("<?xml version='1.0'");
                this.rawWrite(" encoding='" + this.encoding + "'");
                this.rawWrite("?>");
                this.newline();
            }
            if (this.xhtml) {
                this.rawWrite("<!DOCTYPE html PUBLIC");
                this.newline();
                this.rawWrite("  '-//W3C//DTD XHTML 1.0 Transitional//EN'");
                this.newline();
                this.rawWrite("  '");
                this.rawWrite(xhtmlFullDTD);
                this.rawWrite("'>");
                this.newline();
                this.newline();
                this.startedDoctype = true;
            }
            this.entityNestLevel = 0;
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            if (!this.canonical) {
                this.newline();
                this.newline();
            }
            this.out.close();
            this.out = null;
            this.locator = null;
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    private static final boolean isEmptyElementTag(String tag) {
        switch (tag.charAt(0)) {
            case 'a': {
                return "area".equals(tag);
            }
            case 'b': {
                return "base".equals(tag) || "basefont".equals(tag) || "br".equals(tag);
            }
            case 'c': {
                return "col".equals(tag);
            }
            case 'f': {
                return "frame".equals(tag);
            }
            case 'h': {
                return "hr".equals(tag);
            }
            case 'i': {
                return "img".equals(tag) || "input".equals(tag) || "isindex".equals(tag);
            }
            case 'l': {
                return "link".equals(tag);
            }
            case 'm': {
                return "meta".equals(tag);
            }
            case 'p': {
                return "param".equals(tag);
            }
        }
        return false;
    }

    private static boolean indentBefore(String tag) {
        switch (tag.charAt(0)) {
            case 'a': {
                return "applet".equals(tag);
            }
            case 'b': {
                return "body".equals(tag) || "blockquote".equals(tag);
            }
            case 'c': {
                return "center".equals(tag);
            }
            case 'f': {
                return "frame".equals(tag) || "frameset".equals(tag);
            }
            case 'h': {
                return "head".equals(tag);
            }
            case 'm': {
                return "meta".equals(tag);
            }
            case 'o': {
                return "object".equals(tag);
            }
            case 'p': {
                return "param".equals(tag) || "pre".equals(tag);
            }
            case 's': {
                return "style".equals(tag);
            }
            case 't': {
                return "title".equals(tag) || "td".equals(tag) || "th".equals(tag);
            }
        }
        return false;
    }

    private static boolean spaceBefore(String tag) {
        switch (tag.charAt(0)) {
            case 'h': {
                return "h1".equals(tag) || "h2".equals(tag) || "h3".equals(tag) || "h4".equals(tag) || "h5".equals(tag) || "h6".equals(tag) || "hr".equals(tag);
            }
            case 'l': {
                return "li".equals(tag);
            }
            case 'o': {
                return "ol".equals(tag);
            }
            case 'p': {
                return "p".equals(tag);
            }
            case 't': {
                return "table".equals(tag) || "tr".equals(tag);
            }
            case 'u': {
                return "ul".equals(tag);
            }
        }
        return false;
    }

    private static boolean spacePreserve(String tag) {
        return "pre".equals(tag) || "style".equals(tag) || "script".equals(tag);
    }

    public final void startPrefixMapping(String prefix, String uri) {
    }

    public final void endPrefixMapping(String prefix) {
    }

    private void writeStartTag(String name, Attributes atts, boolean isEmpty) throws SAXException, IOException {
        this.rawWrite('<');
        this.rawWrite(name);
        if (atts != null && atts.getLength() != 0) {
            int[] indices = new int[atts.getLength()];
            int i = 0;
            while (i < indices.length) {
                indices[i] = i;
                ++i;
            }
            if (this.canonical || this.prettyPrinting) {
                i = 1;
                while (i < indices.length) {
                    int n = indices[i];
                    String s = atts.getQName(n);
                    int j = i - 1;
                    while (j >= 0) {
                        if (s.compareTo(atts.getQName(indices[j])) >= 0) break;
                        indices[j + 1] = indices[j];
                        --j;
                    }
                    indices[j + 1] = n;
                    ++i;
                }
            }
            i = 0;
            while (i < indices.length) {
                String s = atts.getQName(indices[i]);
                if (s == null || "".equals(s)) {
                    throw new IllegalArgumentException("no XML name");
                }
                this.rawWrite(" ");
                this.rawWrite(s);
                this.rawWrite("=");
                this.writeQuotedValue(atts.getValue(indices[i]), 2);
                ++i;
            }
        }
        if (isEmpty) {
            this.rawWrite(" /");
        }
        this.rawWrite('>');
    }

    public final void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.startedDoctype = false;
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (qName == null || "".equals(qName)) {
            throw new IllegalArgumentException("no XML name");
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.prettyPrinting) {
                String whitespace = null;
                if (this.xhtml && XMLWriter.spacePreserve(qName)) {
                    whitespace = "preserve";
                } else if (atts != null) {
                    whitespace = atts.getValue("xml:space");
                }
                if (whitespace == null) {
                    whitespace = (String)this.space.peek();
                }
                this.space.push(whitespace);
                if ("default".equals(whitespace)) {
                    if (this.xhtml) {
                        if (XMLWriter.spaceBefore(qName)) {
                            this.newline();
                            this.doIndent();
                        } else if (XMLWriter.indentBefore(qName)) {
                            this.doIndent();
                        }
                    } else {
                        this.doIndent();
                    }
                }
            }
            ++this.elementNestLevel;
            this.writeStartTag(qName, atts, this.xhtml && XMLWriter.isEmptyElementTag(qName));
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public void writeEmptyElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.canonical) {
            this.startElement(uri, localName, qName, atts);
            this.endElement(uri, localName, qName);
        } else {
            try {
                this.writeStartTag(qName, atts, true);
            }
            catch (IOException e) {
                this.fatal("can't write", e);
            }
        }
    }

    public final void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName == null || "".equals(qName)) {
            throw new IllegalArgumentException("no XML name");
        }
        try {
            --this.elementNestLevel;
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.xhtml && XMLWriter.isEmptyElementTag(qName)) {
                return;
            }
            this.rawWrite("</");
            this.rawWrite(qName);
            this.rawWrite('>');
            if (this.prettyPrinting) {
                if (!this.space.empty()) {
                    this.space.pop();
                } else {
                    this.fatal("stack discipline", null);
                }
            }
            if (this.elementNestLevel == 0) {
                this.inEpilogue = true;
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.inCDATA) {
                this.escapeChars(ch, start, length, 4);
            } else {
                this.escapeChars(ch, start, length, 3);
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            this.escapeChars(ch, start, length, 3);
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void processingInstruction(String target, String data) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.xhtml && this.startedDoctype) {
            return;
        }
        try {
            if (this.entityNestLevel != 0) {
                return;
            }
            if (this.canonical && this.inEpilogue) {
                this.newline();
            }
            this.rawWrite("<?");
            this.rawWrite(target);
            this.rawWrite(' ');
            this.escapeChars(data.toCharArray(), -1, -1, 4);
            this.rawWrite("?>");
            if (!(this.elementNestLevel != 0 || this.canonical && this.inEpilogue)) {
                this.newline();
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            this.rawWrite("&");
            this.rawWrite(name);
            this.rawWrite(";");
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void startCDATA() throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.canonical) {
            return;
        }
        try {
            this.inCDATA = true;
            if (this.entityNestLevel == 0) {
                this.rawWrite("<![CDATA[");
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void endCDATA() throws SAXException {
        if (this.canonical) {
            return;
        }
        try {
            this.inCDATA = false;
            if (this.entityNestLevel == 0) {
                this.rawWrite("]]>");
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.xhtml) {
            return;
        }
        try {
            this.startedDoctype = true;
            this.inDoctype = true;
            if (this.canonical) {
                return;
            }
            this.rawWrite("<!DOCTYPE ");
            this.rawWrite(name);
            this.rawWrite(' ');
            if (!this.expandingEntities) {
                if (publicId != null) {
                    this.rawWrite("PUBLIC '" + publicId + "' '" + systemId + "' ");
                } else if (systemId != null) {
                    this.rawWrite("SYSTEM '" + systemId + "' ");
                }
            }
            this.rawWrite('[');
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void endDTD() throws SAXException {
        this.inDoctype = false;
        if (this.canonical || this.xhtml) {
            return;
        }
        try {
            this.rawWrite("]>");
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void startEntity(String name) throws SAXException {
        try {
            boolean writeEOL = true;
            if (this.xhtml || this.expandingEntities) {
                return;
            }
            ++this.entityNestLevel;
            if (name.equals("[dtd]")) {
                return;
            }
            if (this.entityNestLevel != 1) {
                return;
            }
            if (!name.startsWith("%")) {
                writeEOL = false;
                this.rawWrite('&');
            }
            this.rawWrite(name);
            this.rawWrite(';');
            if (writeEOL) {
                this.newline();
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void endEntity(String name) throws SAXException {
        if (this.xhtml || this.expandingEntities) {
            return;
        }
        --this.entityNestLevel;
    }

    public final void comment(char[] ch, int start, int length) throws SAXException {
        if (this.locator == null) {
            this.locator = new LocatorImpl();
        }
        if (this.xhtml && this.startedDoctype) {
            return;
        }
        if (this.canonical && this.inDoctype) {
            return;
        }
        try {
            boolean indent;
            if (this.prettyPrinting && this.space.empty()) {
                this.fatal("stack discipline", null);
            }
            boolean bl = indent = this.prettyPrinting && "default".equals(this.space.peek());
            if (this.entityNestLevel != 0) {
                return;
            }
            if (indent) {
                this.doIndent();
            }
            if (this.canonical && this.inEpilogue) {
                this.newline();
            }
            this.rawWrite("<!--");
            this.escapeChars(ch, start, length, 4);
            this.rawWrite("-->");
            if (indent) {
                this.doIndent();
            }
            if (!(this.elementNestLevel != 0 || this.canonical && this.inEpilogue)) {
                this.newline();
            }
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!NOTATION " + name + " ");
            if (publicId != null) {
                this.rawWrite("PUBLIC \"" + publicId + '\"');
            } else {
                this.rawWrite("SYSTEM ");
            }
            if (systemId != null) {
                this.rawWrite(String.valueOf('\"') + systemId + '\"');
            }
            this.rawWrite(">");
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ENTITY " + name + " ");
            if (publicId != null) {
                this.rawWrite("PUBLIC \"" + publicId + '\"');
            } else {
                this.rawWrite("SYSTEM ");
            }
            this.rawWrite(String.valueOf('\"') + systemId + '\"');
            this.rawWrite(" NDATA " + notationName + ">");
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ATTLIST " + eName + ' ' + aName + ' ');
            this.rawWrite(type);
            this.rawWrite(' ');
            if (mode != null) {
                this.rawWrite(String.valueOf(mode) + ' ');
            }
            if (value != null) {
                this.writeQuotedValue(value, 2);
            }
            this.rawWrite('>');
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void elementDecl(String name, String model) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ELEMENT " + name + ' ' + model + '>');
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ENTITY ");
            if (name.startsWith("%")) {
                this.rawWrite("% ");
                this.rawWrite(name.substring(1));
            } else {
                this.rawWrite(name);
            }
            if (publicId != null) {
                this.rawWrite(" PUBLIC \"" + publicId + '\"');
            } else {
                this.rawWrite(" SYSTEM ");
            }
            this.rawWrite(String.valueOf('\"') + systemId + "\">");
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    public final void internalEntityDecl(String name, String value) throws SAXException {
        if (this.xhtml) {
            return;
        }
        try {
            if (!this.startedDoctype) {
                return;
            }
            if (this.entityNestLevel != 0) {
                return;
            }
            this.rawWrite("<!ENTITY ");
            if (name.startsWith("%")) {
                this.rawWrite("% ");
                this.rawWrite(name.substring(1));
            } else {
                this.rawWrite(name);
            }
            this.rawWrite(' ');
            this.writeQuotedValue(value, 1);
            this.rawWrite('>');
            this.newline();
        }
        catch (IOException e) {
            this.fatal("can't write", e);
        }
    }

    private void writeQuotedValue(String value, int code) throws SAXException, IOException {
        char[] buf = value.toCharArray();
        int off = 0;
        int len = buf.length;
        this.noWrap = true;
        this.rawWrite('\"');
        this.escapeChars(buf, off, len, code);
        this.rawWrite('\"');
        this.noWrap = false;
    }

    private void escapeChars(char[] buf, int off, int len, int code) throws SAXException, IOException {
        int first = 0;
        if (off < 0) {
            off = 0;
            len = buf.length;
        }
        int i = 0;
        while (i < len) {
            block132: {
                String esc;
                char c = buf[off + i];
                switch (c) {
                    case '&': {
                        if (code != 1 && code != 4) {
                            esc = "amp";
                            break;
                        }
                        break block132;
                    }
                    case '<': {
                        if (code != 1 && code != 4) {
                            esc = "lt";
                            break;
                        }
                        break block132;
                    }
                    case '>': {
                        if (code != 1 && code != 4) {
                            esc = "gt";
                            break;
                        }
                        break block132;
                    }
                    case '\'': {
                        if (code != 3 && code != 4 && !this.canonical) {
                            esc = "apos";
                            break;
                        }
                        break block132;
                    }
                    case '\"': {
                        if (code != 3 && code != 4) {
                            esc = "quot";
                            break;
                        }
                        break block132;
                    }
                    case '\n': {
                        esc = this.eol;
                        break;
                    }
                    default: {
                        if (c > '\ufffd' || c < ' ' && c != '\t' && c != '\n' && c != '\r' || (c & this.dangerMask) != 0 && code == 4) {
                            throw new CharConversionException("Illegal or non-writable character: U+" + Integer.toHexString(c));
                        }
                        if ((c & this.dangerMask) == 0) break block132;
                        esc = null;
                        if (this.xhtml) {
                            if (c >= '\u00a0' && c <= '\u00ff') {
                                esc = HTMLlat1x[c - 160];
                            } else if (c >= '\u0391' && c <= '\u03a9') {
                                esc = HTMLsymbolx_GR[c - 913];
                            } else if (c >= '\u03b1' && c <= '\u03c9') {
                                esc = HTMLsymbolx_gr[c - 945];
                            } else {
                                switch (c) {
                                    case '\u0152': {
                                        esc = "OElig";
                                        break;
                                    }
                                    case '\u0153': {
                                        esc = "oelig";
                                        break;
                                    }
                                    case '\u0160': {
                                        esc = "Scaron";
                                        break;
                                    }
                                    case '\u0161': {
                                        esc = "scaron";
                                        break;
                                    }
                                    case '\u0178': {
                                        esc = "Yuml";
                                        break;
                                    }
                                    case '\u02c6': {
                                        esc = "circ";
                                        break;
                                    }
                                    case '\u02dc': {
                                        esc = "tilde";
                                        break;
                                    }
                                    case '\u2002': {
                                        esc = "ensp";
                                        break;
                                    }
                                    case '\u2003': {
                                        esc = "emsp";
                                        break;
                                    }
                                    case '\u2009': {
                                        esc = "thinsp";
                                        break;
                                    }
                                    case '\u200c': {
                                        esc = "zwnj";
                                        break;
                                    }
                                    case '\u200d': {
                                        esc = "zwj";
                                        break;
                                    }
                                    case '\u200e': {
                                        esc = "lrm";
                                        break;
                                    }
                                    case '\u200f': {
                                        esc = "rlm";
                                        break;
                                    }
                                    case '\u2013': {
                                        esc = "ndash";
                                        break;
                                    }
                                    case '\u2014': {
                                        esc = "mdash";
                                        break;
                                    }
                                    case '\u2018': {
                                        esc = "lsquo";
                                        break;
                                    }
                                    case '\u2019': {
                                        esc = "rsquo";
                                        break;
                                    }
                                    case '\u201a': {
                                        esc = "sbquo";
                                        break;
                                    }
                                    case '\u201c': {
                                        esc = "ldquo";
                                        break;
                                    }
                                    case '\u201d': {
                                        esc = "rdquo";
                                        break;
                                    }
                                    case '\u201e': {
                                        esc = "bdquo";
                                        break;
                                    }
                                    case '\u2020': {
                                        esc = "dagger";
                                        break;
                                    }
                                    case '\u2021': {
                                        esc = "Dagger";
                                        break;
                                    }
                                    case '\u2030': {
                                        esc = "permil";
                                        break;
                                    }
                                    case '\u2039': {
                                        esc = "lsaquo";
                                        break;
                                    }
                                    case '\u203a': {
                                        esc = "rsaquo";
                                        break;
                                    }
                                    case '\u20ac': {
                                        esc = "euro";
                                        break;
                                    }
                                    case '\u0192': {
                                        esc = "fnof";
                                        break;
                                    }
                                    case '\u03d1': {
                                        esc = "thetasym";
                                        break;
                                    }
                                    case '\u03d2': {
                                        esc = "upsih";
                                        break;
                                    }
                                    case '\u03d6': {
                                        esc = "piv";
                                        break;
                                    }
                                    case '\u2022': {
                                        esc = "bull";
                                        break;
                                    }
                                    case '\u2026': {
                                        esc = "hellip";
                                        break;
                                    }
                                    case '\u2032': {
                                        esc = "prime";
                                        break;
                                    }
                                    case '\u2033': {
                                        esc = "Prime";
                                        break;
                                    }
                                    case '\u203e': {
                                        esc = "oline";
                                        break;
                                    }
                                    case '\u2044': {
                                        esc = "frasl";
                                        break;
                                    }
                                    case '\u2118': {
                                        esc = "weierp";
                                        break;
                                    }
                                    case '\u2111': {
                                        esc = "image";
                                        break;
                                    }
                                    case '\u211c': {
                                        esc = "real";
                                        break;
                                    }
                                    case '\u2122': {
                                        esc = "trade";
                                        break;
                                    }
                                    case '\u2135': {
                                        esc = "alefsym";
                                        break;
                                    }
                                    case '\u2190': {
                                        esc = "larr";
                                        break;
                                    }
                                    case '\u2191': {
                                        esc = "uarr";
                                        break;
                                    }
                                    case '\u2192': {
                                        esc = "rarr";
                                        break;
                                    }
                                    case '\u2193': {
                                        esc = "darr";
                                        break;
                                    }
                                    case '\u2194': {
                                        esc = "harr";
                                        break;
                                    }
                                    case '\u21b5': {
                                        esc = "crarr";
                                        break;
                                    }
                                    case '\u21d0': {
                                        esc = "lArr";
                                        break;
                                    }
                                    case '\u21d1': {
                                        esc = "uArr";
                                        break;
                                    }
                                    case '\u21d2': {
                                        esc = "rArr";
                                        break;
                                    }
                                    case '\u21d3': {
                                        esc = "dArr";
                                        break;
                                    }
                                    case '\u21d4': {
                                        esc = "hArr";
                                        break;
                                    }
                                    case '\u2200': {
                                        esc = "forall";
                                        break;
                                    }
                                    case '\u2202': {
                                        esc = "part";
                                        break;
                                    }
                                    case '\u2203': {
                                        esc = "exist";
                                        break;
                                    }
                                    case '\u2205': {
                                        esc = "empty";
                                        break;
                                    }
                                    case '\u2207': {
                                        esc = "nabla";
                                        break;
                                    }
                                    case '\u2208': {
                                        esc = "isin";
                                        break;
                                    }
                                    case '\u2209': {
                                        esc = "notin";
                                        break;
                                    }
                                    case '\u220b': {
                                        esc = "ni";
                                        break;
                                    }
                                    case '\u220f': {
                                        esc = "prod";
                                        break;
                                    }
                                    case '\u2211': {
                                        esc = "sum";
                                        break;
                                    }
                                    case '\u2212': {
                                        esc = "minus";
                                        break;
                                    }
                                    case '\u2217': {
                                        esc = "lowast";
                                        break;
                                    }
                                    case '\u221a': {
                                        esc = "radic";
                                        break;
                                    }
                                    case '\u221d': {
                                        esc = "prop";
                                        break;
                                    }
                                    case '\u221e': {
                                        esc = "infin";
                                        break;
                                    }
                                    case '\u2220': {
                                        esc = "ang";
                                        break;
                                    }
                                    case '\u2227': {
                                        esc = "and";
                                        break;
                                    }
                                    case '\u2228': {
                                        esc = "or";
                                        break;
                                    }
                                    case '\u2229': {
                                        esc = "cap";
                                        break;
                                    }
                                    case '\u222a': {
                                        esc = "cup";
                                        break;
                                    }
                                    case '\u222b': {
                                        esc = "int";
                                        break;
                                    }
                                    case '\u2234': {
                                        esc = "there4";
                                        break;
                                    }
                                    case '\u223c': {
                                        esc = "sim";
                                        break;
                                    }
                                    case '\u2245': {
                                        esc = "cong";
                                        break;
                                    }
                                    case '\u2248': {
                                        esc = "asymp";
                                        break;
                                    }
                                    case '\u2260': {
                                        esc = "ne";
                                        break;
                                    }
                                    case '\u2261': {
                                        esc = "equiv";
                                        break;
                                    }
                                    case '\u2264': {
                                        esc = "le";
                                        break;
                                    }
                                    case '\u2265': {
                                        esc = "ge";
                                        break;
                                    }
                                    case '\u2282': {
                                        esc = "sub";
                                        break;
                                    }
                                    case '\u2283': {
                                        esc = "sup";
                                        break;
                                    }
                                    case '\u2284': {
                                        esc = "nsub";
                                        break;
                                    }
                                    case '\u2286': {
                                        esc = "sube";
                                        break;
                                    }
                                    case '\u2287': {
                                        esc = "supe";
                                        break;
                                    }
                                    case '\u2295': {
                                        esc = "oplus";
                                        break;
                                    }
                                    case '\u2297': {
                                        esc = "otimes";
                                        break;
                                    }
                                    case '\u22a5': {
                                        esc = "perp";
                                        break;
                                    }
                                    case '\u22c5': {
                                        esc = "sdot";
                                        break;
                                    }
                                    case '\u2308': {
                                        esc = "lceil";
                                        break;
                                    }
                                    case '\u2309': {
                                        esc = "rceil";
                                        break;
                                    }
                                    case '\u230a': {
                                        esc = "lfloor";
                                        break;
                                    }
                                    case '\u230b': {
                                        esc = "rfloor";
                                        break;
                                    }
                                    case '\u2329': {
                                        esc = "lang";
                                        break;
                                    }
                                    case '\u232a': {
                                        esc = "rang";
                                        break;
                                    }
                                    case '\u25ca': {
                                        esc = "loz";
                                        break;
                                    }
                                    case '\u2660': {
                                        esc = "spades";
                                        break;
                                    }
                                    case '\u2663': {
                                        esc = "clubs";
                                        break;
                                    }
                                    case '\u2665': {
                                        esc = "hearts";
                                        break;
                                    }
                                    case '\u2666': {
                                        esc = "diams";
                                    }
                                }
                            }
                        }
                        if (esc != null) break;
                        this.stringBuf.setLength(0);
                        this.stringBuf.append("#x");
                        this.stringBuf.append(Integer.toHexString(c).toUpperCase());
                        esc = this.stringBuf.toString();
                    }
                }
                if (i != first) {
                    this.rawWrite(buf, off + first, i - first);
                }
                first = i + 1;
                if (esc == this.eol) {
                    this.newline();
                } else {
                    this.rawWrite('&');
                    this.rawWrite(esc);
                    this.rawWrite(';');
                }
            }
            ++i;
        }
        if (first < len) {
            this.rawWrite(buf, off + first, len - first);
        }
    }

    private void newline() throws SAXException, IOException {
        this.out.write(this.eol);
        this.column = 0;
    }

    private void doIndent() throws SAXException, IOException {
        int space = this.elementNestLevel * 2;
        this.newline();
        this.column = space;
        while (space > 8) {
            this.out.write("\t");
            space -= 8;
        }
        while (space > 0) {
            this.out.write("  ");
            space -= 2;
        }
    }

    private void rawWrite(char c) throws IOException {
        this.out.write(c);
        ++this.column;
    }

    private void rawWrite(String s) throws SAXException, IOException {
        if (this.prettyPrinting && "default".equals(this.space.peek())) {
            char[] data = s.toCharArray();
            this.rawWrite(data, 0, data.length);
        } else {
            this.out.write(s);
            this.column += s.length();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void rawWrite(char[] buf, int offset, int length) throws SAXException, IOException {
        if (this.prettyPrinting && this.space.empty()) {
            this.fatal("stack discipline", null);
        }
        v0 = wrap = this.prettyPrinting != false && "default".equals(this.space.peek()) != false;
        if (wrap) ** GOTO lbl45
        this.out.write(buf, offset, length);
        this.column += length;
        return;
lbl-1000:
        // 1 sources

        {
            target = 75 - this.column;
            wrote = false;
            if (target > length || this.noWrap) {
                this.out.write(buf, offset, length);
                this.column += length;
                return;
            }
            i = target - 1;
            while (i >= 0) {
                c = buf[offset + i];
                if (c == ' ' || c == '\t') {
                    this.out.write(buf, offset, ++i);
                    this.doIndent();
                    offset += i;
                    length -= i;
                    wrote = true;
                    break;
                }
                --i;
            }
            if (wrote) continue;
            if (target < 0) {
                target = 0;
            }
            i = target;
            while (i < length) {
                c = buf[offset + i];
                if (c == ' ' || c == '\t') {
                    this.out.write(buf, offset, ++i);
                    this.doIndent();
                    offset += i;
                    length -= i;
                    wrote = true;
                    break;
                }
                ++i;
            }
            if (wrote) continue;
            this.out.write(buf, offset, length);
            this.column += length;
            break;
lbl45:
            // 3 sources

            ** while (length > 0)
        }
lbl46:
        // 2 sources

    }
}

