/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.xml.transform.ParameterNode;
import gnu.xml.transform.Stylesheet;
import gnu.xml.xpath.DocumentOrderComparator;
import java.io.PrintStream;
import java.util.Comparator;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Node;

abstract class TemplateNode {
    static final Comparator documentOrderComparator = new DocumentOrderComparator();
    TemplateNode children;
    TemplateNode next;

    TemplateNode() {
    }

    final void apply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        if (stylesheet.terminated) {
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (stylesheet.debug) {
            System.err.println("Applying " + this.toString());
            System.err.println("\twith context=" + context + ", pos=" + pos + ", len=" + len);
        }
        this.doApply(stylesheet, mode, context, pos, len, parent, nextSibling);
    }

    abstract void doApply(Stylesheet var1, QName var2, Node var3, int var4, int var5, Node var6, Node var7) throws TransformerException;

    abstract TemplateNode clone(Stylesheet var1);

    public boolean references(QName var) {
        if (this.children != null && this.children.references(var)) {
            return true;
        }
        return this.next != null && this.next.references(var);
    }

    void list(int depth, PrintStream out, boolean listNext) {
        int i = 0;
        while (i < depth) {
            out.print("  ");
            ++i;
        }
        out.println(this.toString());
        if (this.children != null) {
            this.children.list(depth + 1, out, true);
        }
        if (listNext && this.next != null) {
            this.next.list(depth, out, listNext);
        }
    }

    boolean hasParam(QName name) {
        TemplateNode ctx = this;
        while (ctx != null) {
            if (ctx instanceof ParameterNode) {
                ParameterNode param = (ParameterNode)ctx;
                if (param.type == 1 && param.name.equals(name)) {
                    return true;
                }
            }
            ctx = ctx.next;
        }
        return false;
    }
}

