/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.ClientDHE_PSKParameters;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.ClientPSKParameters;
import gnu.javax.net.ssl.provider.ClientRSA_PSKParameters;
import gnu.javax.net.ssl.provider.EmptyExchangeKeys;
import gnu.javax.net.ssl.provider.EncryptedPreMasterSecret;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.KeyExchangeAlgorithm;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ClientKeyExchange
implements Handshake.Body {
    protected ByteBuffer buffer;
    protected final CipherSuite suite;
    protected final ProtocolVersion version;

    public ClientKeyExchange(ByteBuffer buffer, CipherSuite suite, ProtocolVersion version) {
        suite.getClass();
        version.getClass();
        this.buffer = buffer.duplicate().order(ByteOrder.BIG_ENDIAN);
        this.suite = suite;
        this.version = version;
    }

    public ExchangeKeys exchangeKeys() {
        KeyExchangeAlgorithm alg = this.suite.keyExchangeAlgorithm();
        if (alg == KeyExchangeAlgorithm.RSA) {
            return new EncryptedPreMasterSecret(this.buffer, this.version);
        }
        if (alg == KeyExchangeAlgorithm.DH_anon || alg == KeyExchangeAlgorithm.DHE_DSS || alg == KeyExchangeAlgorithm.DHE_RSA) {
            return new ClientDiffieHellmanPublic(this.buffer.duplicate());
        }
        if (alg == KeyExchangeAlgorithm.DHE_PSK) {
            return new ClientDHE_PSKParameters(this.buffer.duplicate());
        }
        if (alg == KeyExchangeAlgorithm.PSK) {
            return new ClientPSKParameters(this.buffer.duplicate());
        }
        if (alg == KeyExchangeAlgorithm.RSA_PSK) {
            return new ClientRSA_PSKParameters(this.buffer.duplicate());
        }
        if (alg == KeyExchangeAlgorithm.NONE) {
            return new EmptyExchangeKeys();
        }
        throw new IllegalArgumentException("unsupported key exchange: " + (Object)((Object)alg));
    }

    public int length() {
        if (this.suite.keyExchangeAlgorithm() == KeyExchangeAlgorithm.NONE) {
            return 0;
        }
        return this.exchangeKeys().length();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(String prefix) {
        StringWriter str = new StringWriter();
        PrintWriter out = new PrintWriter(str);
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("struct {");
        String subprefix = "  ";
        if (prefix != null) {
            subprefix = String.valueOf(prefix) + subprefix;
        }
        out.println(this.exchangeKeys().toString(subprefix));
        if (prefix != null) {
            out.print(prefix);
        }
        out.println("} ClientKeyExchange;");
        return str.toString();
    }
}

