/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.ClientDiffieHellmanPublic;
import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.ExchangeKeys;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

public class ClientDHE_PSKParameters
extends ExchangeKeys
implements Builder,
Constructed {
    public ClientDHE_PSKParameters(ByteBuffer buffer) {
        super(buffer);
    }

    public ClientDHE_PSKParameters(String identity, ClientDiffieHellmanPublic dh) {
        super(null);
        Charset utf8 = Charset.forName("UTF-8");
        ByteBuffer idBuf = utf8.encode(identity);
        this.buffer = ByteBuffer.allocate(2 + idBuf.remaining() + dh.length());
        this.buffer.putShort((short)idBuf.remaining());
        this.buffer.put(idBuf);
        this.buffer.put(dh.buffer());
        this.buffer.rewind();
    }

    public ByteBuffer buffer() {
        return (ByteBuffer)this.buffer.duplicate().rewind().limit(this.length());
    }

    private int identityLength() {
        return (this.buffer.getShort(0) & 0xFFFF) + 2;
    }

    public String identity() {
        Charset utf8 = Charset.forName("UTF-8");
        return utf8.decode((ByteBuffer)this.buffer.duplicate().position(2).limit(this.identityLength())).toString();
    }

    public int length() {
        int length = (this.buffer.getShort(0) & 0xFFFF) + 2;
        length += (this.buffer.getShort(length) & 0xFFFF) + 2;
        return length;
    }

    public ClientDiffieHellmanPublic params() {
        return new ClientDiffieHellmanPublic(((ByteBuffer)this.buffer.duplicate().position(this.identityLength()).limit(this.length())).slice());
    }

    public String toString(String prefix) {
        return null;
    }
}

