/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REException;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;
import gnu.java.util.regex.RETokenPOSIX;

final class RETokenNamedProperty
extends REToken {
    String name;
    boolean insens;
    boolean negate;
    Handler handler;
    static final byte[] LETTER = new byte[]{2, 1, 3, 4, 5};
    static final byte[] MARK = new byte[]{6, 8, 7};
    static final byte[] SEPARATOR = new byte[]{12, 13, 14};
    static final byte[] SYMBOL = new byte[]{25, 26, 27, 28};
    static final byte[] NUMBER = new byte[]{9, 10, 11};
    static final byte[] PUNCTUATION = new byte[]{20, 21, 22, 23, 24, 29, 30};
    static final byte[] OTHER;

    static {
        byte[] byArray = new byte[5];
        byArray[0] = 15;
        byArray[1] = 16;
        byArray[2] = 18;
        byArray[3] = 19;
        OTHER = byArray;
    }

    RETokenNamedProperty(int subIndex, String name, boolean insens, boolean negate) throws REException {
        super(subIndex);
        this.name = name;
        this.insens = insens;
        this.negate = negate;
        this.handler = this.getHandler(name);
    }

    int getMinimumLength() {
        return 1;
    }

    int getMaximumLength() {
        return 1;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        char ch = input.charAt(mymatch.index);
        boolean retval = this.matchOneChar(ch);
        if (retval) {
            ++mymatch.index;
            return mymatch;
        }
        return null;
    }

    private boolean matchOneChar(char ch) {
        if (ch == '\uffff') {
            return false;
        }
        boolean retval = this.handler.includes(ch);
        if (this.insens) {
            boolean bl = retval = retval || this.handler.includes(RETokenNamedProperty.toUpperCase(ch, this.unicodeAware)) || this.handler.includes(RETokenNamedProperty.toLowerCase(ch, this.unicodeAware));
        }
        if (this.negate) {
            retval = !retval;
        }
        return retval;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        char ch;
        int numRepeats;
        int index = mymatch.index;
        for (numRepeats = 0; numRepeats < max && this.matchOneChar(ch = input.charAt(index++)); ++numRepeats) {
        }
        return numRepeats;
    }

    void dump(StringBuffer os) {
        os.append("\\").append(this.negate ? "P" : "p").append("{" + this.name + "}");
    }

    private Handler getHandler(String name) throws REException {
        if (name.equals("Lower") || name.equals("Upper") || name.equals("Alpha") || name.equals("Digit") || name.equals("Alnum") || name.equals("Punct") || name.equals("Graph") || name.equals("Print") || name.equals("Blank") || name.equals("Cntrl") || name.equals("XDigit") || name.equals("Space")) {
            return new POSIXHandler(name);
        }
        if (name.startsWith("In")) {
            try {
                name = name.substring(2);
                Character.UnicodeBlock block = Character.UnicodeBlock.forName(name);
                return new UnicodeBlockHandler(block);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new REException("Invalid Unicode block name: " + name, 10, 0);
            }
        }
        if (name.startsWith("Is")) {
            name = name.substring(2);
        }
        if (name.equals("L")) {
            return new UnicodeCategoriesHandler(LETTER);
        }
        if (name.equals("M")) {
            return new UnicodeCategoriesHandler(MARK);
        }
        if (name.equals("Z")) {
            return new UnicodeCategoriesHandler(SEPARATOR);
        }
        if (name.equals("S")) {
            return new UnicodeCategoriesHandler(SYMBOL);
        }
        if (name.equals("N")) {
            return new UnicodeCategoriesHandler(NUMBER);
        }
        if (name.equals("P")) {
            return new UnicodeCategoriesHandler(PUNCTUATION);
        }
        if (name.equals("C")) {
            return new UnicodeCategoriesHandler(OTHER);
        }
        if (name.equals("Mc")) {
            return new UnicodeCategoryHandler(8);
        }
        if (name.equals("Pc")) {
            return new UnicodeCategoryHandler(23);
        }
        if (name.equals("Cc")) {
            return new UnicodeCategoryHandler(15);
        }
        if (name.equals("Sc")) {
            return new UnicodeCategoryHandler(26);
        }
        if (name.equals("Pd")) {
            return new UnicodeCategoryHandler(20);
        }
        if (name.equals("Nd")) {
            return new UnicodeCategoryHandler(9);
        }
        if (name.equals("Me")) {
            return new UnicodeCategoryHandler(7);
        }
        if (name.equals("Pe")) {
            return new UnicodeCategoryHandler(22);
        }
        if (name.equals("Pf")) {
            return new UnicodeCategoryHandler(30);
        }
        if (name.equals("Cf")) {
            return new UnicodeCategoryHandler(16);
        }
        if (name.equals("Pi")) {
            return new UnicodeCategoryHandler(29);
        }
        if (name.equals("Nl")) {
            return new UnicodeCategoryHandler(10);
        }
        if (name.equals("Zl")) {
            return new UnicodeCategoryHandler(13);
        }
        if (name.equals("Ll")) {
            return new UnicodeCategoryHandler(2);
        }
        if (name.equals("Sm")) {
            return new UnicodeCategoryHandler(25);
        }
        if (name.equals("Lm")) {
            return new UnicodeCategoryHandler(4);
        }
        if (name.equals("Sk")) {
            return new UnicodeCategoryHandler(27);
        }
        if (name.equals("Mn")) {
            return new UnicodeCategoryHandler(6);
        }
        if (name.equals("Lo")) {
            return new UnicodeCategoryHandler(5);
        }
        if (name.equals("No")) {
            return new UnicodeCategoryHandler(11);
        }
        if (name.equals("Po")) {
            return new UnicodeCategoryHandler(24);
        }
        if (name.equals("So")) {
            return new UnicodeCategoryHandler(28);
        }
        if (name.equals("Zp")) {
            return new UnicodeCategoryHandler(14);
        }
        if (name.equals("Co")) {
            return new UnicodeCategoryHandler(18);
        }
        if (name.equals("Zs")) {
            return new UnicodeCategoryHandler(12);
        }
        if (name.equals("Ps")) {
            return new UnicodeCategoryHandler(21);
        }
        if (name.equals("Cs")) {
            return new UnicodeCategoryHandler(19);
        }
        if (name.equals("Lt")) {
            return new UnicodeCategoryHandler(3);
        }
        if (name.equals("Cn")) {
            return new UnicodeCategoryHandler(0);
        }
        if (name.equals("Lu")) {
            return new UnicodeCategoryHandler(1);
        }
        if (name.equals("all")) {
            return new Handler(){

                public boolean includes(char c) {
                    return true;
                }
            };
        }
        throw new REException("unsupported name " + name, 10, 0);
    }

    private static abstract class Handler {
        private Handler() {
        }

        public abstract boolean includes(char var1);
    }

    private static class POSIXHandler
    extends Handler {
        private RETokenPOSIX retoken;

        public POSIXHandler(String name) {
            int posixId = RETokenPOSIX.intValue(name.toLowerCase());
            if (posixId == -1) {
                throw new RuntimeException("Unknown posix ID: " + name);
            }
            this.retoken = new RETokenPOSIX(0, posixId, false, false);
        }

        public boolean includes(char c) {
            return this.retoken.matchOneChar(c);
        }
    }

    private static class UnicodeBlockHandler
    extends Handler {
        private Character.UnicodeBlock block;

        public UnicodeBlockHandler(Character.UnicodeBlock block) {
            this.block = block;
        }

        public boolean includes(char c) {
            Character.UnicodeBlock cblock = Character.UnicodeBlock.of(c);
            return cblock != null && cblock.equals(this.block);
        }
    }

    private static class UnicodeCategoriesHandler
    extends Handler {
        private byte[] categories;

        public UnicodeCategoriesHandler(byte[] categories) {
            this.categories = categories;
        }

        public boolean includes(char c) {
            int category = Character.getType(c);
            int i = 0;
            while (i < this.categories.length) {
                if (category == this.categories[i]) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class UnicodeCategoryHandler
    extends Handler {
        private int category;

        public UnicodeCategoryHandler(byte category) {
            this.category = category;
        }

        public boolean includes(char c) {
            return Character.getType(c) == this.category;
        }
    }
}

