/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

final class RETokenEnd
extends REToken {
    private String newline;
    private boolean check_java_line_terminators;
    private boolean fake = false;

    RETokenEnd(int subIndex, String newline) {
        super(subIndex);
        this.newline = newline;
        this.check_java_line_terminators = false;
    }

    RETokenEnd(int subIndex, String newline, boolean b) {
        super(subIndex);
        this.newline = newline;
        this.check_java_line_terminators = b;
    }

    void setFake(boolean fake) {
        this.fake = fake;
    }

    int getMaximumLength() {
        return 0;
    }

    boolean match(CharIndexed input, REMatch mymatch) {
        if (!this.fake) {
            return super.match(input, mymatch);
        }
        return super.matchFake(input, mymatch);
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        char ch = input.charAt(mymatch.index);
        if (ch == '\uffff') {
            return (mymatch.eflags & 0x20) > 0 ? null : mymatch;
        }
        if (this.check_java_line_terminators) {
            if (ch == '\n') {
                char ch1 = input.charAt(mymatch.index - 1);
                if (ch1 == '\r') {
                    return null;
                }
                return mymatch;
            }
            if (ch == '\r') {
                return mymatch;
            }
            if (ch == '\u0085') {
                return mymatch;
            }
            if (ch == '\u2028') {
                return mymatch;
            }
            if (ch == '\u2029') {
                return mymatch;
            }
            return null;
        }
        if (this.newline != null) {
            int i = 0;
            do {
                char z;
                if (ch != (z = this.newline.charAt(i))) {
                    return null;
                }
                ch = input.charAt(mymatch.index + ++i);
            } while (i < this.newline.length());
            return mymatch;
        }
        return null;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        REMatch m = (REMatch)mymatch.clone();
        REToken tk = (REToken)this.clone();
        tk.chain(null);
        if (tk.match(input, m)) {
            return max;
        }
        return 0;
    }

    void dump(StringBuffer os) {
        os.append('$');
    }
}

