/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.key.rsa.GnuRSAKey;
import gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec;
import gnu.java.security.key.rsa.RSAKeyPairRawCodec;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class GnuRSAPrivateKey
extends GnuRSAKey
implements PrivateKey,
RSAPrivateCrtKey {
    private final BigInteger p;
    private final BigInteger q;
    private final BigInteger d;
    private final BigInteger dP;
    private final BigInteger dQ;
    private final BigInteger qInv;
    private transient String str;

    public GnuRSAPrivateKey(BigInteger p, BigInteger q, BigInteger e, BigInteger d) {
        this(1, p, q, e, d);
    }

    public GnuRSAPrivateKey(int preferredFormat, BigInteger p, BigInteger q, BigInteger e, BigInteger d) {
        this(preferredFormat, p.multiply(q), e, d, p, q, e.modInverse(p.subtract(BigInteger.ONE)), e.modInverse(q.subtract(BigInteger.ONE)), q.modInverse(p));
    }

    public GnuRSAPrivateKey(int preferredFormat, BigInteger n, BigInteger e, BigInteger d, BigInteger p, BigInteger q, BigInteger dP, BigInteger dQ, BigInteger qInv) {
        super(preferredFormat == 4 ? 3 : preferredFormat, n, e);
        this.d = d;
        this.p = p;
        this.q = q;
        this.dP = dP;
        this.dQ = dQ;
        this.qInv = qInv;
    }

    public static GnuRSAPrivateKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_RSA_PRIVATE_KEY[0]) {
            try {
                return (GnuRSAPrivateKey)new RSAKeyPairRawCodec().decodePrivateKey(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (GnuRSAPrivateKey)new RSAKeyPairPKCS8Codec().decodePrivateKey(k);
    }

    public BigInteger getPrimeP() {
        return this.p;
    }

    public BigInteger getPrimeQ() {
        return this.q;
    }

    public BigInteger getPrimeExponentP() {
        return this.dP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.dQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.qInv;
    }

    public BigInteger getPrivateExponent() {
        return this.d;
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new RSAKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 3: {
                result = new RSAKeyPairPKCS8Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + format);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof RSAPrivateKey) {
            RSAPrivateKey that = (RSAPrivateKey)obj;
            return super.equals(that) && this.d.equals(that.getPrivateExponent());
        }
        if (obj instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey that = (RSAPrivateCrtKey)obj;
            return super.equals(that) && this.p.equals(that.getPrimeP()) && this.q.equals(that.getPrimeQ()) && this.dP.equals(that.getPrimeExponentP()) && this.dQ.equals(that.getPrimeExponentQ()) && this.qInv.equals(that.getCrtCoefficient());
        }
        return false;
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + ls + "d=0x" + "**...*" + ls + "p=0x" + "**...*" + ls + "q=0x" + "**...*" + ls + "dP=0x" + "**...*" + ls + "dQ=0x" + "**...*" + ls + "qInv=0x" + "**...*" + ls + ")";
        }
        return this.str;
    }
}

