/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.Registry;
import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.key.dss.DSSKey;
import gnu.java.security.key.dss.DSSKeyPairPKCS8Codec;
import gnu.java.security.key.dss.DSSKeyPairRawCodec;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;

public class DSSPrivateKey
extends DSSKey
implements PrivateKey,
DSAPrivateKey {
    private final BigInteger x;
    private transient String str;

    public DSSPrivateKey(BigInteger p, BigInteger q, BigInteger g, BigInteger x) {
        this(1, p, q, g, x);
    }

    public DSSPrivateKey(int preferredFormat, BigInteger p, BigInteger q, BigInteger g, BigInteger x) {
        super(preferredFormat == 4 ? 3 : preferredFormat, p, q, g);
        this.x = x;
    }

    public static DSSPrivateKey valueOf(byte[] k) {
        if (k[0] == Registry.MAGIC_RAW_DSS_PRIVATE_KEY[0]) {
            try {
                return (DSSPrivateKey)new DSSKeyPairRawCodec().decodePrivateKey(k);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return (DSSPrivateKey)new DSSKeyPairPKCS8Codec().decodePrivateKey(k);
    }

    public BigInteger getX() {
        return this.x;
    }

    public byte[] getEncoded(int format) {
        byte[] result;
        switch (format) {
            case 1: {
                result = new DSSKeyPairRawCodec().encodePrivateKey(this);
                break;
            }
            case 3: {
                result = new DSSKeyPairPKCS8Codec().encodePrivateKey(this);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding format: " + format);
            }
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DSAPrivateKey)) {
            return false;
        }
        DSAPrivateKey that = (DSAPrivateKey)obj;
        return super.equals(that) && this.x.equals(that.getX());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            this.str = this.getClass().getName() + "(" + super.toString() + "," + ls + "x=0x" + "**...*" + ls + ")";
        }
        return this.str;
    }
}

