/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.action.GetPropertyAction;
import gnu.java.security.util.FormatUtil;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.Key;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;

public abstract class DSSKey
implements Key,
DSAKey {
    protected final BigInteger p;
    protected final BigInteger q;
    protected final BigInteger g;
    protected final int defaultFormat;
    private transient String str;

    protected DSSKey(int defaultFormat, BigInteger p, BigInteger q, BigInteger g) {
        this.defaultFormat = defaultFormat <= 0 ? 1 : defaultFormat;
        this.p = p;
        this.q = q;
        this.g = g;
    }

    public DSAParams getParams() {
        return new DSAParameterSpec(this.p, this.q, this.g);
    }

    public String getAlgorithm() {
        return "dss";
    }

    public byte[] getEncoded() {
        return this.getEncoded(this.defaultFormat);
    }

    public String getFormat() {
        return FormatUtil.getEncodingShortName(this.defaultFormat);
    }

    public boolean equals(Object obj) {
        if (this.hasInheritedParameters()) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DSAKey)) {
            return false;
        }
        DSAKey that = (DSAKey)obj;
        return this.p.equals(that.getParams().getP()) && this.q.equals(that.getParams().getQ()) && this.g.equals(that.getParams().getG());
    }

    public String toString() {
        if (this.str == null) {
            String ls = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
            StringBuilder sb = new StringBuilder(ls).append("defaultFormat=").append(this.defaultFormat).append(",").append(ls);
            if (this.hasInheritedParameters()) {
                sb.append("p=inherited,").append(ls).append("q=inherited,").append(ls).append("g=inherited");
            } else {
                sb.append("p=0x").append(this.p.toString(16)).append(",").append(ls).append("q=0x").append(this.q.toString(16)).append(",").append(ls).append("g=0x").append(this.g.toString(16));
            }
            this.str = sb.toString();
        }
        return this.str;
    }

    public abstract byte[] getEncoded(int var1);

    public boolean hasInheritedParameters() {
        return this.p == null && this.q == null && this.g == null;
    }
}

