/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class SpanFilterResult {
    private BitSet bits;
    private List positions;

    public SpanFilterResult(BitSet bits, List positions) {
        this.bits = bits;
        this.positions = positions;
    }

    public List getPositions() {
        return this.positions;
    }

    public BitSet getBits() {
        return this.bits;
    }

    public static class StartEnd {
        private int start;
        private int end;

        public StartEnd(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getEnd() {
            return this.end;
        }

        public int getStart() {
            return this.start;
        }
    }

    public static class PositionInfo {
        private int doc;
        private List positions;

        public PositionInfo(int doc) {
            this.doc = doc;
            this.positions = new ArrayList();
        }

        public void addPosition(int start, int end) {
            this.positions.add(new StartEnd(start, end));
        }

        public int getDoc() {
            return this.doc;
        }

        public List getPositions() {
            return this.positions;
        }
    }
}

