/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.zip.Deflater;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldsReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;

final class FieldsWriter {
    static final byte FIELD_IS_TOKENIZED = 1;
    static final byte FIELD_IS_BINARY = 2;
    static final byte FIELD_IS_COMPRESSED = 4;
    private FieldInfos fieldInfos;
    private IndexOutput fieldsStream;
    private IndexOutput indexStream;
    private boolean doClose;
    static final /* synthetic */ boolean $assertionsDisabled;

    FieldsWriter(Directory d, String segment, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = d.createOutput(segment + ".fdt");
        this.indexStream = d.createOutput(segment + ".fdx");
        this.doClose = true;
    }

    FieldsWriter(IndexOutput fdx, IndexOutput fdt, FieldInfos fn) throws IOException {
        this.fieldInfos = fn;
        this.fieldsStream = fdt;
        this.indexStream = fdx;
        this.doClose = false;
    }

    void flushDocument(int numStoredFields, RAMOutputStream buffer) throws IOException {
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        this.fieldsStream.writeVInt(numStoredFields);
        buffer.writeTo(this.fieldsStream);
    }

    void flush() throws IOException {
        this.indexStream.flush();
        this.fieldsStream.flush();
    }

    final void close() throws IOException {
        if (this.doClose) {
            this.fieldsStream.close();
            this.indexStream.close();
        }
    }

    final void writeField(FieldInfo fi, Fieldable field) throws IOException {
        boolean disableCompression = field instanceof FieldsReader.FieldForMerge;
        this.fieldsStream.writeVInt(fi.number);
        byte bits = 0;
        if (field.isTokenized()) {
            bits = (byte)(bits | 1);
        }
        if (field.isBinary()) {
            bits = (byte)(bits | 2);
        }
        if (field.isCompressed()) {
            bits = (byte)(bits | 4);
        }
        this.fieldsStream.writeByte(bits);
        if (field.isCompressed()) {
            byte[] data = null;
            data = disableCompression ? field.binaryValue() : (field.isBinary() ? this.compress(field.binaryValue()) : this.compress(field.stringValue().getBytes("UTF-8")));
            int len = data.length;
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, len);
        } else if (field.isBinary()) {
            byte[] data = field.binaryValue();
            int len = data.length;
            this.fieldsStream.writeVInt(len);
            this.fieldsStream.writeBytes(data, len);
        } else {
            this.fieldsStream.writeString(field.stringValue());
        }
    }

    final void addRawDocuments(IndexInput stream, int[] lengths, int numDocs) throws IOException {
        long position;
        long start = position = this.fieldsStream.getFilePointer();
        for (int i = 0; i < numDocs; ++i) {
            this.indexStream.writeLong(position);
            position += (long)lengths[i];
        }
        this.fieldsStream.copyBytes(stream, position - start);
        if (!$assertionsDisabled && this.fieldsStream.getFilePointer() != position) {
            throw new AssertionError();
        }
    }

    final void addDocument(Document doc) throws IOException {
        Fieldable field;
        this.indexStream.writeLong(this.fieldsStream.getFilePointer());
        int storedCount = 0;
        Iterator fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            field = (Fieldable)fieldIterator.next();
            if (!field.isStored()) continue;
            ++storedCount;
        }
        this.fieldsStream.writeVInt(storedCount);
        fieldIterator = doc.getFields().iterator();
        while (fieldIterator.hasNext()) {
            field = (Fieldable)fieldIterator.next();
            if (!field.isStored()) continue;
            this.writeField(this.fieldInfos.fieldInfo(field.name()), field);
        }
    }

    private final byte[] compress(byte[] input) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(input);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        compressor.end();
        return bos.toByteArray();
    }

    static {
        $assertionsDisabled = !FieldsWriter.class.desiredAssertionStatus();
    }
}

