/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.number;

import net.sf.saxon.number.AbstractNumberer;

public class Numberer_nlBE
extends AbstractNumberer {
    private static final long serialVersionUID = 1L;
    private static String[] dutchOrdinalUnits = new String[]{"", "eenste", "tweede", "derde", "vierde", "vijfde", "zesde", "zevende", "achtste", "negende", "tiende", "elfde ", "twaalfde", "dertiende", "veertiende", "vijftiende", "zestiende", "zeventiende", "achtiende", "negentiende"};
    private static String[] dutchOrdinalTens = new String[]{"", "tiende", "twintigste", "dertigste", "veertigste", "vijftigste", "zestigste", "zeventigste", "tachtigste", "negentigste"};
    private static String[] dutchUnits = new String[]{"", "een", "twee", "drie", "vier", "vijf", "zes", "zeven", "acht", "negen", "tien", "elf", "twaalf", "dertien", "veertien", "vijftien", "zestien", "zeventien", "achtien", "negentien"};
    private static String[] dutchTens = new String[]{"", "tien", "twintig", "dertig", "veertig", "vijftig", "zestig", "zeventig", "tachtig", "negentig"};
    private static String[] dutchMonths = new String[]{"januari", "februari", "maart", "april", "mei", "juni", "juli", "augustus", "september", "oktober", "november", "december"};
    private static String[] dutchDays = new String[]{"maandag", "dinsdag", "woensdag", "donderdag", "vrijdag", "zaterdag", "zondag"};
    private static String[] dutchDayAbbreviations = new String[]{"ma", "di", "woe", "do", "vrij", "zat", "zon"};
    private static int[] minUniqueDayLength = new int[]{1, 2, 1, 2, 1, 2, 2};

    public String toOrdinalWords(String ordinalParam, long number, int wordCase) {
        String s;
        if (number == 1000000000L) {
            s = "miljardste";
        } else if (number == 1000000L) {
            s = "miljoenste";
        } else if (number == 1000L) {
            s = "duizendste";
        } else if (number == 100L) {
            s = "honderste";
        } else if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            s = this.toWords(number / 1000000000L) + " miljard" + (rem == 0L ? "" : (rem < 100L ? " en " : " ") + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number >= 1000000L) {
            long rem = number % 1000000L;
            s = this.toWords(number / 1000000L) + " miljoen" + (rem == 0L ? "" : (rem < 100L ? " en " : " ") + this.toOrdinalWords(ordinalParam, rem, wordCase));
        } else if (number >= 1000L) {
            long rem = number % 1000L;
            s = (number / 1000L == 1L ? "" : this.toWords(number / 1000L)) + "duizend" + " " + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else if (number >= 100L) {
            long rem = number % 100L;
            s = (number / 100L == 1L ? "" : this.toWords(number / 100L)) + "honderd" + this.toOrdinalWords(ordinalParam, rem, wordCase);
        } else {
            int rem;
            s = number < 20L ? dutchOrdinalUnits[(int)number] : ((rem = (int)(number % 10L)) == 0 ? dutchOrdinalTens[(int)number / 10] : dutchUnits[rem] + (rem == 2 ? "\u00ebn" : "en") + dutchTens[(int)number / 10] + "ste");
        }
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    public String toWords(long number) {
        if (number >= 1000000000L) {
            long rem = number % 1000000000L;
            return this.toWords(number / 1000000000L) + " miljard" + (rem == 0L ? "" : (rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 1000000L) {
            long rem = number % 1000000L;
            return this.toWords(number / 1000000L) + " miljoen" + (rem == 0L ? "" : (rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 1000L) {
            long rem = number % 1000L;
            return (number / 1000L == 1L ? "" : this.toWords(number / 1000L)) + "duizend" + (rem == 0L ? "" : (rem < 100L ? "en" : " ") + this.toWords(rem));
        }
        if (number >= 100L) {
            long rem = number % 100L;
            return (number / 100L == 1L ? "" : this.toWords(number / 100L)) + "honderd" + this.toWords(rem);
        }
        if (number < 20L) {
            return dutchUnits[(int)number];
        }
        int rem = (int)(number % 10L);
        return (rem == 0 ? "" : dutchUnits[rem]) + (rem == 2 ? "\u00ebn" : "en") + dutchTens[(int)number / 10];
    }

    public String toWords(long number, int wordCase) {
        String s = number == 0L ? "nul" : this.toWords(number);
        if (wordCase == 0) {
            return s.toUpperCase();
        }
        if (wordCase == 1) {
            return s.toLowerCase();
        }
        return s;
    }

    public String monthName(int month, int minWidth, int maxWidth) {
        String name = dutchMonths[month - 1];
        if (maxWidth < 3) {
            maxWidth = 3;
        }
        if (name.length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        return name;
    }

    public String dayName(int day, int minWidth, int maxWidth) {
        String name = dutchDays[day - 1];
        if (maxWidth < 2) {
            maxWidth = 2;
        }
        if (name.length() > maxWidth && (name = dutchDayAbbreviations[day - 1]).length() > maxWidth) {
            name = name.substring(0, maxWidth);
        }
        while (name.length() < minWidth) {
            name = name + ' ';
        }
        if (minWidth == 1 && maxWidth == 2) {
            name = name.substring(0, minUniqueDayLength[day - 1]);
        }
        return name;
    }

    public String halfDayName(int minutes, int minWidth, int maxWidth) {
        String s;
        if (minutes < 720) {
            switch (maxWidth) {
                case 1: {
                    s = "v";
                    break;
                }
                case 2: 
                case 3: {
                    s = "vm";
                    break;
                }
                default: {
                    s = "v.m.";
                    break;
                }
            }
        } else {
            switch (maxWidth) {
                case 1: {
                    s = "n";
                    break;
                }
                case 2: 
                case 3: {
                    s = "nm";
                    break;
                }
                default: {
                    s = "n.m.";
                }
            }
        }
        return s;
    }

    public String getEraName(int year) {
        return year > 0 ? "n.C." : "v.C.";
    }
}

