/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.StringTokenizer;
import net.sf.saxon.Err;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.trans.XPathException;

public class SaxonOutputKeys {
    public static final String SAXON_XQUERY_METHOD = "{http://saxon.sf.net/}xquery";
    public static final String INDENT_SPACES = "{http://saxon.sf.net/}indent-spaces";
    public static final String SUPPRESS_INDENTATION = "{http://saxon.sf.net/}suppress-indentation";
    public static final String STYLESHEET_VERSION = "{http://saxon.sf.net/}stylesheet-version";
    public static final String USE_CHARACTER_MAPS = "use-character-maps";
    public static final String INCLUDE_CONTENT_TYPE = "include-content-type";
    public static final String UNDECLARE_PREFIXES = "undeclare-prefixes";
    public static final String ESCAPE_URI_ATTRIBUTES = "escape-uri-attributes";
    public static final String CHARACTER_REPRESENTATION = "{http://saxon.sf.net/}character-representation";
    public static final String NEXT_IN_CHAIN = "{http://saxon.sf.net/}next-in-chain";
    public static final String NEXT_IN_CHAIN_BASE_URI = "{http://saxon.sf.net/}next-in-chain-base-uri";
    public static final String BYTE_ORDER_MARK = "byte-order-mark";
    public static final String NORMALIZATION_FORM = "normalization-form";
    public static final String SUPPLY_SOURCE_LOCATOR = "{http://saxon.sf.net/}supply-source-locator";
    public static final String REQUIRE_WELL_FORMED = "{http://saxon.sf.net/}require-well-formed";
    public static final String WRAP = "{http://saxon.sf.net/}wrap-result-sequence";
    public static final String IMPLICIT_RESULT_DOCUMENT = "{http://saxon.sf.net/}implicit-result-document";

    private SaxonOutputKeys() {
    }

    public static void checkOutputProperty(String key, String value, NameChecker checker) throws XPathException {
        if (!key.startsWith("{") || key.startsWith("{http://saxon.sf.net/}")) {
            if (key.equals("cdata-section-elements")) {
                if (value != null) {
                    SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                }
            } else if (!(key.equals("doctype-public") || key.equals("doctype-system") || key.equals("encoding"))) {
                if (key.equals("indent")) {
                    if (value != null) {
                        SaxonOutputKeys.checkYesOrNo(key, value);
                    }
                } else if (!key.equals("media-type")) {
                    if (key.equals("method")) {
                        if (value != null) {
                            SaxonOutputKeys.checkMethod(value, checker);
                        }
                    } else if (key.equals("omit-xml-declaration")) {
                        if (value != null) {
                            SaxonOutputKeys.checkYesOrNo(key, value);
                        }
                    } else if (key.equals("standalone")) {
                        if (value != null && !value.equals("omit")) {
                            SaxonOutputKeys.checkYesOrNo(key, value);
                        }
                    } else if (!key.equals("version") && !key.equals(STYLESHEET_VERSION)) {
                        if (key.equals(INDENT_SPACES)) {
                            if (value != null) {
                                SaxonOutputKeys.checkNonNegativeInteger(key, value);
                            }
                        } else if (key.equals(INCLUDE_CONTENT_TYPE)) {
                            if (value != null) {
                                SaxonOutputKeys.checkYesOrNo(key, value);
                            }
                        } else if (key.equals(ESCAPE_URI_ATTRIBUTES) || key.equals("escape-uri-attibutes")) {
                            if (value != null) {
                                SaxonOutputKeys.checkYesOrNo(key, value);
                            }
                        } else if (key.equals(NORMALIZATION_FORM)) {
                            if (value != null) {
                                SaxonOutputKeys.checkNormalizationForm(value);
                            }
                        } else if (!(key.equals(CHARACTER_REPRESENTATION) || key.equals(NEXT_IN_CHAIN) || key.equals(NEXT_IN_CHAIN_BASE_URI))) {
                            if (key.equals(UNDECLARE_PREFIXES)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(USE_CHARACTER_MAPS)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                                }
                            } else if (key.equals(REQUIRE_WELL_FORMED)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(SUPPRESS_INDENTATION)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkListOfClarkNames(key, value, checker);
                                }
                            } else if (key.equals(BYTE_ORDER_MARK)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(WRAP)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else if (key.equals(SUPPLY_SOURCE_LOCATOR)) {
                                if (value != null) {
                                    SaxonOutputKeys.checkYesOrNo(key, value);
                                }
                            } else {
                                throw new XPathException("Unknown serialization parameter " + Err.wrap(key));
                            }
                        }
                    }
                }
            }
        }
    }

    private static void checkYesOrNo(String key, String value) throws XPathException {
        if (!"yes".equals(value) && !"no".equals(value)) {
            throw new XPathException("Serialization parameter " + Err.wrap(key) + " must have the value yes or no");
        }
    }

    private static void checkMethod(String value, NameChecker checker) throws XPathException {
        if ("xml".equals(value)) {
            return;
        }
        if ("html".equals(value)) {
            return;
        }
        if ("xhtml".equals(value)) {
            return;
        }
        if ("text".equals(value)) {
            return;
        }
        if (SaxonOutputKeys.isValidClarkName(value, checker)) {
            return;
        }
        throw new XPathException("Invalid value for serialization method: must be xml, html, xhtml, text, or a QName in '{uri}local' form");
    }

    private static void checkNormalizationForm(String value) throws XPathException {
        if ("NFC".equals(value)) {
            return;
        }
        if ("NFD".equals(value)) {
            return;
        }
        if ("NFKC".equals(value)) {
            return;
        }
        if ("NFKD".equals(value)) {
            return;
        }
        if ("fully-normalized".equals(value)) {
            return;
        }
        if ("none".equals(value)) {
            return;
        }
        throw new XPathException("Invalid value for normalization-form: must be NFC, NFD, NFKC, NFKD, fully-normalized, or none");
    }

    private static boolean isValidClarkName(String value, NameChecker checker) {
        if (value.charAt(0) != '{') {
            return false;
        }
        int closer = value.indexOf(125);
        return closer >= 2 && closer != value.length() - 1 && checker.isValidNCName(value.substring(closer + 1));
    }

    private static void checkNonNegativeInteger(String key, String value) throws XPathException {
        try {
            int n = Integer.parseInt(value);
            if (n < 0) {
                throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer");
            }
        }
        catch (NumberFormatException err) {
            throw new XPathException("Value of " + Err.wrap(key) + " must be a non-negative integer");
        }
    }

    private static void checkListOfClarkNames(String key, String value, NameChecker checker) throws XPathException {
        StringTokenizer tok = new StringTokenizer(value, " \t\n\r", false);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (SaxonOutputKeys.isValidClarkName(s, checker) || checker.isValidNCName(s)) continue;
            throw new XPathException("Value of " + Err.wrap(key) + " must be a list of QNames in '{uri}local' notation");
        }
    }
}

